/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.informatica;

public class ConsoleLogger {
    public static final String DIVIDER = "-------------------------------------------------------------";
    private static LogMode logMode = LogMode.NORMAL;

    public static boolean isDebug() {
        return logMode == LogMode.DEBUG;
    }

    public static void print(String string) {
        System.out.print(string);
    }

    public static void printDebug(String string) {
        if (ConsoleLogger.isDebug()) {
            System.out.print(string);
        }
    }

    public static void println(String string) {
        System.out.println(string);
    }

    public static void println() {
        System.out.println();
    }

    public static void printlnDebug(String string) {
        if (ConsoleLogger.isDebug()) {
            System.out.println(string);
        }
    }

    public static void printlnDebug() {
        if (ConsoleLogger.isDebug()) {
            System.out.println();
        }
    }

    static {
        logMode = LogMode.NORMAL;
        try {
            String string = System.getenv("DEBUG_INFORMATICA");
            if (string != null && string.trim().equalsIgnoreCase("true")) {
                logMode = LogMode.DEBUG;
            }
        }
        catch (Exception exception) {
            System.out.println("Error initializing ConsoleLogger.");
            exception.printStackTrace();
        }
    }

    static enum LogMode {
        NORMAL,
        DEBUG;

    }
}

