/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.TimeHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;

public class TimeHelperTest
extends TestCase {
    private Date date;

    protected void setUp() throws Exception {
        super.setUp();
        this.date = new Date();
        this.date.setTime(0L);
    }

    protected void tearDown() throws Exception {
        this.date = null;
        super.tearDown();
    }

    public void testIsWithinRange() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(2010, 6, 26, 12, 0, 0);
        this.date = calendar.getTime();
        int n = 20100726;
        int n2 = 1000;
        int n3 = 1500;
        TimeHelperTest.assertTrue((boolean)TimeHelper.isWithinRange(calendar, n, n2, n3));
        calendar.set(10, 16);
        TimeHelperTest.assertFalse((boolean)TimeHelper.isWithinRange(calendar, n, n2, n3));
        n = 20100728;
        calendar.set(10, 13);
        TimeHelperTest.assertFalse((boolean)TimeHelper.isWithinRange(calendar, n, n2, n3));
    }

    public void testIsWithinRange_EndOfHour() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        int n = 2015;
        int n2 = 6;
        int n3 = 24;
        this.date = calendar.getTime();
        int n4 = 20150724;
        int n5 = 2300;
        int n6 = 2359;
        calendar.clear();
        calendar.set(n, n2, n3, 22, 59, 59);
        calendar.set(14, 999);
        TimeHelperTest.assertFalse((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
        calendar.clear();
        calendar.set(n, n2, n3, 23, 0, 0);
        TimeHelperTest.assertTrue((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
        calendar.clear();
        calendar.set(n, n2, n3, 23, 0, 1);
        TimeHelperTest.assertTrue((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
        calendar.clear();
        calendar.set(n, n2, n3, 23, 59, 59);
        calendar.set(14, 999);
        TimeHelperTest.assertTrue((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
        calendar.clear();
        calendar.set(n, n2, n3 + 1, 0, 0, 0);
        TimeHelperTest.assertFalse((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
        n5 = 2359;
        n6 = 159;
        calendar.clear();
        calendar.set(n, n2, n3, 22, 59, 59);
        calendar.set(14, 999);
        TimeHelperTest.assertFalse((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
        calendar.clear();
        calendar.set(n, n2, n3, 23, 59, 0);
        TimeHelperTest.assertTrue((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
        calendar.clear();
        calendar.set(n, n2, n3, 23, 59, 0);
        calendar.set(14, 1);
        TimeHelperTest.assertTrue((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
        calendar.clear();
        calendar.set(n, n2, n3 + 1, 1, 59, 59);
        calendar.set(14, 999);
        TimeHelperTest.assertTrue((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
        calendar.clear();
        calendar.set(n, n2, n3 + 1, 2, 0, 0);
        TimeHelperTest.assertFalse((boolean)TimeHelper.isWithinRange(calendar, n4, n5, n6));
    }

    public void testIsWithinRangeNullCalendar() {
        Calendar calendar = null;
        int n = 20100726;
        int n2 = 1000;
        int n3 = 1500;
        TimeHelperTest.assertFalse((boolean)TimeHelper.isWithinRange(calendar, n, n2, n3));
    }

    public void testIsWithinRangeWithMovedFromDateTime() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(2010, 6, 26, 12, 0, 0);
        long l = 0L;
        int n = 20100726;
        int n2 = 1000;
        int n3 = 1500;
        TimeHelperTest.assertTrue((boolean)TimeHelper.isWithinRange(calendar, l, n, n2, n3));
        calendar.set(10, 16);
        TimeHelperTest.assertFalse((boolean)TimeHelper.isWithinRange(calendar, l, n, n2, n3));
        l = calendar.getTimeInMillis();
        calendar.set(10, 13);
        TimeHelperTest.assertFalse((boolean)TimeHelper.isWithinRange(calendar, l, n, n2, n3));
    }

    public void testFormatDateDate() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(2010, 6, 26, 12, 0, 0);
        this.date = calendar.getTime();
        String string = TimeHelper.formatDate(this.date);
        String string2 = "7/26/10 12:00:00 PM CDT";
        TimeHelperTest.assertEquals((String)string2, (String)string);
    }

    public void testFormatDateLong() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(2010, 6, 26, 12, 0, 0);
        long l = calendar.getTimeInMillis();
        String string = TimeHelper.formatDate(l);
        String string2 = "7/26/10 12:00:00 PM CDT";
        TimeHelperTest.assertEquals((String)string2, (String)string);
    }

    public void testFormatDateCalendar() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(2010, 6, 26, 12, 0, 0);
        String string = TimeHelper.formatDate(calendar);
        String string2 = "7/26/10 12:00:00 PM CDT";
        TimeHelperTest.assertEquals((String)string2, (String)string);
    }

    public void testFormatDateCalendarTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(2010, 6, 26, 12, 0, 0);
        String string = TimeHelper.formatDate(calendar, timeZone);
        String string2 = "7/26/10 12:00:00 PM CDT";
        TimeHelperTest.assertEquals((String)string2, (String)string);
    }

    public void testFormatDateLongTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(2010, 6, 26, 12, 0, 0);
        long l = calendar.getTimeInMillis();
        String string = TimeHelper.formatDate(l, timeZone);
        String string2 = "7/26/10 12:00:00 PM CDT";
        TimeHelperTest.assertEquals((String)string2, (String)string);
        l = 0L;
        string = TimeHelper.formatDate(l, timeZone);
        string2 = "** Zero Time **";
        TimeHelperTest.assertEquals((String)string2, (String)string);
    }

    public void testFormatDateDateTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(2010, 6, 26, 12, 0, 0);
        this.date = calendar.getTime();
        String string = TimeHelper.formatDate(this.date, timeZone);
        String string2 = "7/26/10 12:00:00 PM CDT";
        TimeHelperTest.assertEquals((String)string2, (String)string);
    }
}

