/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.TimeHelper;
import com.helpsystems.enterprise.core.busobj.WindowEndOption;
import com.helpsystems.enterprise.core.busobj.WindowStartOption;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class ReactivityDateObject {
    private static final Logger LOGGER = Logger.getLogger(ReactivityDateObject.class);
    private long id;
    private long jobID;
    private DateObject dateObject;
    private int endTime;
    private int startTime;
    private WindowStartOption startOption = WindowStartOption.DO_NOTHING;
    private WindowEndOption endOption = WindowEndOption.DO_NOTHING;

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getJobID() {
        return this.jobID;
    }

    public void setJobID(long l) {
        this.jobID = l;
    }

    public DateObject getDateObject() {
        return this.dateObject;
    }

    public void setDateObject(DateObject dateObject) {
        this.dateObject = dateObject;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int n) {
        this.endTime = n;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int n) {
        this.startTime = n;
    }

    public WindowStartOption getStartOption() {
        return this.startOption;
    }

    public void setStartOption(WindowStartOption windowStartOption) {
        this.startOption = windowStartOption;
    }

    public WindowEndOption getEndOption() {
        return this.endOption;
    }

    public void setEndOption(WindowEndOption windowEndOption) {
        this.endOption = windowEndOption;
    }

    public boolean isTimeAccepted(Calendar calendar, CalendarObject calendarObject) {
        boolean bl;
        int n = calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar);
        if (this.dateObject == null) {
            bl = false;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("DateObject is null in ReactivtyDateObject (" + this.getId() + ")."));
            }
        } else if (this.instanceIsSelected(calendar, n)) {
            bl = true;
        } else if (this.timeRangeSpansMidnight()) {
            n = this.dateBefore(calendar, calendarObject);
            bl = TimeHelper.isWithinRange(calendar, n, this.startTime, this.endTime);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean instanceIsSelected(Calendar calendar, int n) {
        boolean bl = !this.dateObject.contains(n) ? false : TimeHelper.isWithinRange(calendar, n, this.startTime, this.endTime);
        return bl;
    }

    private int dateBefore(Calendar calendar, CalendarObject calendarObject) {
        Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        calendar2.setTimeInMillis(calendar.getTimeInMillis());
        calendar2.add(5, -1);
        return calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar2);
    }

    private boolean timeRangeSpansMidnight() {
        return this.startTime > this.endTime;
    }
}

