/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.TargetVersionInfo;
import com.helpsystems.enterprise.core.busobj.DirectoryEvent;
import com.helpsystems.enterprise.core.busobj.ManualEvent;
import junit.framework.TestCase;

public class ManualEventTest
extends TestCase {
    private ManualEvent me;

    protected void setUp() throws Exception {
        super.setUp();
        this.me = new ManualEvent();
    }

    protected void tearDown() throws Exception {
        this.me = null;
        super.tearDown();
    }

    public void testTypeDescription() {
        ManualEventTest.assertEquals((String)"Manual Event", (String)this.me.getTypeDescription());
    }

    public void testVersioning() {
        TargetVersionInfo targetVersionInfo = new TargetVersionInfo();
        this.me.fillInVersion(targetVersionInfo);
        ManualEventTest.assertEquals((int)200, (int)targetVersionInfo.getVersion(1));
    }

    public void testIsDifferentThan() {
        this.me.setTargetID(12345L);
        this.me.setName("Event1");
        this.me.setDescription("A test event");
        this.me.setProductIIDInt(9494);
        this.me.setDisabled(true);
        this.me.setCycle(666);
        this.me.setOID(58493L);
        this.me.setFromTime(1234);
        this.me.setToTime(2468);
        DirectoryEvent directoryEvent = new DirectoryEvent();
        ManualEventTest.assertTrue((boolean)this.me.isDifferentThan(directoryEvent));
        ManualEvent manualEvent = new ManualEvent();
        ManualEventTest.assertTrue((boolean)this.me.isDifferentThan(manualEvent));
        manualEvent.setTargetID(12345L);
        manualEvent.setName("Event1");
        manualEvent.setDescription("A test event");
        manualEvent.setProductIIDInt(9494);
        manualEvent.setDisabled(true);
        manualEvent.setCycle(666);
        manualEvent.setOID(58493L);
        manualEvent.setFromTime(1234);
        manualEvent.setToTime(2468);
        ManualEventTest.assertFalse((boolean)this.me.isDifferentThan(manualEvent));
    }
}

