/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.JobMonitor;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import junit.framework.TestCase;

public class JobMonitorEventTest
extends TestCase {
    private JobMonitorEvent event;
    private static final String NAME_UNDERRUN = "Job Underrun";
    private static final String NAME_OVERRUN = "Job Overrun";
    private static final String NAME_LATE_START = "Job Late Start";

    protected void setUp() throws Exception {
        super.setUp();
        this.event = new JobMonitorEvent();
    }

    protected void tearDown() throws Exception {
        this.event = null;
        super.tearDown();
    }

    public void testSetID() {
        this.event.setID(123456L);
        JobMonitorEventTest.assertEquals((long)123456L, (long)this.event.getID());
    }

    public void testSetTimeDetected() {
        long l = System.currentTimeMillis();
        this.event.setTimeDetected(l);
        JobMonitorEventTest.assertEquals((long)l, (long)this.event.getTimeDetected());
    }

    public void testSetScheduledTime() {
        long l = System.currentTimeMillis();
        this.event.setScheduledTime(l);
        JobMonitorEventTest.assertEquals((long)l, (long)this.event.getScheduledTime());
    }

    public void testSetJobID() {
        this.event.setJobID(234567L);
        JobMonitorEventTest.assertEquals((long)234567L, (long)this.event.getJobID());
    }

    public void testSetAgentID() {
        this.event.setAgentID(65432L);
        JobMonitorEventTest.assertEquals((long)65432L, (long)this.event.getAgentID());
    }

    public void testSetAgentName() {
        this.event.setAgentName("agent_name");
        JobMonitorEventTest.assertEquals((String)"agent_name", (String)this.event.getAgentName());
    }

    public void testSetRuntimeJobName() {
        this.event.setRuntimeJobName("job_name");
        JobMonitorEventTest.assertEquals((String)"job_name", (String)this.event.getRuntimeJobName());
    }

    public void testSetJobRunID() {
        this.event.setJobRunID(58746L);
        JobMonitorEventTest.assertEquals((long)58746L, (long)this.event.getJobRunID());
    }

    public void testSetNotificationListID() {
        this.event.setNotificationListID(345789L);
        JobMonitorEventTest.assertEquals((long)345789L, (long)this.event.getNotificationListID());
    }

    public void testSetEventType() {
        int n = JobMonitor.MonitorType.UNDERRUN.persistanceCode();
        this.event.setEventType(n);
        JobMonitorEventTest.assertEquals((int)n, (int)this.event.getEventType());
        try {
            this.event.setEventType(923384);
            JobMonitorEventTest.fail((String)"setEventType() allowed bad event type value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetActions() {
        this.event.setActions(123456);
        JobMonitorEventTest.assertEquals((int)123456, (int)this.event.getActions());
    }

    public void testSetActionData() {
        this.event.setActionData("action_data");
        JobMonitorEventTest.assertEquals((String)"action_data", (String)this.event.getActionData());
    }

    public void testActionFlagsSetBySetActions() {
        JobMonitorEvent jobMonitorEvent = new JobMonitorEvent();
        jobMonitorEvent.setActions(16);
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionEmail());
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionEnd());
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionTrap());
        jobMonitorEvent.setActions(272);
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionEmail());
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionEnd());
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionTrap());
        jobMonitorEvent.setActions(273);
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionEmail());
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionEnd());
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionTrap());
        jobMonitorEvent.setActions(257);
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionEmail());
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionEnd());
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionTrap());
        jobMonitorEvent.setActions(256);
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionEmail());
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionEnd());
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionTrap());
        jobMonitorEvent.setActions(1);
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionEmail());
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionEnd());
        JobMonitorEventTest.assertTrue((boolean)jobMonitorEvent.isActionTrap());
        jobMonitorEvent.setActions(0);
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionEmail());
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionEnd());
        JobMonitorEventTest.assertFalse((boolean)jobMonitorEvent.isActionTrap());
    }

    public void testGetEventTypeDescription() {
        this.event.setEventType(JobMonitor.MonitorType.UNDERRUN.persistanceCode());
        JobMonitorEventTest.assertEquals((String)NAME_UNDERRUN, (String)this.event.getEventTypeDescription());
        this.event.setEventType(JobMonitor.MonitorType.OVERRUN.persistanceCode());
        JobMonitorEventTest.assertEquals((String)NAME_OVERRUN, (String)this.event.getEventTypeDescription());
        this.event.setEventType(JobMonitor.MonitorType.LATESTART.persistanceCode());
        JobMonitorEventTest.assertEquals((String)NAME_LATE_START, (String)this.event.getEventTypeDescription());
    }

    public void testGetTypeDescription() {
        JobMonitorEventTest.assertEquals((String)NAME_UNDERRUN, (String)JobMonitorEvent.getTypeDescription(1));
        JobMonitorEventTest.assertEquals((String)NAME_OVERRUN, (String)JobMonitorEvent.getTypeDescription(2));
        JobMonitorEventTest.assertEquals((String)NAME_LATE_START, (String)JobMonitorEvent.getTypeDescription(3));
        JobMonitorEventTest.assertEquals((String)"Unsupported type: 234789", (String)JobMonitorEvent.getTypeDescription(234789));
    }

    public void testConstructorWithJobMonitor() {
        JobMonitor jobMonitor = new JobMonitor();
        jobMonitor.setMonitorType(JobMonitor.MonitorType.OVERRUN);
        jobMonitor.setJobID(12345L);
        jobMonitor.setJobHistoryID(34567L);
        jobMonitor.setAgentID(56789L);
        jobMonitor.setScheduledTime(23456789L);
        this.event = new JobMonitorEvent(jobMonitor);
        int n = jobMonitor.getMonitorType().persistanceCode();
        JobMonitorEventTest.assertEquals((int)n, (int)this.event.getEventType());
        JobMonitorEventTest.assertEquals((long)jobMonitor.getJobID(), (long)this.event.getJobID());
        JobMonitorEventTest.assertEquals((long)jobMonitor.getJobHistoryID(), (long)this.event.getJobRunID());
        JobMonitorEventTest.assertEquals((long)jobMonitor.getAgentID(), (long)this.event.getAgentID());
        JobMonitorEventTest.assertEquals((long)jobMonitor.getScheduledTime(), (long)this.event.getScheduledTime());
    }
}

