/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.JobMissedCode;
import com.helpsystems.enterprise.core.busobj.JobReactCode;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;

public class JobHistory
extends CommonVersionedObject {
    private static final long serialVersionUID = -558988551105679634L;
    private static final int MAX_JOB_NAME_LEN = 50;
    private long id;
    private long jobID;
    private String jobName = "";
    private long agentID;
    private String agentName = "";
    private long jobQueueID;
    private String jobQueueName = "";
    private JobStatusCode statusCode = JobStatusCode.INITIATED;
    private long scheduledTime;
    private long serverInitiatedTime;
    private long serverSubmittedTime;
    private long serverRunningTime;
    private long serverEndedTime;
    private long agentStartedTime;
    private long agentEndedTime;
    private long queueEndedTime;
    private int startAtCommandSequence = 1;
    private long restartParentHistoryID;
    private long restartChildHistoryID;
    private JobReactCode reactCode = JobReactCode.PERFORM_REACTIVITY;
    private JobInitCode initiationCode = JobInitCode.SCHEDULE;
    private String initiationData = "";
    private int failedAtCommandSequence = 0;
    private JobMissedCode missedCode = JobMissedCode.NOT_MISSED;
    private boolean copiedJobLogToServer = false;
    private boolean manuallyStarted = false;
    private JobEndedReasonCode endedReasonCode = null;
    private boolean bypassJobMonitors = false;
    private String terminationData = "";
    private boolean bypassConditions = false;
    private String timezoneType;
    private String agentTimezone;
    private String jobTimezone;
    private long agentGroupID = 0L;
    private String agentGroupName = "";
    private long jobSuiteHistoryID;
    private long jobSuiteMemberID;
    private long jobSuiteMemberInstanceID;
    private long jobSuiteID = 0L;
    private String jobSuiteName = "";
    private int jobPriority;
    private boolean clearPrereqStatus = false;
    private long movedFromScheduledDateTime = 0L;
    private int retryNumber = 0;
    private long retryNextTime;
    private boolean subsequentSubmit;
    private String agentEnvironmentType;
    private String iBMiJobName;
    private String iBMiJobUser;
    private String iBMiJobNumber;
    private boolean needToCheckIfJobRunHasStarted;
    private String jobParameters;
    private String defaultSuiteParameters;
    private long estimatedRuntime;

    public static String buildOverridenJobName(String string, String string2) {
        if (string2 != null && string2.trim().length() > 0) {
            String string3 = string2.trim();
            if (string3.length() > 50) {
                string3 = string3.substring(0, 50);
            }
            return string3;
        }
        if (string != null) {
            return string;
        }
        throw new NullPointerException("Default job name is null.");
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getJobID() {
        return this.jobID;
    }

    public void setJobID(long l) {
        this.jobID = l;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String string) {
        this.jobName = string;
    }

    public long getAgentID() {
        return this.agentID;
    }

    public void setAgentID(long l) {
        this.agentID = l;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String string) {
        this.agentName = string;
    }

    public long getJobQueueID() {
        return this.jobQueueID;
    }

    public void setJobQueueID(long l) {
        this.jobQueueID = l;
    }

    public String getJobQueueName() {
        return this.jobQueueName;
    }

    public void setJobQueueName(String string) {
        this.jobQueueName = string;
    }

    public JobStatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(JobStatusCode jobStatusCode) {
        this.statusCode = jobStatusCode;
    }

    public String getStatusCode_asText() {
        return this.statusCode.toString();
    }

    public String getStatusCode_asStr() {
        return this.statusCode.persistanceCode();
    }

    public void setStatusCode_asStr(String string) {
        this.statusCode = JobStatusCode.persistanceCodeToEnum(string);
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(long l) {
        this.scheduledTime = l;
    }

    public long getServerInitiatedTime() {
        return this.serverInitiatedTime;
    }

    public void setServerInitiatedTime(long l) {
        this.serverInitiatedTime = l;
    }

    public long getServerSubmittedTime() {
        return this.serverSubmittedTime;
    }

    public void setServerSubmittedTime(long l) {
        this.serverSubmittedTime = l;
    }

    public long getServerRunningTime() {
        return this.serverRunningTime;
    }

    public void setServerRunningTime(long l) {
        this.serverRunningTime = l;
    }

    public long getServerEndedTime() {
        return this.serverEndedTime;
    }

    public void setServerEndedTime(long l) {
        this.serverEndedTime = l;
    }

    public long getAgentStartedTime() {
        return this.agentStartedTime;
    }

    public void setAgentStartedTime(long l) {
        this.agentStartedTime = l;
    }

    public long getAgentEndedTime() {
        return this.agentEndedTime;
    }

    public void setAgentEndedTime(long l) {
        this.agentEndedTime = l;
    }

    public long getQueueEndedTime() {
        return this.queueEndedTime;
    }

    public void setQueueEndedTime(long l) {
        this.queueEndedTime = l;
    }

    public int getStartAtCommandSequence() {
        return this.startAtCommandSequence;
    }

    public void setStartAtCommandSequence(int n) {
        this.startAtCommandSequence = n;
    }

    public String getInitiationData() {
        return this.initiationData;
    }

    public void setInitiationData(String string) {
        this.initiationData = string;
    }

    public long getRestartParentHistoryID() {
        return this.restartParentHistoryID;
    }

    public void setRestartParentHistoryID(long l) {
        this.restartParentHistoryID = l;
    }

    public long getRestartChildHistoryID() {
        return this.restartChildHistoryID;
    }

    public void setRestartChildHistoryID(long l) {
        this.restartChildHistoryID = l;
    }

    public JobReactCode getReactCode() {
        return this.reactCode;
    }

    public void setReactCode(JobReactCode jobReactCode) {
        this.reactCode = jobReactCode;
    }

    public int getReactCode_asInt() {
        return this.reactCode.persistanceCode();
    }

    public void setReactCode_asInt(int n) {
        this.reactCode = JobReactCode.persistanceCodeToEnum(n);
    }

    public JobInitCode getInitiationCode() {
        return this.initiationCode;
    }

    public void setInitiationCode(JobInitCode jobInitCode) {
        this.initiationCode = jobInitCode;
    }

    public int getInitiationCode_asInt() {
        return this.initiationCode.persistanceCode();
    }

    public void setInitiationCode_asInt(int n) {
        this.initiationCode = JobInitCode.persistanceCodeToEnum(n);
    }

    public int getFailedAtCommandSequence() {
        return this.failedAtCommandSequence;
    }

    public void setFailedAtCommandSequence(int n) {
        this.failedAtCommandSequence = n;
    }

    public JobMissedCode getMissedCode() {
        return this.missedCode;
    }

    public void setMissedCode(JobMissedCode jobMissedCode) {
        this.missedCode = jobMissedCode;
    }

    public int getMissedCode_asInt() {
        return this.missedCode.persistanceCode();
    }

    public void setMissedCode_asInt(int n) {
        this.missedCode = JobMissedCode.persistanceCodeToEnum(n);
    }

    public JobEndedReasonCode getJobEndedReasonCode() {
        return this.endedReasonCode;
    }

    public void setJobEndedReasonCode(JobEndedReasonCode jobEndedReasonCode) {
        this.endedReasonCode = jobEndedReasonCode;
    }

    public String getJobEndedReasonCode_asString() {
        if (this.endedReasonCode == null) {
            return null;
        }
        return this.endedReasonCode.persistanceCode();
    }

    public void setJobEndedReasonCode_asString(String string) {
        this.endedReasonCode = string != null && string.trim().length() > 0 ? JobEndedReasonCode.persistanceCodeToEnum(string) : null;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        if (object == null || !((Object)((Object)this)).getClass().equals(object.getClass())) {
            return false;
        }
        JobHistory jobHistory = (JobHistory)((Object)object);
        return super.equals(object) && Equal.isEqual((long)this.id, (long)jobHistory.id) && Equal.isEqual((long)this.jobID, (long)jobHistory.jobID) && Equal.isEqual((long)this.agentID, (long)jobHistory.agentID);
    }

    public void setCopiedJobLogToServer(boolean bl) {
        this.copiedJobLogToServer = bl;
    }

    public boolean getCopiedJobLogToServer() {
        return this.copiedJobLogToServer;
    }

    public boolean isCopiedJobLogToServer() {
        return this.copiedJobLogToServer;
    }

    public void setManuallyStarted(boolean bl) {
        this.manuallyStarted = bl;
    }

    public boolean isManuallyStarted() {
        return this.manuallyStarted;
    }

    public boolean isClearPrereqStatus() {
        return this.clearPrereqStatus;
    }

    public void setClearPrereqStatus(boolean bl) {
        this.clearPrereqStatus = bl;
    }

    public long getMovedFromScheduledDateTime() {
        return this.movedFromScheduledDateTime;
    }

    public void setMovedFromScheduledDateTime(long l) {
        this.movedFromScheduledDateTime = l;
    }

    public boolean getBypassJobMonitors() {
        return this.isBypassJobMonitors();
    }

    public boolean isBypassJobMonitors() {
        return this.bypassJobMonitors;
    }

    public void setBypassJobMonitors(boolean bl) {
        this.bypassJobMonitors = bl;
    }

    public int getRetryNumber() {
        return this.retryNumber;
    }

    public void setRetryNumber(int n) {
        this.retryNumber = n;
    }

    public long getRetryNextTime() {
        return this.retryNextTime;
    }

    public void setRetryNextTime(long l) {
        this.retryNextTime = l;
    }

    public String getTerminationData() {
        return this.terminationData;
    }

    public void setTerminationData(String string) {
        this.terminationData = string;
    }

    public boolean isBypassConditions() {
        return this.bypassConditions;
    }

    public void setBypassConditions(boolean bl) {
        this.bypassConditions = bl;
    }

    public String getAgentTimezone() {
        return this.agentTimezone;
    }

    public void setAgentTimezone(String string) {
        this.agentTimezone = string;
    }

    public String getJobTimezone() {
        return this.jobTimezone;
    }

    public void setJobTimezone(String string) {
        this.jobTimezone = string;
    }

    public String getTimezoneType() {
        return this.timezoneType;
    }

    public void setTimezoneType(String string) {
        this.timezoneType = string;
    }

    public long getAgentGroupID() {
        return this.agentGroupID;
    }

    public void setAgentGroupID(long l) {
        this.agentGroupID = l;
    }

    public String getAgentGroupName() {
        return this.agentGroupName;
    }

    public void setAgentGroupName(String string) {
        this.agentGroupName = string;
    }

    public int getJobPriority() {
        return this.jobPriority;
    }

    public void setJobPriority(int n) {
        this.jobPriority = n;
    }

    public long getJobSuiteHistoryID() {
        return this.jobSuiteHistoryID;
    }

    public void setJobSuiteHistoryID(long l) {
        this.jobSuiteHistoryID = l;
    }

    public boolean isJobSuiteMember() {
        return this.jobSuiteMemberID != 0L;
    }

    public boolean isJobSuite() {
        return this.jobSuiteID != 0L && this.jobSuiteMemberID == 0L;
    }

    public long getJobSuiteMemberID() {
        return this.jobSuiteMemberID;
    }

    public void setJobSuiteMemberID(long l) {
        this.jobSuiteMemberID = l;
    }

    public long getJobSuiteMemberInstanceID() {
        return this.jobSuiteMemberInstanceID;
    }

    public void setJobSuiteMemberInstanceID(long l) {
        this.jobSuiteMemberInstanceID = l;
    }

    public long getJobSuiteID() {
        return this.jobSuiteID;
    }

    public void setJobSuiteID(long l) {
        this.jobSuiteID = l;
    }

    public String getJobSuiteName() {
        return this.jobSuiteName;
    }

    public void setJobSuiteName(String string) {
        this.jobSuiteName = string;
    }

    public boolean isSubsequentSubmit() {
        return this.subsequentSubmit;
    }

    public void setSubsequentSubmit(boolean bl) {
        this.subsequentSubmit = bl;
    }

    public String getAgentEnvironmentType() {
        return this.agentEnvironmentType;
    }

    public void setAgentEnvironmentType(String string) {
        this.agentEnvironmentType = string;
    }

    public String getIBMiJobName() {
        return this.iBMiJobName;
    }

    public void setIBMiJobName(String string) {
        this.iBMiJobName = string;
    }

    public String getIBMiJobUser() {
        return this.iBMiJobUser;
    }

    public void setIBMiJobUser(String string) {
        this.iBMiJobUser = string;
    }

    public String getIBMiJobNumber() {
        return this.iBMiJobNumber;
    }

    public void setIBMiJobNumber(String string) {
        this.iBMiJobNumber = string;
    }

    public boolean isIBMiJobSubmitted() {
        return this.iBMiJobName != null && this.iBMiJobName.length() > 0;
    }

    public boolean isNeedToCheckIfJobRunHasStarted() {
        return this.needToCheckIfJobRunHasStarted;
    }

    public void setNeedToCheckIfJobRunHasStarted(boolean bl) {
        this.needToCheckIfJobRunHasStarted = bl;
    }

    public String getJobParameters() {
        return this.jobParameters;
    }

    public void setJobParameters(String string) {
        this.jobParameters = string;
    }

    public String getDefaultSuiteParameters() {
        return this.defaultSuiteParameters;
    }

    public void setDefaultSuiteParameters(String string) {
        this.defaultSuiteParameters = string;
    }

    public long getEstimatedRuntime() {
        return this.estimatedRuntime;
    }

    public void setEstimatedRuntime(long l) {
        this.estimatedRuntime = l;
    }

    public String toString() {
        String string = "";
        string = string + "\n id:" + this.id;
        string = string + "\n jobID:" + this.jobID;
        string = string + "\n jobName:" + this.jobName;
        string = string + "\n agentID:" + this.agentID;
        string = string + "\n agentName:" + this.agentName;
        string = string + "\n jobQueueID: " + this.jobQueueID;
        string = string + "\n jobQueueName: " + this.jobQueueName;
        string = string + "\n statusCode:" + this.statusCode;
        string = string + "\n scheduledTime:" + this.scheduledTime;
        string = string + "\n serverInitiatedTime:" + this.serverInitiatedTime;
        string = string + "\n serverSubmittedTime:" + this.serverSubmittedTime;
        string = string + "\n serverRunningTime:" + this.serverRunningTime;
        string = string + "\n serverEndedTime:" + this.serverEndedTime;
        string = string + "\n agentStartedTime:" + this.agentStartedTime;
        string = string + "\n agentEndedTime:" + this.agentEndedTime;
        string = string + "\n queueEndedTime:" + this.queueEndedTime;
        string = string + "\n startAtCommandSequence:" + this.startAtCommandSequence;
        string = string + "\n restartParentHistoryID:" + this.restartParentHistoryID;
        string = string + "\n restartChildHistoryID:" + this.restartChildHistoryID;
        string = string + "\n reactCode:" + this.reactCode;
        string = string + "\n initiationCode:" + this.initiationCode;
        string = string + "\n failedAtCommandSequence:" + this.failedAtCommandSequence;
        string = string + "\n missedCode:" + this.missedCode;
        string = string + "\n copiedJobLogToServer:" + this.copiedJobLogToServer;
        string = string + "\n manuallyStarted:" + this.manuallyStarted;
        string = string + "\n endedReasonCode:" + this.endedReasonCode;
        string = string + "\n bypassJobMonitors:" + this.bypassJobMonitors;
        string = string + "\n terminationData:" + this.terminationData;
        string = string + "\n bypassConditions:" + this.bypassConditions;
        string = string + "\n timezoneType:" + this.timezoneType;
        string = string + "\n agentTimezone:" + this.agentTimezone;
        string = string + "\n jobTimezone:" + this.jobTimezone;
        string = string + "\n agentGroupID:" + this.agentGroupID;
        string = string + "\n agentGroupName:" + this.agentGroupName;
        string = string + "\n jobSuiteHistoryID:" + this.jobSuiteHistoryID;
        string = string + "\n jobSuiteMemberID:" + this.jobSuiteMemberID;
        string = string + "\n jobSuiteMemberInstanceID:" + this.jobSuiteMemberInstanceID;
        string = string + "\n jobSuiteID:" + this.jobSuiteID;
        string = string + "\n jobSuiteName:" + this.jobSuiteName;
        string = string + "\n jobPriority:" + this.jobPriority;
        string = string + "\n clearPrereqStatus:" + this.clearPrereqStatus;
        string = string + "\n movedFromScheduledDateTime:" + this.movedFromScheduledDateTime;
        string = string + "\n retryNumber:" + this.retryNumber;
        string = string + "\n retryNextTime:" + this.retryNextTime;
        string = string + "\n subsequentSubmit:" + this.subsequentSubmit;
        string = string + "\n agentEnvironmentType:" + this.agentEnvironmentType;
        string = string + "\n iBMiJobName:" + this.iBMiJobName;
        string = string + "\n iBMiJobUser:" + this.iBMiJobUser;
        string = string + "\n iBMiJobNumber:" + this.iBMiJobNumber;
        string = string + "\n jobParameters:" + this.jobParameters;
        string = string + "\n defaultSuiteParameters:" + this.defaultSuiteParameters;
        return string;
    }
}

