/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo_Validated;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import junit.framework.TestCase;

public class EnterpriseLicenseInfo_ValidatedTest
extends TestCase {
    EnterpriseLicenseInfo_Validated info;
    EnterpriseLicenseInfo_Validated info2;

    protected void setUp() throws Exception {
        super.setUp();
        this.info = new EnterpriseLicenseInfo_Validated();
        this.info2 = new EnterpriseLicenseInfo_Validated(new EnterpriseProductLicense(), new EnterpriseProductLicense());
    }

    protected void tearDown() throws Exception {
        this.info = null;
        super.tearDown();
    }

    public void testTemporaryLicenseKeyInvalidIfNoTemporaryLicense() {
        long l = 1234L;
        String string = String.valueOf(l);
        this.info.setLicenseSeed(l);
        this.info.setTrialLicense(null);
        this.info.setTrialLicenseKey(string);
        EnterpriseLicenseInfo_ValidatedTest.assertFalse((boolean)this.info.isTrialLicenseKeyValid(l));
    }

    public void testIsTemporaryLicenseKeyValid() {
        long l = EnterpriseLicenseInfo_Validated.generateLicenseSeed();
        long l2 = l / 2L;
        String string = String.valueOf(l);
        this.info.setLicenseSeed(l);
        this.info.setTrialLicenseKey(string);
        EnterpriseLicenseInfo_ValidatedTest.assertFalse((boolean)this.info.isTrialLicenseKeyValid(l2));
    }

    public void testLicenseKeysRequiringBuild() {
        EnterpriseLicenseInfo_ValidatedTest.assertTrue((boolean)EnterpriseLicenseInfo_Validated.testLicenseKeysWithBuild());
    }

    public void testPrimaryLicenseKeyInvalidIfNoPrimaryLicense() {
        long l = 5678L;
        String string = String.valueOf(l);
        this.info.setLicenseSeed(l);
        this.info.setPrimaryLicense(null);
        this.info.setPrimaryLicenseKey(string);
        EnterpriseLicenseInfo_ValidatedTest.assertFalse((boolean)this.info.isPrimaryLicenseKeyValid(l));
    }

    public void testIsPrimaryLicenseKeyValid() {
        long l = EnterpriseLicenseInfo_Validated.generateLicenseSeed();
        long l2 = l / 2L;
        String string = String.valueOf(l);
        this.info.setLicenseSeed(l);
        this.info.setPrimaryLicense(new EnterpriseProductLicense());
        this.info.setPrimaryLicenseKey(string);
        EnterpriseLicenseInfo_ValidatedTest.assertFalse((boolean)this.info.isPrimaryLicenseKeyValid(l2));
    }

    public void testInvalidPrimaryLicenseKey() {
        long l = EnterpriseLicenseInfo_Validated.generateLicenseSeed();
        String string = "SomethingNonNumeric";
        EnterpriseProductLicense enterpriseProductLicense = new EnterpriseProductLicense();
        this.info.setLicenseSeed(l);
        this.info.setPrimaryLicense(enterpriseProductLicense);
        this.info.setPrimaryLicenseKey(string);
        EnterpriseLicenseInfo_ValidatedTest.assertFalse((boolean)this.info.isPrimaryLicenseKeyValid(l));
    }

    public void testGetLicenseSeed() {
        try {
            this.info.setLicenseSeed(0L);
            EnterpriseLicenseInfo_ValidatedTest.fail((String)"setLicenseSeed() allowed a value less than 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.info.setLicenseSeed(-1234L);
            EnterpriseLicenseInfo_ValidatedTest.fail((String)"setLicenseSeed() allowed a value less than 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.info.setLicenseSeed(1234L);
        EnterpriseLicenseInfo_ValidatedTest.assertEquals((long)1234L, (long)this.info.getLicenseSeed());
        try {
            this.info.setLicenseSeed(23456L);
            EnterpriseLicenseInfo_ValidatedTest.fail((String)"setLicenseSeed() allowed resetting seed value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.info.setLicenseSeed(this.info.getLicenseSeed());
    }

    public void testGetPrimaryLicenseKey() {
        String string = "TestLicenseKeyValue1234";
        this.info.setPrimaryLicenseKey(string);
        EnterpriseLicenseInfo_ValidatedTest.assertEquals((String)string, (String)this.info.getPrimaryLicenseKey());
        try {
            this.info.setPrimaryLicenseKey("aonetuhaoentuh");
            EnterpriseLicenseInfo_ValidatedTest.fail((String)"setPrimaryLicenseKey() allowed resetting value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetTemporaryLicenseKey() {
        String string = "TestLicenseKeyValue1234";
        this.info.setTrialLicenseKey(string);
        EnterpriseLicenseInfo_ValidatedTest.assertEquals((String)string, (String)this.info.getTrialLicenseKey());
        try {
            this.info.setTrialLicenseKey("uircduirdccruidr");
            EnterpriseLicenseInfo_ValidatedTest.fail((String)"setTemporaryLicenseKey() allowed resetting value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testClone() {
        EnterpriseProductLicense enterpriseProductLicense = new EnterpriseProductLicense();
        EnterpriseProductLicense enterpriseProductLicense2 = new EnterpriseProductLicense();
        this.info.setTrialLicense(enterpriseProductLicense);
        this.info.setPrimaryLicense(enterpriseProductLicense2);
        this.info.setLicenseSeed(1234L);
        this.info.setTrialLicenseKey("1234");
        this.info.setPrimaryLicenseKey("12345");
        EnterpriseLicenseInfo_Validated enterpriseLicenseInfo_Validated = (EnterpriseLicenseInfo_Validated)this.info.clone();
        EnterpriseLicenseInfo_ValidatedTest.assertTrue((boolean)enterpriseLicenseInfo_Validated.equals(this.info));
        EnterpriseLicenseInfo_ValidatedTest.assertFalse((enterpriseLicenseInfo_Validated == this.info ? 1 : 0) != 0);
        EnterpriseLicenseInfo_ValidatedTest.assertEquals((Object)this.info.getTrialLicense(), (Object)enterpriseLicenseInfo_Validated.getTrialLicense());
        EnterpriseLicenseInfo_ValidatedTest.assertEquals((Object)this.info.getPrimaryLicense(), (Object)enterpriseLicenseInfo_Validated.getPrimaryLicense());
        EnterpriseLicenseInfo_ValidatedTest.assertEquals((String)this.info.getTrialLicenseKey(), (String)enterpriseLicenseInfo_Validated.getTrialLicenseKey());
        EnterpriseLicenseInfo_ValidatedTest.assertEquals((String)this.info.getPrimaryLicenseKey(), (String)enterpriseLicenseInfo_Validated.getPrimaryLicenseKey());
        EnterpriseLicenseInfo_ValidatedTest.assertEquals((long)this.info.getLicenseSeed(), (long)enterpriseLicenseInfo_Validated.getLicenseSeed());
    }
}

