/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import org.apache.log4j.Logger;

public final class EnterpriseLicenseInfo_Validated
extends EnterpriseLicenseInfo
implements Cloneable {
    private static final long serialVersionUID = 8792496378990002178L;
    private static final Logger logger = Logger.getLogger(EnterpriseLicenseInfo_Validated.class);
    public static final int LICENSE_TYPE_PRIMARY = 1;
    public static final int LICENSE_TYPE_TRIAL = 2;
    private static final long SEED_CORRUPTED = -1L;
    private long licenseSeed = 0L;
    private String primaryLicenseKey = null;
    private String trialLicenseKey = null;

    public static boolean testLicenseKeysWithBuild() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4 = false;
        try {
            EnterpriseLicenseInfo_Validated.buildLicenseKey(-1L, new EnterpriseProductLicense());
        }
        catch (Exception exception) {
            bl4 = true;
        }
        EnterpriseLicenseInfo_Validated enterpriseLicenseInfo_Validated = new EnterpriseLicenseInfo_Validated();
        long l = 1234L;
        long l2 = 5678L;
        enterpriseLicenseInfo_Validated.setLicenseSeed(l);
        EnterpriseProductLicense enterpriseProductLicense = new EnterpriseProductLicense();
        enterpriseLicenseInfo_Validated.setTrialLicense(enterpriseProductLicense);
        try {
            enterpriseLicenseInfo_Validated.setTrialLicenseKey(EnterpriseLicenseInfo_Validated.buildLicenseKey(l2, enterpriseProductLicense));
            bl3 = !enterpriseLicenseInfo_Validated.isTrialLicenseKeyValid(l);
        }
        catch (Exception exception) {
            bl3 = false;
            exception.printStackTrace();
        }
        enterpriseLicenseInfo_Validated = null;
        EnterpriseLicenseInfo_Validated enterpriseLicenseInfo_Validated2 = new EnterpriseLicenseInfo_Validated();
        long l3 = 0L;
        EnterpriseProductLicense enterpriseProductLicense2 = new EnterpriseProductLicense();
        enterpriseLicenseInfo_Validated2.setPrimaryLicense(enterpriseProductLicense2);
        try {
            enterpriseLicenseInfo_Validated2.setPrimaryLicenseKey(EnterpriseLicenseInfo_Validated.buildLicenseKey(l3, enterpriseProductLicense2));
            bl2 = enterpriseLicenseInfo_Validated2.isPrimaryLicenseKeyValid(l3);
        }
        catch (Exception exception) {
            bl2 = false;
            exception.printStackTrace();
        }
        enterpriseLicenseInfo_Validated2 = null;
        EnterpriseLicenseInfo_Validated enterpriseLicenseInfo_Validated3 = new EnterpriseLicenseInfo_Validated();
        enterpriseLicenseInfo_Validated3.setPrimaryLicense(null);
        l3 = 1234L;
        try {
            enterpriseLicenseInfo_Validated3.setPrimaryLicenseKey(EnterpriseLicenseInfo_Validated.buildLicenseKey(l3, null));
            bl = !enterpriseLicenseInfo_Validated3.isPrimaryLicenseKeyValid(l3);
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        enterpriseLicenseInfo_Validated3 = null;
        return bl4 && bl3 && bl2 && bl;
    }

    public EnterpriseLicenseInfo_Validated() {
    }

    public EnterpriseLicenseInfo_Validated(EnterpriseProductLicense enterpriseProductLicense, EnterpriseProductLicense enterpriseProductLicense2) {
        super(enterpriseProductLicense, enterpriseProductLicense2);
    }

    public static final long generateLicenseSeed() {
        return System.currentTimeMillis();
    }

    public final boolean isTrialLicenseKeyValid(long l) {
        if (l != this.licenseSeed) {
            String string = "The seed (" + l + ") does not match the original license seed (" + this.licenseSeed + ")";
            logger.debug((Object)string);
            return false;
        }
        if (super.getTrialLicense() == null) {
            String string = "Trial license object is null.";
            logger.error((Object)string);
            return false;
        }
        try {
            return this.isValidKey(LicenseType.TRIAL);
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public final boolean isPrimaryLicenseKeyValid(long l) {
        if (l != this.licenseSeed) {
            String string = "The seed (" + l + ") does not match the original license seed (" + this.licenseSeed + ")";
            logger.debug((Object)string);
            return false;
        }
        if (super.getPrimaryLicense() == null) {
            String string = "Primary license object is null.";
            logger.error((Object)string);
            return false;
        }
        try {
            return this.isValidKey(LicenseType.PRIMARY);
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private final boolean isValidKey(LicenseType licenseType) {
        if (this.licenseSeed == -1L) {
            throw new IllegalStateException("The license seed has been corrupted.");
        }
        String string = null;
        String string2 = null;
        try {
            switch (licenseType) {
                case PRIMARY: {
                    string = EnterpriseLicenseInfo_Validated.buildLicenseKey(this.licenseSeed, this.getPrimaryLicense());
                    string2 = this.primaryLicenseKey;
                    break;
                }
                case TRIAL: {
                    string = EnterpriseLicenseInfo_Validated.buildLicenseKey(this.licenseSeed, this.getTrialLicense());
                    string2 = this.trialLicenseKey;
                }
            }
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getStackTrace());
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        String string3 = "License key does not match: " + (Object)((Object)licenseType);
        logger.debug((Object)string3);
        return false;
    }

    public final long getLicenseSeed() {
        return this.licenseSeed;
    }

    private static final String buildLicenseKey(long l, EnterpriseProductLicense enterpriseProductLicense) throws Exception {
        if (l == 0L) {
            return "*ZERO_SEED";
        }
        if (enterpriseProductLicense == null) {
            return "*NULL_LICENSE";
        }
        char[] cArray = String.valueOf(l).toCharArray();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (int i = 0; i < cArray.length; ++i) {
            int n = cArray.length - 1 - i;
            String string = String.valueOf(cArray[n]);
            l4 += Long.parseLong(string);
            if (n % 2 == 1) {
                l2 += (long)Integer.parseInt(string) * (long)Math.pow(10.0, n / 2);
                continue;
            }
            l3 += (long)Integer.parseInt(string) * (long)Math.pow(10.0, n / 2);
        }
        long l5 = EnterpriseLicenseInfo_Validated.reverseNumber(l4);
        long l6 = 0L;
        long l7 = 0L;
        long l8 = (l3 + l2 + l6 + l7) * l5;
        return String.valueOf(EnterpriseLicenseInfo_Validated.reverseNumber(l8));
    }

    private static final long reverseNumber(long l) {
        char[] cArray = String.valueOf(l).toCharArray();
        char[] cArray2 = new char[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[cArray.length - 1 - i] = cArray[i];
        }
        return Long.parseLong(String.valueOf(cArray2));
    }

    public final void setLicenseSeed(long l) {
        if (this.licenseSeed != 0L && l != this.licenseSeed) {
            throw new IllegalStateException("The license seed has already been set.");
        }
        if (l < 1L) {
            throw new IllegalArgumentException("The license seed must be greater than zero: " + l);
        }
        this.licenseSeed = l;
    }

    public final String getPrimaryLicenseKey() {
        return this.primaryLicenseKey;
    }

    public final void setPrimaryLicenseKey(String string) {
        if (this.primaryLicenseKey != null) {
            throw new IllegalStateException("The primary license key has already been set.");
        }
        this.primaryLicenseKey = string;
    }

    public final String getTrialLicenseKey() {
        return this.trialLicenseKey;
    }

    public final void setTrialLicenseKey(String string) {
        if (this.trialLicenseKey != null) {
            throw new IllegalStateException("The trial license key has already been set.");
        }
        this.trialLicenseKey = string;
    }

    @Override
    public Object clone() {
        EnterpriseLicenseInfo_Validated enterpriseLicenseInfo_Validated = new EnterpriseLicenseInfo_Validated();
        super.clone(enterpriseLicenseInfo_Validated);
        enterpriseLicenseInfo_Validated.licenseSeed = this.licenseSeed;
        enterpriseLicenseInfo_Validated.primaryLicenseKey = this.primaryLicenseKey;
        enterpriseLicenseInfo_Validated.trialLicenseKey = this.trialLicenseKey;
        return enterpriseLicenseInfo_Validated;
    }

    private static enum LicenseType {
        PRIMARY,
        TRIAL;

    }
}

