/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.AgentGroup;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgent;
import java.util.Arrays;

public class BalancedAgentGroup
extends AgentGroup {
    protected long[] agentIDs;
    protected int lastChoice = -1;

    public BalancedAgentGroup(AgentGroup agentGroup) {
        super.setName(agentGroup.getName());
        super.setDescription(agentGroup.getDescription());
        super.setAgents(agentGroup.getAgents());
    }

    public long chooseAgent() {
        this.getNonIgnoredAgentIDs();
        this.validateThatThereAreUnignoredAgentsToChooseFrom();
        int n = this.lastChoice;
        this.lastChoice = n = this.next(n);
        return this.agentIDs[n];
    }

    public long getLastAgentChosen() {
        if (this.lastChoice == -1) {
            return -1L;
        }
        return this.agentIDs[this.lastChoice];
    }

    public long[] getNonIgnoredAgentIDs() {
        this.adjustForIgnored();
        return this.agentIDs;
    }

    public void setLastChoicePointer(long l) {
        this.adjustForIgnored();
        if (this.agentIDs.length == 0) {
            this.lastChoice = -1;
            return;
        }
        int n = Arrays.binarySearch(this.agentIDs, l);
        this.lastChoice = n >= 0 ? n : -n - 2;
    }

    private void adjustForIgnored() {
        long l = System.currentTimeMillis();
        AgentGroupAgent[] agentGroupAgentArray = this.getAgents();
        int n = this.countIgnored(agentGroupAgentArray, l);
        long[] lArray = new long[agentGroupAgentArray.length - n];
        int n2 = 0;
        for (AgentGroupAgent agentGroupAgent : agentGroupAgentArray) {
            if (agentGroupAgent.currentlyIgnored(l)) continue;
            lArray[n2++] = agentGroupAgent.getAgentID();
        }
        long[] lArray2 = lArray;
        Arrays.sort(lArray2);
        if (this.agentIDs != null && this.isAgentIDsHaveChanged(this.agentIDs, lArray2)) {
            this.lastChoice = this.adjustLastChoiceIfNecessary(this.lastChoice, this.agentIDs, lArray2);
        }
        this.agentIDs = lArray2;
    }

    private int adjustLastChoiceIfNecessary(int n, long[] lArray, long[] lArray2) {
        if (n == -1) {
            return n;
        }
        long l = lArray[n];
        int n2 = Arrays.binarySearch(lArray2, l);
        if (n2 >= 0) {
            return n2;
        }
        return -1;
    }

    private int countIgnored(AgentGroupAgent[] agentGroupAgentArray, long l) {
        int n = 0;
        for (AgentGroupAgent agentGroupAgent : agentGroupAgentArray) {
            if (!agentGroupAgent.currentlyIgnored(l)) continue;
            ++n;
        }
        return n;
    }

    private boolean isAgentIDsHaveChanged(long[] lArray, long[] lArray2) {
        return !Arrays.equals(lArray, lArray2);
    }

    protected int next(int n) {
        return this.next(n, this.agentIDs.length - 1);
    }

    private int next(int n, int n2) {
        return ++n > n2 ? 0 : n;
    }

    protected void validateThatThereAreUnignoredAgentsToChooseFrom() {
        if (this.agentIDs.length == 0) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"There are no available agents in Agent Group {0} to choose from.", (Object[])new Object[]{this.getName()}));
        }
    }

    public String toString() {
        if (this.agentIDs.length <= 20) {
            return Arrays.toString(this.agentIDs);
        }
        long[] lArray = Arrays.copyOfRange(this.agentIDs, 0, 19);
        int n = this.agentIDs.length - 20;
        return Arrays.toString(lArray) + " + " + n + " more.";
    }
}

