/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.AgentReturnCode;
import java.util.Arrays;
import junit.framework.TestCase;

public class AgentReturnCodeTest
extends TestCase {
    AgentReturnCode prox;

    protected void setUp() throws Exception {
        super.setUp();
        this.prox = new AgentReturnCode();
        this.prox.setOid(1234L);
    }

    protected void tearDown() throws Exception {
        this.prox = null;
        super.tearDown();
    }

    public void testHashCode() {
        AgentReturnCode agentReturnCode = new AgentReturnCode();
        agentReturnCode.setOid(4444L);
        AgentReturnCode agentReturnCode2 = new AgentReturnCode();
        agentReturnCode2.setOid(1234L);
        AgentReturnCodeTest.assertTrue((this.prox.hashCode() == agentReturnCode2.hashCode() ? 1 : 0) != 0);
        AgentReturnCodeTest.assertFalse((this.prox.hashCode() == agentReturnCode.hashCode() ? 1 : 0) != 0);
    }

    public void testEqualsObject() {
        AgentReturnCodeTest.assertFalse((boolean)this.prox.equals(new Object()));
        AgentReturnCodeTest.assertTrue((boolean)this.prox.equals((Object)this.prox));
        AgentReturnCode agentReturnCode = new AgentReturnCode();
        agentReturnCode.setOid(4321L);
        AgentReturnCodeTest.assertFalse((boolean)this.prox.equals((Object)agentReturnCode));
    }

    public void testOID() {
        AgentReturnCodeTest.assertTrue((this.prox.getOid() == 1234L ? 1 : 0) != 0);
    }

    public void testName() {
        this.prox.setName("FAIL_CODES");
        AgentReturnCodeTest.assertTrue((boolean)this.prox.getName().equals("FAIL_CODES"));
        char[] cArray = new char[20];
        Arrays.fill(cArray, 'N');
        String string = new String(cArray);
        this.prox.setName(string);
    }

    public void testDescription() {
        this.prox.setDescription("Unit test description.");
        AgentReturnCodeTest.assertTrue((boolean)this.prox.getDescription().equals("Unit test description."));
        this.prox.setDescription("");
        AgentReturnCodeTest.assertTrue((boolean)this.prox.getDescription().equals(""));
        try {
            this.prox.setDescription(null);
            AgentReturnCodeTest.fail((String)"setDescription() accepted a null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        char[] cArray = new char[20];
        Arrays.fill(cArray, 'D');
        String string = new String(cArray);
        this.prox.setDescription(string);
    }

    private void addActionMaintenance() {
        this.prox.setActionList("");
        String string = "-9:-1,1,4:9";
        this.prox.setActionList(string);
        String string2 = this.prox.getActionList();
        AgentReturnCodeTest.assertEquals((String)string2, (String)string);
        this.prox.addActionCode("3");
        string2 = this.prox.getActionList();
        AgentReturnCodeTest.assertEquals((String)string2, (String)"-9:-1,1,4:9,3");
    }

    public void testGetReturnCode() {
        this.addActionMaintenance();
        this.prox.setSuccessTypeList(true);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(1) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-1) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(2) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-2) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(5) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-3) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-9) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-5) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(3) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(9) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-15) == 0 ? 1 : 0) != 0);
        this.prox.setSuccessTypeList(false);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(1) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-1) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(2) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-2) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-5) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-3) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-9) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(5) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(3) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(9) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-15) == 1 ? 1 : 0) != 0);
        this.prox.setActionList("");
        this.prox.setSuccessTypeList(true);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(1) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-1) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(2) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-2) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(5) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-3) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-9) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-5) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(3) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(9) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-15) == 0 ? 1 : 0) != 0);
        this.prox.setSuccessTypeList(false);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(1) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-1) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(2) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-2) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-5) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-3) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-9) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(5) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(3) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(9) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-15) == 1 ? 1 : 0) != 0);
        this.prox.setActionList("1,3:9,-1,-9:-3");
        this.prox.setSuccessTypeList(true);
        AgentReturnCodeTest.assertTrue((boolean)this.prox.isSuccessTypeList());
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(1) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-1) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(2) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-2) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(5) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-3) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-9) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-5) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(3) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(9) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-15) == 0 ? 1 : 0) != 0);
        this.prox.setSuccessTypeList(false);
        AgentReturnCodeTest.assertFalse((boolean)this.prox.isSuccessTypeList());
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(1) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-1) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(2) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-2) == 1 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-5) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-3) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-9) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(5) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(3) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(9) == 0 ? 1 : 0) != 0);
        AgentReturnCodeTest.assertTrue((this.prox.getReturnCode(-15) == 1 ? 1 : 0) != 0);
    }

    public void testIsPrivateType() {
        AgentReturnCode agentReturnCode = new AgentReturnCode();
        agentReturnCode.setOid(2938L);
        AgentReturnCodeTest.assertTrue((boolean)agentReturnCode.isPrivateType());
        agentReturnCode.setDescription("  ");
        AgentReturnCodeTest.assertTrue((boolean)agentReturnCode.isPrivateType());
        agentReturnCode.setDescription("Not blank");
        AgentReturnCodeTest.assertFalse((boolean)agentReturnCode.isPrivateType());
    }

    public void testGetType() {
        AgentReturnCode agentReturnCode = new AgentReturnCode();
        agentReturnCode.setType(1);
        AgentReturnCodeTest.assertEquals((int)1, (int)agentReturnCode.getType());
        agentReturnCode.setType(2);
        AgentReturnCodeTest.assertEquals((int)2, (int)agentReturnCode.getType());
        try {
            agentReturnCode.setType(-321);
            AgentReturnCodeTest.fail((String)"setType() allowed invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetInstanceStandard() {
        AgentReturnCode agentReturnCode = AgentReturnCode.getInstanceStandard();
        AgentReturnCodeTest.assertNotNull((Object)((Object)agentReturnCode));
        AgentReturnCodeTest.assertEquals((String)"STANDARD", (String)agentReturnCode.getName());
        AgentReturnCodeTest.assertEquals((String)"STANDARD", (String)agentReturnCode.getDescription());
        AgentReturnCodeTest.assertTrue((boolean)agentReturnCode.isSuccessTypeList());
        AgentReturnCodeTest.assertEquals((String)"0", (String)agentReturnCode.getActionList());
    }

    public void testGetSuccessTypeList() {
        this.prox.setSuccessTypeList(true);
        AgentReturnCodeTest.assertTrue((boolean)this.prox.getSuccessTypeList());
        this.prox.setSuccessTypeList(false);
        AgentReturnCodeTest.assertFalse((boolean)this.prox.getSuccessTypeList());
    }

    public void testRangeValue() {
        int n = Integer.MIN_VALUE;
        int n2 = AgentReturnCode.getRangeValue(n, "1:9", 1);
        AgentReturnCodeTest.assertEquals((int)n2, (int)1);
        n2 = AgentReturnCode.getRangeValue(n + 1, "1:9", 1);
        AgentReturnCodeTest.assertEquals((int)n2, (int)9);
        try {
            n2 = AgentReturnCode.getRangeValue(n, "X:9", 1);
            AgentReturnCodeTest.fail((String)"Should not parse letters.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            n2 = AgentReturnCode.getRangeValue(n + 1, "1:Y", 1);
            AgentReturnCodeTest.fail((String)"Should not parse letters.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

