/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.AgentReturnCodeText;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentReturnCode
extends EnterpriseProxy {
    private static final long serialVersionUID = -5019704954541505514L;
    public static final String STANDARD_RETURNCODE = "STANDARD";
    public static final int TYPE_PRIVATE = 1;
    public static final int TYPE_SHARED = 2;
    public static final int MIN = Short.MIN_VALUE;
    public static final int MAX = Short.MAX_VALUE;
    public static final int FAILED = 0;
    public static final int PASSED = 1;
    private long oid;
    private boolean isSuccessList = true;
    private ArrayList<String> actionCodes = new ArrayList();
    private int type = 1;
    private ArrayList<AgentReturnCodeText> agentReturnCodeTexts = new ArrayList();
    private static final int MATCH_ANY = 0;
    private static final int MATCH_ALL = 1;
    private int textMatchType;

    public static AgentReturnCode getInstanceStandard() {
        AgentReturnCode agentReturnCode = new AgentReturnCode();
        agentReturnCode.setName(STANDARD_RETURNCODE);
        agentReturnCode.setDescription(STANDARD_RETURNCODE);
        agentReturnCode.setType(2);
        agentReturnCode.setSuccessTypeList(true);
        agentReturnCode.setActionList("0");
        return agentReturnCode;
    }

    public long getOid() {
        return this.oid;
    }

    public void setOid(long l) {
        this.oid = l;
    }

    public void setSuccessTypeList(boolean bl) {
        this.isSuccessList = bl;
    }

    public void addActionCode(String string) {
        this.addCodeToList(string, this.actionCodes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AgentReturnCode)) {
            return false;
        }
        AgentReturnCode agentReturnCode = (AgentReturnCode)((Object)object);
        return super.equals(object) && Equal.isEqual((long)this.oid, (long)agentReturnCode.oid);
    }

    public int hashCode() {
        return (int)this.oid;
    }

    public boolean isSuccessTypeList() {
        return this.isSuccessList;
    }

    public boolean getSuccessTypeList() {
        return this.isSuccessTypeList();
    }

    public String getActionList() {
        return this.stuffList(this.actionCodes);
    }

    public void setActionList(String string) {
        this.parseNewList(this.actionCodes, string);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"{0} is an invalid Type.", (Object[])new Object[]{n}));
        }
        this.type = n;
    }

    public int getReturnCode(int n) {
        if (this.isCodeActionable(n)) {
            if (!this.isSuccessList) {
                return 0;
            }
            return 1;
        }
        if (this.isSuccessList) {
            return 0;
        }
        return 1;
    }

    private void parseNewList(ArrayList<String> arrayList, String string) {
        arrayList.clear();
        if (string.trim().length() == 0) {
            return;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            this.addCodeToList(stringArray[i], arrayList);
        }
    }

    private void addCodeToList(String string, ArrayList<String> arrayList) {
        if (!arrayList.contains(string)) {
            arrayList.add(string);
        }
    }

    private String stuffList(ArrayList<String> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(arrayList.get(i));
            if (i + 1 >= n) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private boolean isCodeActionable(int n) {
        return this.isCodeInList(n, this.actionCodes);
    }

    private boolean isCodeInList(int n, ArrayList<String> arrayList) {
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!this.actionCodesInclude(n, arrayList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static int getRangeValue(int n, String string, int n2) {
        int n3 = Short.MIN_VALUE;
        int n4 = Short.MAX_VALUE;
        if (n == Integer.MIN_VALUE) {
            String string2 = string.substring(0, n2);
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string2 + " is not a number.", numberFormatException);
            }
            return n3;
        }
        String string3 = string.substring(n2 + 1);
        try {
            n4 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string3 + " is not a number.", numberFormatException);
        }
        return n4;
    }

    private boolean actionCodesInclude(int n, String string) throws NumberFormatException {
        int n2 = string.indexOf(58);
        if (n2 > -1) {
            int n3 = AgentReturnCode.getRangeValue(Integer.MIN_VALUE, string, n2);
            int n4 = AgentReturnCode.getRangeValue(Integer.MAX_VALUE, string, n2);
            return n >= n3 && n <= n4;
        }
        int n5 = Integer.parseInt(string);
        return n == n5;
    }

    public boolean isPrivateType() {
        return this.getDescription() == null || this.getDescription().trim().length() < 1;
    }

    public ArrayList<AgentReturnCodeText> getAgentReturnCodeTexts() {
        return this.agentReturnCodeTexts;
    }

    public void setAgentReturnCodeTexts(ArrayList<AgentReturnCodeText> arrayList) {
        this.agentReturnCodeTexts = arrayList;
    }

    public void addReturnCodeText(AgentReturnCodeText agentReturnCodeText) {
        this.agentReturnCodeTexts.add(agentReturnCodeText);
    }

    public int getTextMatchType() {
        return this.textMatchType;
    }

    public void setTextMatchType(int n) {
        this.textMatchType = n;
    }

    public boolean isTextMatchEmpty() {
        return this.agentReturnCodeTexts.size() == 0;
    }

    public boolean isTextMatch(String string, ArrayList<String> arrayList) {
        if (string == null || this.isTextMatchEmpty()) {
            return true;
        }
        int n = this.agentReturnCodeTexts.size();
        if (this.textMatchType == 0) {
            for (int i = 0; i < n; ++i) {
                AgentReturnCodeText agentReturnCodeText = this.agentReturnCodeTexts.get(i);
                int n2 = agentReturnCodeText.getContains();
                String string2 = agentReturnCodeText.getTextToMatch();
                if (n2 == AgentReturnCodeText.CONTAINS) {
                    if (agentReturnCodeText.isUseRegExp()) {
                        if (AgentReturnCode.isRegExpMatach(string, string2)) {
                            arrayList.add("Match     - ");
                            return true;
                        }
                    } else if (string.contains(agentReturnCodeText.getTextToMatch())) {
                        arrayList.add("Match     - ");
                        return true;
                    }
                    arrayList.add("Not Match - ");
                    continue;
                }
                if (n2 == AgentReturnCodeText.DO_NOT_CONTAIN) {
                    if (agentReturnCodeText.isUseRegExp()) {
                        if (!AgentReturnCode.isRegExpMatach(string, string2)) {
                            arrayList.add("Match     - ");
                            return true;
                        }
                    } else if (!string.contains(agentReturnCodeText.getTextToMatch())) {
                        arrayList.add("Match     - ");
                        return true;
                    }
                    arrayList.add("Not Match - ");
                    continue;
                }
                arrayList.add("Not Match - ");
            }
            return false;
        }
        if (this.textMatchType == 1) {
            for (int i = 0; i < n; ++i) {
                AgentReturnCodeText agentReturnCodeText = this.agentReturnCodeTexts.get(i);
                int n3 = agentReturnCodeText.getContains();
                String string3 = agentReturnCodeText.getTextToMatch();
                if (n3 == AgentReturnCodeText.CONTAINS) {
                    if (agentReturnCodeText.isUseRegExp()) {
                        if (!AgentReturnCode.isRegExpMatach(string, string3)) {
                            arrayList.add("Not Match - ");
                            return false;
                        }
                    } else if (!string.contains(agentReturnCodeText.getTextToMatch())) {
                        arrayList.add("Not Match - ");
                        return false;
                    }
                    arrayList.add("Match     - ");
                    continue;
                }
                if (n3 == AgentReturnCodeText.DO_NOT_CONTAIN) {
                    if (agentReturnCodeText.isUseRegExp()) {
                        if (AgentReturnCode.isRegExpMatach(string, string3)) {
                            arrayList.add("Not Match - ");
                            return false;
                        }
                    } else if (string.contains(agentReturnCodeText.getTextToMatch())) {
                        arrayList.add("Not Match - ");
                        return false;
                    }
                    arrayList.add("Match     - ");
                    continue;
                }
                arrayList.add("Match     - ");
            }
        }
        return true;
    }

    public void makeFailLogTextMatch(StringBuffer stringBuffer, boolean bl, ArrayList<String> arrayList) {
        int n = this.agentReturnCodeTexts.size();
        if (n == 0) {
            return;
        }
        String string = "match all";
        String string2 = "failing";
        String string3 = "            ";
        int n2 = arrayList.size();
        if (this.textMatchType == 0) {
            string = "match any";
        }
        if (bl) {
            string2 = "passing";
        }
        stringBuffer.append("\r\nCommand failed ");
        stringBuffer.append(string);
        stringBuffer.append(" scan for ");
        stringBuffer.append(string2);
        stringBuffer.append(" text:");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\r\n  ");
            if (i < n2) {
                stringBuffer.append(arrayList.get(i));
            } else {
                stringBuffer.append(string3);
            }
            AgentReturnCodeText agentReturnCodeText = this.agentReturnCodeTexts.get(i);
            String string4 = "Does not contain";
            if (agentReturnCodeText.getContains() == AgentReturnCodeText.CONTAINS) {
                string4 = "Contains";
            }
            stringBuffer.append(string4);
            String string5 = " text";
            if (agentReturnCodeText.isUseRegExp()) {
                string5 = " regular expression";
            }
            stringBuffer.append(string5);
            stringBuffer.append(": ");
            stringBuffer.append(agentReturnCodeText.getTextToMatch());
        }
    }

    public void makeFailLogReturnCode(StringBuffer stringBuffer, boolean bl) {
        int n = this.actionCodes.size();
        if (n == 0) {
            return;
        }
        stringBuffer.append("\r\n");
        String string = this.stuffList(this.actionCodes);
        string = string.replaceAll(":", "-");
        String string2 = "Command return code did not match passing return codes:";
        if (!bl) {
            string2 = "Command return code matched failing return codes:";
        }
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string);
    }

    private static boolean isRegExpMatach(String string, String string2) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public int getRetunCodeAndTextMatch(int n, String string, StringBuffer stringBuffer) {
        boolean bl = this.isCodeActionable(n);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl && this.isTextMatch(string, arrayList)) {
            if (!this.isSuccessList) {
                if (this.actionCodes.size() == 0) {
                    this.makeFailLogTextMatch(stringBuffer, this.isSuccessList, arrayList);
                } else {
                    this.makeFailLogReturnCode(stringBuffer, this.isSuccessList);
                }
                return 0;
            }
            return 1;
        }
        if (this.isSuccessList) {
            if (!bl) {
                this.makeFailLogReturnCode(stringBuffer, this.isSuccessList);
            } else {
                this.makeFailLogTextMatch(stringBuffer, this.isSuccessList, arrayList);
            }
            return 0;
        }
        return 1;
    }
}

