/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;

public class AgentEventMonitorProxy
extends EnterpriseProxy
implements BasicIdentifier {
    public static final int TYPE_MANUAL = 0;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DIR = 2;
    public static final int TYPE_PROCESS = 3;
    public static final int TYPE_FILE_ADDED = 101;
    public static final int TYPE_FILE_REMOVED = 102;
    public static final int TYPE_FILE_CHANGED = 103;
    public static final int TYPE_FILE_THRESHOLD = 104;
    public static final int TYPE_DIR_ADDED = 201;
    public static final int TYPE_DIR_REMOVED = 202;
    public static final int TYPE_DIR_CHANGED = 203;
    public static final int TYPE_DIR_THRESHOLD = 204;
    public static final int TYPE_PROCESS_STARTED = 301;
    public static final int TYPE_PROCESS_ENDED = 302;
    public static final String NAME_MANUAL = "Manual";
    public static final String NAME_FILE_ADDED = "File Added";
    public static final String NAME_FILE_CHANGED = "File Changed";
    public static final String NAME_FILE_THRESHOLD = "File Threshold";
    public static final String NAME_FILE_REMOVED = "File Removed";
    public static final String NAME_DIR_ADDED = "Directory Added";
    public static final String NAME_DIR_CHANGED = "Directory Changed";
    public static final String NAME_DIR_THRESHOLD = "Directory Threshold";
    public static final String NAME_DIR_REMOVED = "Directory Removed";
    public static final String NAME_PROCESS_STARTED = "Process Started";
    public static final String NAME_PROCESS_ENDED = "Process Ended";
    public static final int MINIMUM_CYCLE_TIME = 5;
    public static final int MAXIMUM_CYCLE_TIME = 3600;
    public static final int DEFAULT_CYCLE_TIME = 60;
    public static final int MIN_RETENTION = 1;
    public static final int DFT_RETENTION = 15;
    public static final int MAX_RETENTION = 99999;
    private static final long serialVersionUID = -6981355735851248859L;
    private long aemoid;
    private int aemtype;
    private long targetID;
    private ScheduleInfo.TimeZoneType timeZoneType;
    private ScheduleInfo.TargetType targetType;
    private long aemagtoid;

    public AgentEventMonitorProxy() {
        this.addDoNotInvoke("getTypeDescription");
        this.timeZoneType = ScheduleInfo.TimeZoneType.SERVER;
        this.targetType = ScheduleInfo.TargetType.AGENT;
    }

    public long getOID() {
        return this.aemoid;
    }

    public void setOID(long l) {
        this.aemoid = l;
    }

    public long getTargetID() {
        return this.targetID;
    }

    public void setTargetID(long l) {
        this.targetID = l;
    }

    public ScheduleInfo.TimeZoneType getTimeZoneType() {
        return this.timeZoneType;
    }

    public void setTimeZoneType(ScheduleInfo.TimeZoneType timeZoneType) {
        this.timeZoneType = timeZoneType;
    }

    public void setTimeZoneType(String string) {
        this.timeZoneType = ScheduleInfo.TimeZoneType.persistanceCodeToEnum(string);
    }

    public ScheduleInfo.TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(ScheduleInfo.TargetType targetType) {
        this.targetType = targetType;
    }

    public void setTargetType(String string) {
        this.targetType = ScheduleInfo.TargetType.persistanceCodeToEnum(string);
    }

    public int getType() {
        return this.aemtype;
    }

    public void setType(int n) {
        this.aemtype = n;
    }

    public void setName(String string) {
        super.setName(string);
    }

    public void setDescription(String string) {
        super.setDescription(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AgentEventMonitorProxy)) {
            return false;
        }
        AgentEventMonitorProxy agentEventMonitorProxy = (AgentEventMonitorProxy)((Object)object);
        return Equal.isEqual((long)this.getProductIIDInt(), (long)agentEventMonitorProxy.getProductIIDInt()) && Equal.isEqual((long)this.aemoid, (long)agentEventMonitorProxy.getOID()) && Equal.isEqual((long)this.aemtype, (long)agentEventMonitorProxy.getType()) && Equal.isEqual((Object)this.getName(), (Object)agentEventMonitorProxy.getName()) && Equal.isEqual((Object)this.getDescription(), (Object)agentEventMonitorProxy.getDescription()) && Equal.isEqual((Object)this.timeZoneType, (Object)agentEventMonitorProxy.timeZoneType) && Equal.isEqual((Object)this.targetType, (Object)agentEventMonitorProxy.targetType);
    }

    public String getTypeDescription() {
        return AgentEventMonitorProxy.getTypeDescription(this.aemtype);
    }

    public static String getTypeDescription(int n) {
        switch (n) {
            case 0: {
                return NAME_MANUAL;
            }
            case 101: {
                return NAME_FILE_ADDED;
            }
            case 103: {
                return NAME_FILE_CHANGED;
            }
            case 104: {
                return NAME_FILE_THRESHOLD;
            }
            case 102: {
                return NAME_FILE_REMOVED;
            }
            case 201: {
                return NAME_DIR_ADDED;
            }
            case 203: {
                return NAME_DIR_CHANGED;
            }
            case 204: {
                return NAME_DIR_THRESHOLD;
            }
            case 202: {
                return NAME_DIR_REMOVED;
            }
            case 301: {
                return NAME_PROCESS_STARTED;
            }
            case 302: {
                return NAME_PROCESS_ENDED;
            }
        }
        return "Unsupported type: " + new Integer(n);
    }

    public long getAgentOID() {
        return this.aemagtoid;
    }

    public void setAgentOID(long l) {
        this.aemagtoid = l;
    }

    public void clone(AgentEventMonitor agentEventMonitor) {
        this.setTargetID(agentEventMonitor.getTargetID());
        super.setDescription(agentEventMonitor.getDescription());
        this.setType(agentEventMonitor.getType());
        this.setIdentifier(agentEventMonitor.getIdentifier());
        this.setKey(agentEventMonitor.getKey());
        super.setName(agentEventMonitor.getName());
        this.setOID(agentEventMonitor.getOID());
        this.setProductIIDInt(agentEventMonitor.getProductIIDInt());
        this.setAgentOID(agentEventMonitor.getAgentOID());
    }

    public static int getTypeCategory(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                return 1;
            }
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                return 2;
            }
            case 301: 
            case 302: {
                return 3;
            }
        }
        return -1;
    }
}

