/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.SizeUnit;
import com.helpsystems.enterprise.core.busobj.AgentEventFile;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitorProxy;
import junit.framework.TestCase;

public class AgentEventFileTest
extends TestCase {
    AgentEventFile aef;

    protected void setUp() throws Exception {
        super.setUp();
        this.aef = new AgentEventFile();
    }

    protected void tearDown() throws Exception {
        this.aef = null;
        super.tearDown();
    }

    public void testParentType() {
        AgentEventFile agentEventFile = new AgentEventFile(1);
        AgentEventFileTest.assertEquals((int)agentEventFile.getParentType(), (int)1);
        agentEventFile.setParentType(2);
        AgentEventFileTest.assertEquals((int)agentEventFile.getParentType(), (int)2);
    }

    public void testGetOID() {
        this.aef.setOID(12345L);
        AgentEventFileTest.assertEquals((long)12345L, (long)this.aef.getOID());
    }

    public void testGetFileFilter() {
        AgentEventFileTest.assertNull((Object)this.aef.getFilePath());
        this.aef.setFilePath("/some/dir/structure/to/*.txt");
        AgentEventFileTest.assertEquals((String)"/some/dir/structure/to/*.txt", (String)this.aef.getFilePath());
        this.aef.setFilePath("/some/dir/structure/to/*");
        AgentEventFileTest.assertEquals((String)"/some/dir/structure/to/*", (String)this.aef.getFilePath());
    }

    public void testGetIncreaseSize() {
        AgentEventFileTest.assertEquals((int)0, (int)this.aef.getIncreaseSize());
        this.aef.setIncreaseSize(60);
        AgentEventFileTest.assertEquals((int)60, (int)this.aef.getIncreaseSize());
    }

    public void testGetIncreaseSizeUnit() {
        AgentEventFileTest.assertEquals((Object)SizeUnit.BYTES, (Object)this.aef.getIncreaseSizeUnit());
        this.aef.setIncreaseSizeUnit(SizeUnit.TERABYTES);
        AgentEventFileTest.assertEquals((Object)SizeUnit.TERABYTES, (Object)this.aef.getIncreaseSizeUnit());
    }

    public void testGetIncreaseSizeInt() {
        AgentEventFileTest.assertEquals((int)0, (int)this.aef.getIncreaseSizeUnitInt());
        this.aef.setIncreaseSizeUnitInt(1);
        AgentEventFileTest.assertEquals((int)1, (int)this.aef.getIncreaseSizeUnitInt());
    }

    public void testGetDecreaseSize() {
        AgentEventFileTest.assertEquals((int)0, (int)this.aef.getDecreaseSize());
        this.aef.setDecreaseSize(30);
        AgentEventFileTest.assertEquals((int)30, (int)this.aef.getDecreaseSize());
    }

    public void testGetDecreaseSizeUnit() {
        AgentEventFileTest.assertEquals((Object)SizeUnit.BYTES, (Object)this.aef.getDecreaseSizeUnit());
        this.aef.setDecreaseSizeUnit(SizeUnit.ZETABYTES);
        AgentEventFileTest.assertEquals((Object)SizeUnit.ZETABYTES, (Object)this.aef.getDecreaseSizeUnit());
    }

    public void testGetDecreaseSizeInt() {
        AgentEventFileTest.assertEquals((int)0, (int)this.aef.getDecreaseSizeUnitInt());
        this.aef.setDecreaseSizeUnitInt(3);
        AgentEventFileTest.assertEquals((int)3, (int)this.aef.getDecreaseSizeUnitInt());
    }

    public void testGetIncreasedFlag() {
        AgentEventFileTest.assertFalse((boolean)this.aef.isIncreasedFlag());
        AgentEventFileTest.assertFalse((boolean)this.aef.getIncreasedFlag());
        this.aef.setIncreasedFlag(true);
        AgentEventFileTest.assertTrue((boolean)this.aef.isIncreasedFlag());
        AgentEventFileTest.assertTrue((boolean)this.aef.getIncreasedFlag());
        this.aef.setIncreasedFlag(false);
        AgentEventFileTest.assertFalse((boolean)this.aef.isIncreasedFlag());
        AgentEventFileTest.assertFalse((boolean)this.aef.getIncreasedFlag());
    }

    public void testGetDecreasedFlag() {
        AgentEventFileTest.assertFalse((boolean)this.aef.isDecreasedFlag());
        AgentEventFileTest.assertFalse((boolean)this.aef.getDecreasedFlag());
        this.aef.setDecreasedFlag(true);
        AgentEventFileTest.assertTrue((boolean)this.aef.isDecreasedFlag());
        AgentEventFileTest.assertTrue((boolean)this.aef.getDecreasedFlag());
        this.aef.setDecreasedFlag(false);
        AgentEventFileTest.assertFalse((boolean)this.aef.isDecreasedFlag());
        AgentEventFileTest.assertFalse((boolean)this.aef.getDecreasedFlag());
    }

    public void testGetChangeDateFlag() {
        AgentEventFileTest.assertFalse((boolean)this.aef.isChangeDateFlag());
        AgentEventFileTest.assertFalse((boolean)this.aef.getChangeDateFlag());
        this.aef.setChangeDateFlag(true);
        AgentEventFileTest.assertTrue((boolean)this.aef.isChangeDateFlag());
        AgentEventFileTest.assertTrue((boolean)this.aef.getChangeDateFlag());
        this.aef.setChangeDateFlag(false);
        AgentEventFileTest.assertFalse((boolean)this.aef.isChangeDateFlag());
        AgentEventFileTest.assertFalse((boolean)this.aef.getChangeDateFlag());
    }

    public void testGetFireWhenIncreasing() {
        AgentEventFileTest.assertEquals((int)0, (int)this.aef.getFireWhenIncreasing());
        this.aef.setFireWhenIncreasing(1);
        AgentEventFileTest.assertEquals((int)1, (int)this.aef.getFireWhenIncreasing());
        this.aef.setFireWhenIncreasing(2);
        AgentEventFileTest.assertEquals((int)2, (int)this.aef.getFireWhenIncreasing());
        this.aef.setFireWhenIncreasing(0);
        AgentEventFileTest.assertEquals((int)0, (int)this.aef.getFireWhenIncreasing());
    }

    public void testGetFireWhenDecreasing() {
        AgentEventFileTest.assertEquals((int)0, (int)this.aef.getFireWhenDecreasing());
        this.aef.setFireWhenDecreasing(1);
        AgentEventFileTest.assertEquals((int)1, (int)this.aef.getFireWhenDecreasing());
        this.aef.setFireWhenDecreasing(2);
        AgentEventFileTest.assertEquals((int)2, (int)this.aef.getFireWhenDecreasing());
        this.aef.setFireWhenDecreasing(0);
        AgentEventFileTest.assertEquals((int)0, (int)this.aef.getFireWhenDecreasing());
    }

    public void testEncodeHexString() throws Exception {
        AgentEventFileTest.assertEquals((String)"4142434445", (String)AgentEventFile.encodeHexString("TEST", "Cp437", "ABCDE", 5));
    }

    public void testEncodeWithNullCharsetThrowsException() {
        try {
            AgentEventFile.encodeHexString("TEST", "", "ABCDE", 5);
            AgentEventFileTest.fail((String)"encodeHexString accepted null charset name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            AgentEventFile.encodeHexString("TEST", null, "ABCDE", 5);
            AgentEventFileTest.fail((String)"encodeHexString accepted null charset name");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEncodeWithInvalidCharsetThrowsException() {
        try {
            AgentEventFile.encodeHexString("TEST", "BogusBaby", "ABCDE", 5);
            AgentEventFileTest.fail((String)"encodeHexString accepted invalid charset name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEncodeThrowsExceptionIfCharsetCannotEncode() {
        try {
            AgentEventFile.encodeHexString("TEST", "ISO-2022-CN", "ABCDE", 5);
            AgentEventFileTest.fail((String)"encodeHexString accepted charset name that cannot encode");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEncodeThrowsExceptionIfCharsetCannotEncode2() {
        try {
            char c;
            char c2 = '\u0000';
            char[] cArray = new char[8];
            do {
                cArray[0] = c2;
                cArray[1] = '\u0000';
                String string = new String(cArray);
                AgentEventFile.encodeHexString("TEST", "utf7", string, 8);
                c = c2;
                c2 = (char)(c2 + '\u0001');
            } while (c < '\uffff');
            AgentEventFileTest.fail((String)"encodeHexString accepted charset name that cannot encode");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDecodeHexString() throws Exception {
        AgentEventFileTest.assertEquals((String)"OPQRSTUV", (String)AgentEventFile.decodeHexString("Cp437", "4F50515253545556"));
    }

    public void testDecodeThrowsExceptionIfCharsetCannotEncode() {
        try {
            AgentEventFile.decodeHexString("ISO-2022-CN-CS", "4F50515253545556");
            AgentEventFileTest.fail((String)"decodeHexString accepted charset name that cannot encode");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDecodeWithNullCharsetThrowsException() {
        try {
            AgentEventFile.decodeHexString("", "6E6F7071727374");
            AgentEventFileTest.fail((String)"decodeHexString accepted null charset name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDecodeWithInvalidCharsetThrowsException() {
        try {
            AgentEventFile.decodeHexString("BogusBaby", "6E6F7071727374");
            AgentEventFileTest.fail((String)"decodeHexString accepted null charset name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetEofTestType() {
        this.aef.setEofTest(0);
        AgentEventFileTest.assertEquals((int)0, (int)this.aef.getEofTest());
        this.aef.setEofTest(1);
        AgentEventFileTest.assertEquals((int)1, (int)this.aef.getEofTest());
        this.aef.setEofTest(2);
        AgentEventFileTest.assertEquals((int)2, (int)this.aef.getEofTest());
    }

    public void testSetEofTextMarker() {
        String string = "4142434445";
        this.aef.setEofTextMarker(string);
        AgentEventFileTest.assertEquals((String)this.aef.getEofTextMarker(), (String)string);
    }

    public void testSetEofTextEncoding() {
        String string = "Cp437";
        this.aef.setEofTextEncoding(string);
        AgentEventFileTest.assertEquals((String)this.aef.getEofTextEncoding(), (String)string);
    }

    public void testSetEofHexMarker() {
        String string = "0102030405060708091011121314151617181920A";
        try {
            this.aef.setEofHexMarker("123");
            AgentEventFileTest.fail((String)"setEofHexMarker() accepted an odd number of digits");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.aef.setEofHexMarker("123G");
            AgentEventFileTest.fail((String)"setEofHexMarker() accepted an invalid hex digit");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.aef.setEofHexMarker(string);
            AgentEventFileTest.fail((String)"setEofHexMarker() accepted two many digits");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String string2 = "525456585A5C5E";
        this.aef.setEofHexMarker(string2);
        AgentEventFileTest.assertEquals((String)this.aef.getEofHexMarker(), (String)string2);
    }

    public void testGetTypeDescription() {
        int n = 0;
        String string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"Manual", (String)string);
        n = 101;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"File Added", (String)string);
        n = 103;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"File Changed", (String)string);
        n = 102;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"File Removed", (String)string);
        n = 104;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"File Threshold", (String)string);
        n = 201;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"Directory Added", (String)string);
        n = 203;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"Directory Changed", (String)string);
        n = 202;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"Directory Removed", (String)string);
        n = 204;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"Directory Threshold", (String)string);
        n = 302;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"Process Ended", (String)string);
        n = 301;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)"Process Started", (String)string);
        n = 9999;
        string = AgentEventMonitorProxy.getTypeDescription(n);
        AgentEventFileTest.assertEquals((String)("Unsupported type: " + new Integer(n)), (String)string);
    }

    public void testGetTypeCategory() {
        int n = 0;
        AgentEventFileTest.assertEquals((int)0, (int)AgentEventMonitorProxy.getTypeCategory(n));
        n = 103;
        AgentEventFileTest.assertEquals((int)1, (int)AgentEventMonitorProxy.getTypeCategory(n));
        n = 202;
        AgentEventFileTest.assertEquals((int)2, (int)AgentEventMonitorProxy.getTypeCategory(n));
        n = 301;
        AgentEventFileTest.assertEquals((int)3, (int)AgentEventMonitorProxy.getTypeCategory(n));
        n = 999;
        AgentEventFileTest.assertEquals((int)-1, (int)AgentEventMonitorProxy.getTypeCategory(n));
    }

    public void testSetGreaterThanFlag() {
        this.aef.setGreaterThanFlag(false);
        AgentEventFileTest.assertFalse((boolean)this.aef.isGreaterThanFlag());
        AgentEventFileTest.assertFalse((boolean)this.aef.getGreaterThanFlag());
        this.aef.setGreaterThanFlag(true);
        AgentEventFileTest.assertTrue((boolean)this.aef.isGreaterThanFlag());
        AgentEventFileTest.assertTrue((boolean)this.aef.getGreaterThanFlag());
    }

    public void testSetLessThanFlag() {
        this.aef.setLessThanFlag(false);
        AgentEventFileTest.assertFalse((boolean)this.aef.isLessThanFlag());
        AgentEventFileTest.assertFalse((boolean)this.aef.getLessThanFlag());
        this.aef.setLessThanFlag(true);
        AgentEventFileTest.assertTrue((boolean)this.aef.isLessThanFlag());
        AgentEventFileTest.assertTrue((boolean)this.aef.getLessThanFlag());
    }
}

