/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.SkybotVariable;
import com.helpsystems.enterprise.core.busobj.SkybotVariableResolveException;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class AgentEnvironmentVariable
extends EnterpriseProxy {
    private static Logger logger = Logger.getLogger(AgentEnvironmentVariable.class);
    private static final long serialVersionUID = -978942508814262031L;
    private long parentOid;
    private long oid;
    private String variable = "";
    private String resolvedValue = null;
    private SkybotVariable skybotVariable;
    private boolean modified;

    public AgentEnvironmentVariable() {
        this.addDoNotInvoke("getWorkingOID");
    }

    public void setName(String string) {
        if (!string.equals(this.getName())) {
            super.setName(string);
            this.modified = true;
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public long getParentOid() {
        return this.parentOid;
    }

    public void setParentOid(long l) {
        if (l != this.parentOid) {
            this.parentOid = l;
            this.modified = true;
        }
    }

    public long getOid() {
        return this.oid;
    }

    public void setOid(long l) {
        this.oid = l;
    }

    public void setVariable(String string) {
        if (!string.equals(this.variable)) {
            this.variable = string;
            this.modified = true;
        }
    }

    public SkybotVariable getSkybotVariable() {
        return this.skybotVariable;
    }

    public void setSkybotVariable(SkybotVariable skybotVariable) {
        this.skybotVariable = skybotVariable;
    }

    public boolean wasModified() {
        return this.modified;
    }

    public void resetModifiedFlag() {
        this.modified = false;
    }

    public boolean equals(Object object) {
        AgentEnvironmentVariable agentEnvironmentVariable;
        return object instanceof AgentEnvironmentVariable && this.oid == (agentEnvironmentVariable = (AgentEnvironmentVariable)((Object)object)).getOid();
    }

    public int hashCode() {
        return String.valueOf(this.oid).hashCode();
    }

    public AgentEnvironmentVariable clone() {
        AgentEnvironmentVariable agentEnvironmentVariable = new AgentEnvironmentVariable();
        agentEnvironmentVariable.setOid(this.getOid());
        agentEnvironmentVariable.setParentOid(this.getParentOid());
        agentEnvironmentVariable.setVariable(this.getVariable());
        agentEnvironmentVariable.setName(this.getName());
        agentEnvironmentVariable.modified = this.modified;
        return agentEnvironmentVariable;
    }

    public String getResolvedValue() {
        if (this.resolvedValue == null) {
            throw new IllegalStateException("Environment variable value has not been resolved for " + this.getName() + ".");
        }
        return this.resolvedValue;
    }

    public void setResolvedValue(CalendarObject calendarObject, long l, String string) throws SkybotVariableResolveException {
        if (this.skybotVariable == null) {
            this.resolvedValue = this.getVariable();
        } else if (this.skybotVariable.isStaticValue()) {
            this.resolvedValue = this.skybotVariable.getValue();
        } else {
            Calendar calendar = Calendar.getInstance();
            if (string != null && string.trim().length() > 0) {
                try {
                    calendar.setTimeZone(TimeZone.getTimeZone(string.trim()));
                }
                catch (Exception exception) {
                    logger.error((Object)("Error loading timezone (" + string + ") for Agent Environment Variable."), (Throwable)exception);
                }
            }
            calendar.setTimeInMillis(l);
            this.resolvedValue = this.skybotVariable.getValue(calendarObject, calendar);
        }
    }
}

