/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.AgentEnvironmentVariable;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AgentEnvironment
extends EnterpriseProxy {
    private static final long serialVersionUID = 2766771632747558156L;
    public static final int TYPE_PRIVATE = 1;
    public static final int TYPE_SHARED = 2;
    public static final int RUN_TYPE_SHARED_ENV = 1;
    public static final int RUN_TYPE_USER = 2;
    public static final int RUN_TYPE_AGENT = 3;
    public static final int RUN_TYPE_SETUID = 4;
    private static final Set<Integer> VALID_RUN_TYPES = new HashSet<Integer>();
    public static final String USE_VALUE_FROM_SHARED_ENVIRONMENT = "*SHARED";
    private long oid;
    private int type = 1;
    private int runType = 2;
    private long refSharedOID = 0L;
    private String sharedAgentEnvName = "";
    private String userProfile = "";
    private String password = "";
    private String encryptedPassword = "";
    private String workingPath = "";
    private ArrayList<AgentEnvironmentVariable> activeVariables = new ArrayList();

    public AgentEnvironment() {
        this.addDoNotInvoke("setVariableList");
        this.addDoNotInvoke("getMap");
        this.addDoNotInvoke("getPassword");
        this.addDoNotInvoke("getEncryptedPassword");
    }

    public long getOid() {
        return this.oid;
    }

    public void setOid(long l) {
        this.oid = l;
    }

    public void setName(String string) {
        super.setName(string);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"{0} is an invalid Type.", (Object[])new Object[]{n}));
        }
        if (n == 2) {
            this.setRefSharedOID(0L);
        }
        this.type = n;
    }

    public int getRunType() {
        return this.runType;
    }

    public void setRunType(int n) {
        if (!VALID_RUN_TYPES.contains(n)) {
            throw new IllegalArgumentException("Invalid run-type: " + n);
        }
        this.runType = n;
    }

    public long getRefSharedOID() {
        return this.refSharedOID;
    }

    public void setRefSharedOID(long l) {
        if (l > 0L && this.getType() == 2) {
            throw new IllegalArgumentException("Unable to set Shared OID while environment type is Shared.");
        }
        this.refSharedOID = l;
    }

    public String getSharedAgentEnvName() {
        return this.sharedAgentEnvName;
    }

    public void setSharedAgentEnvName(String string) {
        if (string == null) {
            this.sharedAgentEnvName = "";
            return;
        }
        this.sharedAgentEnvName = string.trim();
    }

    public String getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(String string) {
        this.userProfile = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        String string2 = string;
        string2 = string2 == null ? "" : string2.trim();
        this.password = string2;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String string) {
        String string2 = string;
        string2 = string2 == null ? "" : string2.trim();
        this.encryptedPassword = string2;
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String string) {
        this.workingPath = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AgentEnvironment)) {
            return false;
        }
        AgentEnvironment agentEnvironment = (AgentEnvironment)((Object)object);
        return super.equals(object) && Equal.isEqual((long)this.getOid(), (long)agentEnvironment.getOid());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public AgentEnvironmentVariable[] getVariables() {
        AgentEnvironmentVariable[] agentEnvironmentVariableArray = new AgentEnvironmentVariable[this.activeVariables.size()];
        agentEnvironmentVariableArray = this.activeVariables.toArray(agentEnvironmentVariableArray);
        return agentEnvironmentVariableArray;
    }

    public void setVariableList(AgentEnvironmentVariable[] agentEnvironmentVariableArray) {
        this.activeVariables.clear();
        for (int i = 0; i < agentEnvironmentVariableArray.length; ++i) {
            this.activeVariables.add(agentEnvironmentVariableArray[i]);
        }
    }

    public boolean hasVariables() {
        return !this.activeVariables.isEmpty();
    }

    public boolean isEmpty() {
        return this.activeVariables.isEmpty();
    }

    public boolean isPrivate() {
        return this.getType() == 1;
    }

    public boolean isShared() {
        return this.getType() == 2;
    }

    public boolean isSharedWithOverrides() {
        return this.getType() == 1 && this.getRefSharedOID() > 0L;
    }

    public Map<String, String> getMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (AgentEnvironmentVariable agentEnvironmentVariable : this.activeVariables) {
            hashMap.put(agentEnvironmentVariable.getName(), agentEnvironmentVariable.getResolvedValue());
        }
        return hashMap;
    }

    public boolean containsVariable(AgentEnvironmentVariable agentEnvironmentVariable) {
        return this.activeVariables.contains((Object)agentEnvironmentVariable);
    }

    public String getRunTypeName(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "Shared Agent Environment";
                break;
            }
            case 3: {
                string = "Run as Agent's User";
                break;
            }
            case 4: {
                string = "'setuid' (UNIX Agents Only)";
                break;
            }
            case 2: {
                string = "User Name and Password";
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Run Type Option: " + n);
            }
        }
        return string;
    }

    static {
        VALID_RUN_TYPES.add(1);
        VALID_RUN_TYPES.add(2);
        VALID_RUN_TYPES.add(3);
        VALID_RUN_TYPES.add(4);
    }
}

