/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.access.scheduler.PrerequisiteEntryListJdbc;
import com.helpsystems.enterprise.access.scheduler.PrerequisiteMarkerListJdbc;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitorProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgent;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.PrereqEvent;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.PrereqStatus;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteEntry;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteEntryList;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteMarkerList;
import com.helpsystems.enterprise.core.scheduler.PrerequisitesDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PrerequisitesDMJdbc
extends AbstractDatabaseManager
implements PrerequisitesDM {
    private static final Logger logger = Logger.getLogger(PrerequisitesDMJdbc.class);
    private static final String TABLE = "dependencies";
    private static final String PRQSTS_TABLE = "prerequisite_statuses";
    private String table;
    private String prereqStatusTable;
    private PrereqDM prereqDM;
    private ScheduleJobDM scheduleJobDM;
    private AgentGroupDM agentGroupDM;

    public PrerequisitesDMJdbc(String string, String string2, String string3, PrereqDM prereqDM, ScheduleJobDM scheduleJobDM, AgentGroupDM agentGroupDM) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.table = string2 + "." + TABLE;
        this.prereqStatusTable = string2 + "." + PRQSTS_TABLE;
        this.setName(string3);
        this.prereqDM = prereqDM;
        this.scheduleJobDM = scheduleJobDM;
        this.agentGroupDM = agentGroupDM;
    }

    @Override
    public PrerequisiteEntryList createPrerequisiteEntryList() throws ResourceUnavailableException {
        String string = "SELECT id, dependent_job_id, special_instance_id, latch_status, react_to_status FROM " + this.table + " WHERE prereq_object_id=? and prereq_type=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        PrerequisiteEntryGenerator prerequisiteEntryGenerator = new PrerequisiteEntryGenerator();
        return new PrerequisiteEntryListJdbc(preparedStatement, (BusinessObjectGenerator)prerequisiteEntryGenerator);
    }

    @Override
    public void retrievePrerequisiteEntriesForEvent(int n, PrerequisiteEntryList prerequisiteEntryList, PrereqEventType prereqEventType) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"PrerequisiteEntry List", (Object)prerequisiteEntryList);
        PreparedStatement preparedStatement = ((PrerequisiteEntryListJdbc)prerequisiteEntryList).getPrereqStmt();
        try {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, prereqEventType.persistanceCode());
            ((PrerequisiteEntryListJdbc)prerequisiteEntryList).runQuery(preparedStatement);
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {1} Prerequisite entries for {0}.", (Object[])new Object[]{n, prereqEventType.toString()});
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    @Override
    public void closeRS(PrerequisiteEntryList prerequisiteEntryList) {
        ((PrerequisiteEntryListJdbc)prerequisiteEntryList).closeRS();
    }

    @Override
    public PrerequisiteMarkerList createPrerequisiteMarkerList(PrerequisiteEntryList prerequisiteEntryList) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"PrerequisiteEntry List", (Object)prerequisiteEntryList);
        Connection connection = this.extractConnectionFromPrerequisiteEntryList(prerequisiteEntryList);
        String string = "UPDATE " + this.prereqStatusTable + " SET last_status=?, history_id=?, status_time_utc=?, prereq_type=?" + " WHERE dependency_id=? and dep_agent_id=? and prereq_agent_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        String string2 = "UPDATE " + this.prereqStatusTable + " SET last_status=?, history_id=?, status_time_utc=?, prereq_type=?, prereq_agent_id=?" + " WHERE dependency_id=? and dep_agent_id=?";
        PreparedStatement preparedStatement2 = this.getDefaultPreparedStmt(string2, connection);
        String string3 = "insert into " + this.prereqStatusTable + " (DEPENDENCY_ID, LAST_STATUS, PREREQ_AGENT_ID," + " HISTORY_ID, STATUS_TIME_UTC, PREREQ_TYPE, DEP_JOB_ID, DEP_AGENT_ID)" + " values (?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement3 = this.getDefaultPreparedStmt(string3, connection);
        String string4 = "delete from " + this.prereqStatusTable + " WHERE dependency_id=? and dep_agent_id=?";
        PreparedStatement preparedStatement4 = this.getDefaultPreparedStmt(string4, connection);
        return new PrerequisiteMarkerListJdbc(preparedStatement, preparedStatement2, preparedStatement3, preparedStatement4);
    }

    @Override
    public void markPrerequisiteStatus(PrerequisiteMarkerList prerequisiteMarkerList, PrereqEvent prereqEvent, Object object) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"PrerequisiteMarker List", (Object)prerequisiteMarkerList);
        PreparedStatement preparedStatement = ((PrerequisiteMarkerListJdbc)prerequisiteMarkerList).getUpdateSpecificAgentPrereqStmt();
        PreparedStatement preparedStatement2 = ((PrerequisiteMarkerListJdbc)prerequisiteMarkerList).getUpdateAnyAgentPrereqStmt();
        PrerequisiteEntry[] prerequisiteEntryArray = prerequisiteMarkerList.getPrerequisiteEntries();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Marking Reactivity for prereq event: " + prereqEvent.toString()));
        }
        if (object != null) {
            Proxy proxy;
            if (object instanceof ScheduleJobProxy) {
                proxy = (ScheduleJobProxy)((Object)object);
                if (proxy.getModel() != 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Prereq Job (" + proxy.getName() + ") is assigned to prereq Agent Group " + proxy.getModel() + "."));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Prereq Job (" + proxy.getName() + ") is assigned to prereq Agent " + proxy.getSystem() + "."));
                }
            } else if (object instanceof AgentEventMonitor) {
                proxy = (AgentEventMonitor)((Object)object);
                if (logger.isDebugEnabled()) {
                    if (proxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                        logger.debug((Object)("Prereq AEM (" + proxy.getName() + ") is assigned to prereq Agent Group " + proxy.getTargetID() + "."));
                    } else {
                        logger.debug((Object)("Prereq AEM (" + proxy.getName() + ") is assigned to prereq Agent " + proxy.getTargetID() + "."));
                    }
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Prereq object class is: " + object.getClass().getName()));
            }
        } else if (object == null && prereqEvent.getType() != PrereqEventType.REMOTE_EVENT && prereqEvent.getType() != PrereqEventType.SAP_MONITOR_EVENT && prereqEvent.getType() != PrereqEventType.SNMP_TRAP_EVENT && logger.isDebugEnabled()) {
            logger.debug((Object)"Prereq object is null.");
        }
        for (int i = 0; i < prerequisiteEntryArray.length; ++i) {
            int n;
            int n2;
            long l = prerequisiteMarkerList.getSystem();
            long[] lArray = null;
            AgentGroupProxy agentGroupProxy = null;
            try {
                ScheduleJobProxy scheduleJobProxy;
                if (object instanceof ScheduleJobProxy) {
                    if (this.isPrereqOnAgentGroup(object)) {
                        scheduleJobProxy = (ScheduleJobProxy)((Object)object);
                        agentGroupProxy = this.agentGroupDM.getProxy(scheduleJobProxy.getModel());
                    }
                } else if (object instanceof AgentEventMonitorProxy && this.isPrereqOnAgentGroup(object)) {
                    AgentEventMonitorProxy agentEventMonitorProxy = (AgentEventMonitorProxy)((Object)object);
                    agentGroupProxy = this.agentGroupDM.getProxy(agentEventMonitorProxy.getTargetID());
                }
                if (prereqEvent.getUserEventDepAgentID() != 0L) {
                    lArray = new long[]{prereqEvent.getUserEventDepAgentID()};
                } else {
                    scheduleJobProxy = this.scheduleJobDM.getScheduleJobProxy(prerequisiteEntryArray[i].getDepJobID());
                    AgentGroupProxy agentGroupProxy2 = null;
                    if (scheduleJobProxy.getModel() != 0) {
                        agentGroupProxy2 = this.agentGroupDM.getProxy(scheduleJobProxy.getModel());
                    }
                    if (scheduleJobProxy.getModel() != 0 && agentGroupProxy2.getAgentGroupType() == AgentGroupType.ALL_AGENTS) {
                        if (this.isPrereqOnAgentGroup(object)) {
                            if (agentGroupProxy.getAgentGroupType() == AgentGroupType.ALL_AGENTS) {
                                if (this.isDepRunOnPrereqAgent(l, scheduleJobProxy)) {
                                    lArray = new long[]{l};
                                } else {
                                    logger.debug((Object)("Dependent job does not run on prereq agent: " + l));
                                    lArray = new long[]{};
                                }
                            } else {
                                lArray = this.getAgentList(scheduleJobProxy.getModel());
                            }
                        } else {
                            lArray = this.getAgentList(scheduleJobProxy.getModel());
                        }
                    } else {
                        lArray = this.isPrereqOnAgentGroup(object) ? new long[]{scheduleJobProxy.getSystem()} : new long[]{scheduleJobProxy.getSystem()};
                    }
                }
            }
            catch (Throwable throwable) {
                String string = "Error getting prereq/dep agent information.";
                logger.error((Object)string, throwable);
                continue;
            }
            boolean bl = false;
            for (n2 = 0; n2 < lArray.length; ++n2) {
                try {
                    Object object2;
                    int n3 = 0;
                    n = 0;
                    boolean bl2 = false;
                    if (agentGroupProxy == null || agentGroupProxy.getAgentGroupType() == AgentGroupType.ALL_AGENTS) {
                        bl2 = this.isCurrentStatusLatched(prereqEvent, prerequisiteEntryArray[i], lArray[n2], l);
                        if (!bl2) {
                            preparedStatement.setString(1, prerequisiteMarkerList.getStatus());
                            preparedStatement.setLong(2, prereqEvent.getHistoryOID());
                            preparedStatement.setLong(3, prereqEvent.getTimestamp());
                            preparedStatement.setInt(4, prerequisiteMarkerList.getPrereqEventType().persistanceCode());
                            preparedStatement.setInt(5, prerequisiteEntryArray[i].getOid());
                            preparedStatement.setLong(6, lArray[n2]);
                            preparedStatement.setLong(7, l);
                            n3 = preparedStatement.executeUpdate();
                        }
                    } else {
                        bl2 = this.isCurrentStatusLatched(prereqEvent, prerequisiteEntryArray[i], lArray[n2]);
                        if (!bl2) {
                            preparedStatement2.setString(1, prerequisiteMarkerList.getStatus());
                            preparedStatement2.setLong(2, prereqEvent.getHistoryOID());
                            preparedStatement2.setLong(3, prereqEvent.getTimestamp());
                            preparedStatement2.setInt(4, prerequisiteMarkerList.getPrereqEventType().persistanceCode());
                            preparedStatement2.setLong(5, l);
                            preparedStatement2.setInt(6, prerequisiteEntryArray[i].getOid());
                            preparedStatement2.setLong(7, lArray[n2]);
                            n3 = preparedStatement2.executeUpdate();
                            if (n3 > 1) {
                                logger.error((Object)("ERROR: More than one prerequisite status was updated for a load balanced agent group dependency: " + n3));
                                object2 = ((PrerequisiteMarkerListJdbc)prerequisiteMarkerList).getDeletePrereqStatusStmt();
                                object2.setInt(1, prerequisiteEntryArray[i].getOid());
                                object2.setLong(2, lArray[n2]);
                                int n4 = object2.executeUpdate();
                                logger.warn((Object)("Obsolete prerequisite status records were deleted: " + n4));
                                n3 = 0;
                            }
                        }
                    }
                    if (n3 > 0) {
                        bl = true;
                    }
                    if (bl2) continue;
                    if (n3 < 1) {
                        object2 = MessageUtil.formatMsg((String)"Could not find Prerequisite status record for dep_oid {0}, for prereq agent {1}, dependent agent {2}.", (Object[])new Object[]{prerequisiteEntryArray[i].getOid(), l, lArray[n2]});
                        logger.debug(object2);
                        PreparedStatement preparedStatement3 = ((PrerequisiteMarkerListJdbc)prerequisiteMarkerList).getInsertStmt();
                        preparedStatement3.setLong(1, prerequisiteEntryArray[i].getOid());
                        preparedStatement3.setString(2, prerequisiteMarkerList.getStatus());
                        preparedStatement3.setLong(3, l);
                        preparedStatement3.setLong(4, prereqEvent.getHistoryOID());
                        preparedStatement3.setLong(5, prereqEvent.getTimestamp());
                        preparedStatement3.setLong(6, prerequisiteMarkerList.getPrereqEventType().persistanceCode().intValue());
                        preparedStatement3.setLong(7, prerequisiteEntryArray[i].getDepJobID());
                        preparedStatement3.setLong(8, lArray[n2]);
                        n = preparedStatement3.executeUpdate();
                        if (n < 1) {
                            String string = MessageUtil.formatMsg((String)"Could not insert a Prerequisite status record for dep_oid {0}, for prereq agent {1} dependent agent {2}.", (Object[])new Object[]{prerequisiteEntryArray[i].getOid(), l, lArray[n2]});
                            logger.debug((Object)string);
                        }
                        if (n == 1) {
                            bl = true;
                        }
                        continue;
                    }
                    if (n3 <= 1) continue;
                    object2 = MessageUtil.formatMsg((String)"Program error: More than 1 Prerequisite status was updated for dep_oid {0}, for system {1}. Actual count = {2}).", (Object[])new Object[]{prerequisiteEntryArray[i], l, n3});
                    logger.debug(object2);
                    throw new RuntimeException((String)object2);
                }
                catch (SQLException sQLException) {
                    String string = MessageUtil.formatMsg((String)"SQL error while marking the Prerequisite status for dep_oid {0}, for system {1}.", (Object[])new Object[]{prerequisiteEntryArray[i], l});
                    throw new ResourceUnavailableException(string, (Throwable)sQLException);
                }
            }
            n2 = this.prereqSatisfied(prerequisiteEntryArray[i].getReactToStatus(), prerequisiteMarkerList.getStatus()) ? 1 : 0;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting check dependencies: " + (n2 != 0)));
            }
            prerequisiteEntryArray[i].setCheckDependencies(n2 != 0);
            if (!logger.isDebugEnabled()) continue;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < lArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(lArray[n]);
            }
            if (bl) {
                String string = MessageUtil.formatMsg((String)"Prerequisite for job {0} on agent(s) {1} was inserted/updated with status {2} from object {3} on agent {4}.", (Object[])new Object[]{String.valueOf(prerequisiteEntryArray[i].getDepJobID()), String.valueOf(stringBuffer.toString()), prerequisiteMarkerList.getStatus(), String.valueOf(prerequisiteMarkerList.getPrereqObjectOID()), String.valueOf(l)});
                logger.debug((Object)string);
                continue;
            }
            String string = MessageUtil.formatMsg((String)"Prerequisite for job {0} on agent(s) {1} was NOT updated with status {2} from object {3} on agent {4}.", (Object[])new Object[]{String.valueOf(prerequisiteEntryArray[i].getDepJobID()), String.valueOf(stringBuffer.toString()), prerequisiteMarkerList.getStatus(), String.valueOf(prerequisiteMarkerList.getPrereqObjectOID()), String.valueOf(l)});
            logger.debug((Object)string);
        }
    }

    private boolean isCurrentStatusLatched(PrereqEvent prereqEvent, PrerequisiteEntry prerequisiteEntry, long l, long l2) {
        String string = "Prereq ID: " + prerequisiteEntry.getOid() + " Dependent Agent ID: " + l + " Prereq Agent ID: " + l2;
        try {
            if (prerequisiteEntry.isLatchStatus()) {
                PrereqStatus[] prereqStatusArray = this.prereqDM.getPrereqStatus(prerequisiteEntry.getOid(), l, l2);
                if (prereqStatusArray.length > 1) {
                    logger.warn((Object)("Ignoring Latch Flag: Multiple prerequisite statuses were found." + string));
                    return false;
                }
                if (prereqStatusArray.length == 0) {
                    logger.debug((Object)("Latch check did not find a current status for: " + string));
                    return false;
                }
                return this.isPrereqStatusLatched(prereqStatusArray[0], prereqEvent, prerequisiteEntry, string);
            }
            logger.debug((Object)("Prerequisite is not defined as latching: " + string));
        }
        catch (Exception exception) {
            logger.warn((Object)("Error checking latch status: " + exception.getMessage()), (Throwable)exception);
        }
        return false;
    }

    private boolean isCurrentStatusLatched(PrereqEvent prereqEvent, PrerequisiteEntry prerequisiteEntry, long l) {
        String string = "Prereq ID: " + prerequisiteEntry.getOid() + " Dependent Agent ID: " + l;
        try {
            if (prerequisiteEntry.isLatchStatus()) {
                PrereqStatus[] prereqStatusArray = this.prereqDM.getPrereqStatus(prerequisiteEntry.getOid(), l);
                if (prereqStatusArray.length > 1) {
                    logger.warn((Object)("Ignoring Latch Flag: Multiple prerequisite statuses were found." + string));
                    return false;
                }
                if (prereqStatusArray.length == 0) {
                    logger.debug((Object)("Latch check did not find a current status for: " + string));
                    return false;
                }
                return this.isPrereqStatusLatched(prereqStatusArray[0], prereqEvent, prerequisiteEntry, string);
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Error checking latch status: " + exception.getMessage()), (Throwable)exception);
        }
        return false;
    }

    private boolean isPrereqStatusLatched(PrereqStatus prereqStatus, PrereqEvent prereqEvent, PrerequisiteEntry prerequisiteEntry, String string) {
        boolean bl = this.prereqSatisfied(prerequisiteEntry.getReactToStatus(), prereqStatus.getCurrentStatus());
        if (!bl) {
            logger.debug((Object)("The current prereq status " + prereqStatus.getCurrentStatus() + " is not latched for react to status " + prerequisiteEntry.getReactToStatus() + ": " + string));
            return false;
        }
        boolean bl2 = this.prereqSatisfied(prerequisiteEntry.getReactToStatus(), prereqEvent.getPrereqStatus());
        if (!bl2) {
            logger.debug((Object)("The current prereq status " + prereqStatus.getCurrentStatus() + " is latched for react to status " + prerequisiteEntry.getReactToStatus() + " and will NOT be updated with prereq status " + prereqEvent.getPrereqStatus() + ": " + string));
            return true;
        }
        logger.debug((Object)("The current prereq status " + prereqStatus.getCurrentStatus() + " is latched for " + prerequisiteEntry.getReactToStatus() + " but will be updated with prereq status " + prereqEvent.getPrereqStatus() + ": " + string));
        return false;
    }

    private boolean isPrereqOnAgentGroup(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ScheduleJobProxy) {
            ScheduleJobProxy scheduleJobProxy = (ScheduleJobProxy)((Object)object);
            return scheduleJobProxy.getModel() != 0;
        }
        if (object instanceof AgentEventMonitor) {
            AgentEventMonitor agentEventMonitor = (AgentEventMonitor)((Object)object);
            return agentEventMonitor.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP;
        }
        return false;
    }

    private boolean isDepRunOnPrereqAgent(long l, ScheduleJobProxy scheduleJobProxy) {
        if (scheduleJobProxy == null) {
            return false;
        }
        if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
            try {
                AgentGroupAgent agentGroupAgent = this.agentGroupDM.getAgentGroupAgent(scheduleJobProxy.getTargetId(), l, null);
                return !agentGroupAgent.currentlyIgnored(System.currentTimeMillis());
            }
            catch (NoDataException noDataException) {
                return false;
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)"Error checking for agent in dependent job agent group.", (Throwable)resourceUnavailableException);
                return false;
            }
        }
        return scheduleJobProxy.getTargetId() == l;
    }

    private long[] getAgentList(long l) {
        try {
            return this.agentGroupDM.getAgentsIDsInGroup(l, null);
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error loading agents for agent group " + l + "."), throwable);
            return new long[0];
        }
    }

    private boolean prereqSatisfied(PrereqStatusType prereqStatusType, PrereqStatusType prereqStatusType2) {
        if (prereqStatusType == PrereqStatusType.ENDED) {
            return prereqStatusType2 == PrereqStatusType.CANCELED || prereqStatusType2 == PrereqStatusType.COMPLETED || prereqStatusType2 == PrereqStatusType.FAILED;
        }
        return prereqStatusType == prereqStatusType2;
    }

    private boolean prereqSatisfied(PrereqStatusType prereqStatusType, String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        String string2 = string.trim().toUpperCase();
        if (string2.equals(prereqStatusType.persistanceCode())) {
            return true;
        }
        return prereqStatusType == PrereqStatusType.ENDED && (string2.equals(PrereqStatusType.CANCELED.persistanceCode()) || string2.equals(PrereqStatusType.COMPLETED.persistanceCode()) || string2.equals(PrereqStatusType.FAILED.persistanceCode()));
    }

    private Connection extractConnectionFromPrerequisiteEntryList(PrerequisiteEntryList prerequisiteEntryList) {
        return ((PrerequisiteEntryListJdbc)prerequisiteEntryList).getConnection();
    }

    private class PrerequisiteEntryGenerator
    extends AbstractBusObjGenerator {
        public PrerequisiteEntryGenerator() {
            super(5, "Prerequisite Entry");
        }

        protected Object constructObject() {
            return new PrerequisiteEntry();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            PrerequisiteEntry prerequisiteEntry = (PrerequisiteEntry)((Object)object);
            switch (n) {
                case 1: {
                    prerequisiteEntry.setOid(resultSet.getInt("id"));
                    break;
                }
                case 2: {
                    prerequisiteEntry.setDepJobID(resultSet.getInt("dependent_job_id"));
                    break;
                }
                case 3: {
                    prerequisiteEntry.setSpecialInstanceID(resultSet.getInt("special_instance_id"));
                    break;
                }
                case 4: {
                    prerequisiteEntry.setLatchStatus(resultSet.getBoolean("latch_status"));
                    break;
                }
                case 5: {
                    prerequisiteEntry.setReactToStatus(PrereqStatusType.persistanceCodeToEnum(resultSet.getString("react_to_status")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected void validate(Object object) {
            ((PrerequisiteEntry)((Object)object)).validate();
        }
    }
}

