/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteEntry;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteMarkerList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class PrerequisiteMarkerListJdbc
implements PrerequisiteMarkerList {
    private static final Logger logger = Logger.getLogger(PrerequisiteMarkerListJdbc.class);
    private PrerequisiteEntry[] prerequisiteEntries;
    private int system;
    private int prereqObjectOID;
    private PrereqEventType prereqEventType;
    private String status;
    private Connection con;
    private PreparedStatement updateSpecificAgentPrereqStmt;
    private PreparedStatement updateAnyAgentPrereqStmt;
    private PreparedStatement insertStmt;
    private PreparedStatement deletePrereqStatusStmt;

    PrerequisiteMarkerListJdbc(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3, PreparedStatement preparedStatement4) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Update Specific Agent Prereq Statement", (Object)preparedStatement);
        ValidationHelper.checkForNull((String)"Update Any Agent Prereq Statement", (Object)preparedStatement2);
        this.updateSpecificAgentPrereqStmt = preparedStatement;
        this.updateAnyAgentPrereqStmt = preparedStatement2;
        this.insertStmt = preparedStatement3;
        this.deletePrereqStatusStmt = preparedStatement4;
        this.con = this.extractConnectionFromStmt();
    }

    @Override
    public PrerequisiteEntry[] getPrerequisiteEntries() {
        return this.prerequisiteEntries;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public int getSystem() {
        return this.system;
    }

    @Override
    public int getPrereqObjectOID() {
        return this.prereqObjectOID;
    }

    @Override
    public PrereqEventType getPrereqEventType() {
        return this.prereqEventType;
    }

    @Override
    public void setPrerequisiteEntries(PrerequisiteEntry[] prerequisiteEntryArray) {
        this.prerequisiteEntries = prerequisiteEntryArray;
    }

    @Override
    public void setPrerequisiteEntries(List<PrerequisiteEntry> list) {
        ValidationHelper.checkForNull((String)"Prereq List", list);
        this.prerequisiteEntries = new PrerequisiteEntry[list.size()];
        int n = 0;
        for (PrerequisiteEntry prerequisiteEntry : list) {
            this.prerequisiteEntries[n++] = prerequisiteEntry;
        }
    }

    @Override
    public void setStatus(String string) {
        this.status = string;
    }

    @Override
    public void setSystem(int n) {
        this.system = n;
    }

    @Override
    public void setPrereqObjectOID(int n) {
        this.prereqObjectOID = n;
    }

    @Override
    public void setPrereqEventType(PrereqEventType prereqEventType) {
        this.prereqEventType = prereqEventType;
    }

    @Override
    public void close() {
        this.closeStatement(this.updateSpecificAgentPrereqStmt);
        this.closeStatement(this.updateAnyAgentPrereqStmt);
        this.closeStatement(this.insertStmt);
        this.closeStatement(this.deletePrereqStatusStmt);
        this.closeConnection(this.con);
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    PreparedStatement getUpdateSpecificAgentPrereqStmt() {
        return this.updateSpecificAgentPrereqStmt;
    }

    PreparedStatement getUpdateAnyAgentPrereqStmt() {
        return this.updateAnyAgentPrereqStmt;
    }

    PreparedStatement getInsertStmt() {
        return this.insertStmt;
    }

    PreparedStatement getDeletePrereqStatusStmt() {
        return this.deletePrereqStatusStmt;
    }

    private Connection extractConnectionFromStmt() throws ResourceUnavailableException {
        try {
            return this.updateSpecificAgentPrereqStmt.getConnection();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            logger.debug((Object)"Cannot retrieve Connection from Statement.", (Throwable)sQLException);
            try {
                this.updateSpecificAgentPrereqStmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException2 = sQLException3;
                logger.debug((Object)"SQL error while trying to close the Statement.", (Throwable)sQLException3);
            }
            throw new ResourceUnavailableException("SQL error while trying to build the list.", (Throwable)sQLException2);
        }
    }
}

