/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.Prereq;
import com.helpsystems.enterprise.core.scheduler.PrereqList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PrereqListJdbc
implements PrereqList {
    private static final Logger logger = Logger.getLogger(PrereqListJdbc.class);
    private Connection con;
    private PreparedStatement listStmt;
    private ResultSet listRS;
    BusinessObjectGenerator busObjGenerator;

    PrereqListJdbc(PreparedStatement preparedStatement, BusinessObjectGenerator businessObjectGenerator) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Prereq Prepared Statement", (Object)preparedStatement);
        ValidationHelper.checkForNull((String)"Business Object Generator", (Object)businessObjectGenerator);
        this.listStmt = preparedStatement;
        this.busObjGenerator = businessObjectGenerator;
        this.con = this.extractConnectionFromStmt();
    }

    @Override
    public boolean next() throws ResourceUnavailableException {
        try {
            return this.listRS.next();
        }
        catch (SQLException sQLException) {
            String string = "SQL error while positioning to the next item in the list.";
            logger.debug((Object)string, (Throwable)sQLException);
            this.close();
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    @Override
    public Prereq getPrereq() throws ResourceUnavailableException {
        Prereq prereq;
        try {
            prereq = (Prereq)((Object)this.busObjGenerator.generateObject(this.listRS));
        }
        catch (BadDataException badDataException) {
            prereq = (Prereq)((Object)badDataException.getLoadedObject());
        }
        catch (SQLException sQLException) {
            String string = "SQL error while retrieving a Prerequisite for a job or event.";
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        return prereq;
    }

    @Override
    public void close() {
        if (this.listRS != null) {
            try {
                this.listRS.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.listStmt != null) {
            try {
                this.listStmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    PreparedStatement getStmt() {
        return this.listStmt;
    }

    Connection getConnection() {
        return this.con;
    }

    void runQuery(PreparedStatement preparedStatement) throws SQLException {
        if (this.listRS != null) {
            try {
                this.listRS.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.listRS = preparedStatement.executeQuery();
    }

    private Connection extractConnectionFromStmt() throws ResourceUnavailableException {
        try {
            return this.listStmt.getConnection();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            logger.debug((Object)"Cannot retrieve Connection from Statement.", (Throwable)sQLException);
            try {
                this.listStmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException2 = sQLException3;
                logger.debug((Object)"SQL error while trying to close the Statement.", (Throwable)sQLException3);
            }
            throw new ResourceUnavailableException("SQL error while trying to build the list.", (Throwable)sQLException2);
        }
    }
}

