/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.DateObjectDM;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsDM;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class JobDateObjectsDMJdbc
extends AbstractDatabaseManager
implements JobDateObjectsDM {
    private static final Logger logger = Logger.getLogger(JobDateObjectsDMJdbc.class);
    private static final String JOB_TABLE = "job_date_objects";
    private static final String FORECAST_SCHEDULE_TABLE = "forecast_date_objects";
    private String jobTable;
    private String forecastScheduleTable;
    private DateObjectDM dateObjectDM;

    public JobDateObjectsDMJdbc(String string, String string2, String string3, DateObjectDM dateObjectDM) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.jobTable = string2 + "." + JOB_TABLE;
        this.forecastScheduleTable = string2 + "." + FORECAST_SCHEDULE_TABLE;
        this.setName(string3);
        this.dateObjectDM = dateObjectDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateObject get(JobDateObjectsType jobDateObjectsType, long l) throws BadDataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            DateObject dateObject = this.get(jobDateObjectsType, l, (Connection)wrappedConnection);
            return dateObject;
        }
        finally {
            AbstractDatabaseManager.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    @Override
    public DateObject get(JobDateObjectsType jobDateObjectsType, long l, Connection connection) throws BadDataException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Date Object Usage Type", (Object)jobDateObjectsType);
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        String string = "SELECT date_object_id FROM " + this.jobTable + " WHERE job_id=? and date_object_type=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        return this.get(l, jobDateObjectsType, preparedStatement);
    }

    @Override
    public DateObject getDateObjectAssociatedWithForecastSchedule(long l, JobDateObjectsType jobDateObjectsType, Connection connection) throws BadDataException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Date Object Usage Type", (Object)jobDateObjectsType);
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        String string = "SELECT date_object_id FROM " + this.forecastScheduleTable + " WHERE forecast_schedule_id=? and date_object_type=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        return this.get(l, jobDateObjectsType, preparedStatement);
    }

    private DateObject get(long l, JobDateObjectsType jobDateObjectsType, PreparedStatement preparedStatement) throws BadDataException, ResourceUnavailableException {
        Object object;
        DateObject dateObject = null;
        ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, jobDateObjectsType.persistanceCode());
            object = preparedStatement.executeQuery();
            while (object.next()) {
                long l2 = object.getLong("date_object_id");
                try {
                    DateObject dateObject2 = this.dateObjectDM.get(l2);
                    if (dateObject == null) {
                        dateObject = dateObject2;
                        continue;
                    }
                    dateObject.addDates(dateObject2.getDates());
                    dateObject.setName("*MERGED");
                    dateObject.setDescription("Internal Date List");
                }
                catch (NoDataException noDataException) {
                    logger.error((Object)noDataException.getMessage());
                    exceptionErrorList.addException((Exception)((Object)noDataException));
                }
            }
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} type Date Lists for job/event id {1}.", (Object[])new Object[]{jobDateObjectsType, l});
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        if (exceptionErrorList.getErrorCount() > 0) {
            object = MessageUtil.formatMsg((String)"Error constructing the {0} associated with job/event id {1}.", (Object[])new Object[]{jobDateObjectsType, l});
            throw new BadDataException((String)object, (Object)dateObject, (ErrorList)exceptionErrorList);
        }
        return dateObject;
    }

    @Override
    public DateObject[] getList(JobDateObjectsType jobDateObjectsType, long l, Connection connection) throws BadDataException, ResourceUnavailableException {
        Object object;
        ValidationHelper.checkForNull((String)"Date Object Type", (Object)jobDateObjectsType);
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        Object var5_4 = null;
        ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
        String string = "SELECT date_object_id FROM " + this.jobTable + " WHERE job_id=? and date_object_type=?";
        ArrayList<DateObject> arrayList = new ArrayList<DateObject>();
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, jobDateObjectsType.persistanceCode());
            object = preparedStatement.executeQuery();
            while (object.next()) {
                long l2 = object.getLong("date_object_id");
                try {
                    arrayList.add(this.dateObjectDM.get(l2));
                }
                catch (NoDataException noDataException) {
                    logger.error((Object)noDataException.getMessage());
                    exceptionErrorList.addException((Exception)((Object)noDataException));
                }
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} type Date Lists for job id {1}.", (Object[])new Object[]{jobDateObjectsType, l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        if (exceptionErrorList.getErrorCount() > 0) {
            object = MessageUtil.formatMsg((String)"Error constructing the {0} associated with job id {1}.", (Object[])new Object[]{jobDateObjectsType, l});
            throw new BadDataException((String)object, var5_4, (ErrorList)exceptionErrorList);
        }
        return arrayList.toArray(new DateObject[arrayList.size()]);
    }

    @Override
    public DateObject[] getList(JobDateObjectsType jobDateObjectsType, long l) throws BadDataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            DateObject[] dateObjectArray = this.getList(jobDateObjectsType, l, (Connection)wrappedConnection);
            return dateObjectArray;
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} type Date Lists for job id {1}.", (Object[])new Object[]{jobDateObjectsType, l});
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        finally {
            if (wrappedConnection != null) {
                JobDateObjectsDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            }
        }
    }

    @Override
    public List<AbstractMap.SimpleEntry<Long, Long>> getAllOmitTypeDateObjectEntries() throws ResourceUnavailableException {
        ArrayList<AbstractMap.SimpleEntry<Long, Long>> arrayList = new ArrayList<AbstractMap.SimpleEntry<Long, Long>>();
        String string = "SELECT job_id, date_object_id FROM " + this.jobTable + " WHERE date_object_type=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, JobDateObjectsType.OMIT_DATE_OBJECTS.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong("job_id");
                long l2 = resultSet.getLong("date_object_id");
                arrayList.add(new AbstractMap.SimpleEntry<Long, Long>(l, l2));
            }
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while retrieving all the omit-type date lists.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList;
    }
}

