/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.DateObjectDM;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.TimeZone;

public class DateObjectDMJdbc
extends AbstractDatabaseManager
implements DateObjectDM {
    private static final String TABLE = "date_objects";
    private static final String DATES_TABLE = "run_dates";
    private String table;
    private String datesTable;

    public DateObjectDMJdbc(String string, String string2, String string3) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.table = string2 + "." + TABLE;
        this.datesTable = string2 + "." + DATES_TABLE;
        this.setName(string3);
    }

    @Override
    public DateObject get(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT id, name, description, notify_before_expiration FROM " + this.table + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                DateObject dateObject = this.getDataFromRS(resultSet);
                return dateObject;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Date List (id = {0}) not found.", (Object[])new Object[]{l});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the Date List for id {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public DateObject[] getList() throws NoDataException, BadDataException, ResourceUnavailableException {
        DateObject[] dateObjectArray = new DateObject[]{};
        String string = "SELECT id, name, description, notify_before_expiration FROM " + this.table;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        ArrayList<DateObject> arrayList = new ArrayList<DateObject>();
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DateObject dateObject = this.getDataFromRS(resultSet);
                arrayList.add(dateObject);
            }
            dateObjectArray = arrayList.toArray(new DateObject[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("SQL error while retrieving Date Lists.", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return dateObjectArray;
    }

    private DateObject getDataFromRS(ResultSet resultSet) throws SQLException, ResourceUnavailableException {
        DateObject dateObject = new DateObject();
        dateObject.setID(resultSet.getLong("id"));
        dateObject.setName(Convert.trimR((String)resultSet.getString("name")));
        dateObject.setDescription(Convert.trimR((String)resultSet.getString("description")));
        dateObject.setNotifyBeforeExpiration(resultSet.getBoolean("notify_before_expiration"));
        Connection connection = resultSet.getStatement().getConnection();
        int[] nArray = this.loadDates(dateObject.getID(), connection);
        dateObject.setDates(nArray);
        return dateObject;
    }

    private int[] loadDates(long l, Connection connection) throws SQLException, ResourceUnavailableException {
        HashSet<Date> hashSet = new HashSet<Date>();
        String string = "SELECT run_date FROM " + this.datesTable + " WHERE date_object_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear();
        while (resultSet.next()) {
            Date date = resultSet.getDate("run_date", (Calendar)gregorianCalendar);
            hashSet.add(date);
        }
        int[] nArray = new int[hashSet.size()];
        int n = 0;
        for (java.util.Date date : hashSet) {
            gregorianCalendar.setTime(date);
            int n2 = gregorianCalendar.get(1);
            int n3 = gregorianCalendar.get(2) + 1;
            int n4 = gregorianCalendar.get(5);
            nArray[n++] = n2 * 10000 + n3 * 100 + n4;
        }
        return nArray;
    }
}

