/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CronExpressionsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CronExpressionsDMJdbc
extends AbstractDatabaseManager
implements CronExpressionsDM {
    private static final Logger logger = Logger.getLogger(CronExpressionsDMJdbc.class);
    private static final String CRON_EXPRESSION_FIELDS = "minute, hour, day, month, weekday, year ";
    private static final String TABLE = "cron_expressions";
    private String table;

    public CronExpressionsDMJdbc(String string, String string2, String string3) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.table = string2 + "." + TABLE;
        this.setName(string3);
    }

    @Override
    public String getForJob(long l, Connection connection) throws ResourceUnavailableException, NoDataException, BadDataException {
        String string = "SELECT minute, hour, day, month, weekday, year FROM " + this.table + " WHERE job_id=? ";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString("minute");
                string2 = string2 + " " + resultSet.getString("hour");
                string2 = string2 + " " + resultSet.getString("day");
                string2 = string2 + " " + resultSet.getString("month");
                string2 = string2 + " " + resultSet.getString("weekday");
                String string3 = string2 = string2 + " " + resultSet.getString("year");
                return string3;
            }
            try {
                String string4 = MessageUtil.formatMsg((String)"Cron Expression not found for Job ID {0}", (Object[])new Object[]{l});
                throw new NoDataException(string4);
            }
            catch (SQLException sQLException) {
                String string5 = MessageUtil.formatMsg((String)"SQL error retrieving Cron Expression for jobID {0}.", (Object[])new Object[]{l});
                logger.debug((Object)string5, (Throwable)sQLException);
                throw new ResourceUnavailableException(string5, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }
}

