/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.access.sap.SAPSystemDefinitionsDMJdbc;
import com.helpsystems.enterprise.core.busobj.LanguageCode;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemEnvironment;
import com.helpsystems.enterprise.core.dm.LanguageCodesDM;
import com.helpsystems.enterprise.core.dm.sap.SAPSystemEnvironmentsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SAPSystemEnvironmentsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPSystemEnvironmentsDM {
    private static Logger logger = Logger.getLogger(SAPSystemDefinitionsDMJdbc.class);
    private static final String objDesc = "SAP System Environment";
    private static final String SAP_SYSTEM_ENVIRONMENTS_TABLE = "sap_system_environments";
    private String sapSystemEnvironmentsTable;
    private LanguageCodesDM languageCodesDM;

    public SAPSystemEnvironmentsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, LanguageCodesDM languageCodesDM) {
        super(string, string2, sQLManagerHelper);
        this.languageCodesDM = languageCodesDM;
        this.setName("ENTERPRISE.SAPSystemEnvironmentsDM");
        this.sapSystemEnvironmentsTable = string2 + "." + SAP_SYSTEM_ENVIRONMENTS_TABLE;
    }

    @Override
    public SAPSystemEnvironment get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            SAPSystemEnvironment sAPSystemEnvironment;
            String string = "SELECT id, name, description, language_code_id, sap_client_code, sap_username, sap_encrypted_password, sap_password_salt, sap_system_definition_id FROM " + this.sapSystemEnvironmentsTable + " WHERE id=?";
            SAPSystemEnvironmentGenerator sAPSystemEnvironmentGenerator = new SAPSystemEnvironmentGenerator(9);
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            SAPSystemEnvironment sAPSystemEnvironment2 = sAPSystemEnvironment = (SAPSystemEnvironment)sAPSystemEnvironmentGenerator.generateObject(resultSet);
            SAPSystemEnvironmentsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return sAPSystemEnvironment2;
        }
        try {
            try {
                throw new NoDataException("SAP System Environment not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            SAPSystemEnvironmentsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public List<SAPSystemEnvironment> getBySystemDefinition(long l) throws ResourceUnavailableException, NoDataException, BadDataException {
        ArrayList<SAPSystemEnvironment> arrayList = new ArrayList<SAPSystemEnvironment>();
        String string = "SELECT id, name, description, language_code_id, sap_client_code, sap_username, sap_encrypted_password, sap_password_salt, sap_system_definition_id FROM " + this.sapSystemEnvironmentsTable + " WHERE sap_system_definition_id=? ORDER BY name ASC";
        SAPSystemEnvironmentGenerator sAPSystemEnvironmentGenerator = new SAPSystemEnvironmentGenerator(9);
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPSystemEnvironment sAPSystemEnvironment = (SAPSystemEnvironment)sAPSystemEnvironmentGenerator.generateObject(resultSet);
                arrayList.add(sAPSystemEnvironment);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPSystemEnvironmentsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPSystemEnvironmentsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    private class SAPSystemEnvironmentGenerator
    extends AbstractBusObjGenerator {
        public SAPSystemEnvironmentGenerator(int n) {
            super(n, SAPSystemEnvironmentsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPSystemEnvironment();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPSystemEnvironment sAPSystemEnvironment = (SAPSystemEnvironment)object;
            switch (n) {
                case 1: {
                    sAPSystemEnvironment.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    sAPSystemEnvironment.setName(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    sAPSystemEnvironment.setDescription(string);
                    break;
                }
                case 4: {
                    long l = resultSet.getLong("language_code_id");
                    Connection connection = resultSet.getStatement().getConnection();
                    try {
                        LanguageCode languageCode = SAPSystemEnvironmentsDMJdbc.this.languageCodesDM.get(l, connection);
                        sAPSystemEnvironment.setLanguageCode(languageCode.getCode());
                        break;
                    }
                    catch (Exception exception) {
                        String string = "Error while retrieving the Language Code.";
                        logger.error((Object)string, (Throwable)exception);
                        throw new RuntimeException(string, exception);
                    }
                }
                case 5: {
                    int n2 = resultSet.getInt("sap_client_code");
                    String string = String.format("%%0%dd", 3);
                    String string2 = String.format(string, n2);
                    sAPSystemEnvironment.setClientCode(string2);
                    break;
                }
                case 6: {
                    sAPSystemEnvironment.setSapUserName(resultSet.getString("sap_username"));
                    break;
                }
                case 7: {
                    sAPSystemEnvironment.setEncryptedPassword(resultSet.getString("sap_encrypted_password"));
                    break;
                }
                case 8: {
                    String string = resultSet.getString("sap_password_salt");
                    if (string == null) {
                        string = "";
                    }
                    sAPSystemEnvironment.setPasswordSalt(string);
                    break;
                }
                case 9: {
                    sAPSystemEnvironment.setSapSystemDefinitionID(resultSet.getLong("sap_system_definition_id"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

