/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptCriteria;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptCriterion;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptCriterionsDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SAPInterceptCriterionsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPInterceptCriterionsDM {
    private static final String objDesc = "SAP Intercept Criteria";
    private static final String SAP_INTERCEPT_CRITERIONS_TABLE = "sap_intercept_criterions";
    private static final String JOBS_TABLE = "jobs";
    private static final String AGENTS_TABLE = "agents";
    private static final String COMMON_SQL_SELECT = "SELECT t1.job_id, t2.name as job_name, t3.name as agent_name, t2.timezone_type, t2.timezone, t2.target_id, t1.allowed_from, t1.allowed_to, t1.restricted_mon, t1.restricted_tue, t1.restricted_wed, t1.restricted_thu, t1.restricted_fri, t1.restricted_sat, t1.restricted_sun, t1.sap_system_definition_id, t1.sap_owner, t1.sap_job_name, t1.sap_client";
    private String sapInterceptCriterionsTable;
    private String jobsTable;
    private String agentsTable;

    public SAPInterceptCriterionsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPInterceptCriterionsDM");
        this.sapInterceptCriterionsTable = string2 + "." + SAP_INTERCEPT_CRITERIONS_TABLE;
        this.jobsTable = string2 + "." + JOBS_TABLE;
        this.agentsTable = string2 + "." + AGENTS_TABLE;
    }

    @Override
    public SAPInterceptCriterion getForSkybotJobID(long l, String string) throws NoDataException, BadDataException, ResourceUnavailableException {
        SAPInterceptCriterion sAPInterceptCriterion = new SAPInterceptCriterion(string);
        SAPInterceptCriterionGenerator sAPInterceptCriterionGenerator = new SAPInterceptCriterionGenerator(string);
        String string2 = "SELECT t1.job_id, t2.name as job_name, t3.name as agent_name, t2.timezone_type, t2.timezone, t2.target_id, t1.allowed_from, t1.allowed_to, t1.restricted_mon, t1.restricted_tue, t1.restricted_wed, t1.restricted_thu, t1.restricted_fri, t1.restricted_sat, t1.restricted_sun, t1.sap_system_definition_id, t1.sap_owner, t1.sap_job_name, t1.sap_client FROM " + this.sapInterceptCriterionsTable + " t1 JOIN " + this.jobsTable + " t2 ON t1.job_id = t2.id JOIN " + this.agentsTable + " t3 ON t2.target_id = t3.id WHERE t1.job_id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string2, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                sAPInterceptCriterion = (SAPInterceptCriterion)sAPInterceptCriterionGenerator.generateObject(resultSet);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}s for Automate Schedule Job ID {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPInterceptCriterionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPInterceptCriterionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return sAPInterceptCriterion;
    }

    @Override
    public SAPInterceptCriteria getForSAPSystemDefinitionID(long l, String string) throws NoDataException, BadDataException, ResourceUnavailableException {
        SAPInterceptCriteria sAPInterceptCriteria = new SAPInterceptCriteria(string);
        SAPInterceptCriterionGenerator sAPInterceptCriterionGenerator = new SAPInterceptCriterionGenerator(string);
        String string2 = "SELECT t1.job_id, t2.name as job_name, t3.name as agent_name, t2.timezone_type, t2.timezone, t2.target_id, t1.allowed_from, t1.allowed_to, t1.restricted_mon, t1.restricted_tue, t1.restricted_wed, t1.restricted_thu, t1.restricted_fri, t1.restricted_sat, t1.restricted_sun, t1.sap_system_definition_id, t1.sap_owner, t1.sap_job_name, t1.sap_client FROM " + this.sapInterceptCriterionsTable + " t1 JOIN " + this.jobsTable + " t2 ON t1.job_id = t2.id JOIN " + this.agentsTable + " t3 ON t2.target_id = t3.id WHERE t1.sap_system_definition_id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string2, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPInterceptCriterion sAPInterceptCriterion = (SAPInterceptCriterion)sAPInterceptCriterionGenerator.generateObject(resultSet);
                sAPInterceptCriteria.addSAPInterceptCriterion(sAPInterceptCriterion);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}s for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPInterceptCriterionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPInterceptCriterionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return sAPInterceptCriteria;
    }

    private class SAPInterceptCriterionGenerator
    extends AbstractBusObjGenerator {
        private String sapSystemName;

        public SAPInterceptCriterionGenerator(String string) {
            super(19, SAPInterceptCriterionsDMJdbc.objDesc);
            this.sapSystemName = string;
        }

        protected Object constructObject() {
            return new SAPInterceptCriterion(this.sapSystemName);
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPInterceptCriterion sAPInterceptCriterion = (SAPInterceptCriterion)object;
            switch (n) {
                case 1: {
                    sAPInterceptCriterion.setSkybotJobID(resultSet.getLong("job_id"));
                    break;
                }
                case 2: {
                    sAPInterceptCriterion.setSkybotJobName(resultSet.getString("job_name"));
                    break;
                }
                case 3: {
                    sAPInterceptCriterion.setTimeZoneType(ScheduleInfo.TimeZoneType.persistanceCodeToEnum(resultSet.getString("timezone_type")));
                    break;
                }
                case 4: {
                    sAPInterceptCriterion.setSkybotTargetID(resultSet.getLong("target_id"));
                    break;
                }
                case 5: {
                    sAPInterceptCriterion.setSkybotAgentName(resultSet.getString("agent_name"));
                    break;
                }
                case 6: {
                    sAPInterceptCriterion.setSapSystemDefinitionID(resultSet.getLong("sap_system_definition_id"));
                    break;
                }
                case 7: {
                    sAPInterceptCriterion.setJobCreator(resultSet.getString("sap_owner"));
                    break;
                }
                case 8: {
                    sAPInterceptCriterion.setJobName(resultSet.getString("sap_job_name"));
                    break;
                }
                case 9: {
                    sAPInterceptCriterion.setClient(resultSet.getString("sap_client"));
                    break;
                }
                case 10: {
                    sAPInterceptCriterion.setAllowedFromHHMM(resultSet.getInt("allowed_from"));
                    break;
                }
                case 11: {
                    sAPInterceptCriterion.setAllowedToHHMM(resultSet.getInt("allowed_to"));
                    break;
                }
                case 12: {
                    sAPInterceptCriterion.setRestrictedMonday(resultSet.getBoolean("restricted_mon"));
                    break;
                }
                case 13: {
                    sAPInterceptCriterion.setRestrictedTuesday(resultSet.getBoolean("restricted_tue"));
                    break;
                }
                case 14: {
                    sAPInterceptCriterion.setRestrictedWednesday(resultSet.getBoolean("restricted_wed"));
                    break;
                }
                case 15: {
                    sAPInterceptCriterion.setRestrictedThursday(resultSet.getBoolean("restricted_thu"));
                    break;
                }
                case 16: {
                    sAPInterceptCriterion.setRestrictedFriday(resultSet.getBoolean("restricted_fri"));
                    break;
                }
                case 17: {
                    sAPInterceptCriterion.setRestrictedSaturday(resultSet.getBoolean("restricted_sat"));
                    break;
                }
                case 18: {
                    sAPInterceptCriterion.setRestrictedSunday(resultSet.getBoolean("restricted_sun"));
                    break;
                }
                case 19: {
                    sAPInterceptCriterion.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

