/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.rbtschedule;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEventHistory;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventHistoryDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class RemoteEventHistoryDMJdbc
extends AbstractHelpingDatabaseManager
implements RemoteEventHistoryDM {
    private static Logger LOGGER = Logger.getLogger(RemoteEventHistoryDMJdbc.class);
    private static final String OBJ_DESC = "Remote Event History";
    private static final String EVENT_HISTORY_TABLE = "remote_event_histories";
    private String eventHistoryTable;

    public RemoteEventHistoryDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.RemoteEventHistoryDM");
        this.eventHistoryTable = string2 + "." + EVENT_HISTORY_TABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteEventHistory get(long l) throws DataException, ResourceUnavailableException {
        RemoteEventHistory remoteEventHistory = new RemoteEventHistory();
        remoteEventHistory.setId(l);
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            remoteEventHistory = (RemoteEventHistory)((Object)super.get((Connection)wrappedConnection, (Object)remoteEventHistory));
        }
        catch (SQLException sQLException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error obtaining remote event history.", (Throwable)sQLException);
            }
        }
        finally {
            RemoteEventHistoryDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
        return remoteEventHistory;
    }

    @Override
    public long getID(long l, long l2, long l3, Connection connection) throws NoDataException, ResourceUnavailableException {
        Long l4;
        block4: {
            ValidationHelper.checkForNull((String)"Connection", (Object)connection);
            String string = "SELECT id FROM " + this.eventHistoryTable + " WHERE remote_notification_history_id=? AND remote_server_id=? AND remote_system_time=?";
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
            try {
                preparedStatement.setLong(1, l2);
                preparedStatement.setLong(2, l);
                preparedStatement.setLong(3, l3);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    l4 = resultSet.getLong("id");
                    if (resultSet.next()) {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"More than one remote event history row with remote server ID {0} and remote notification history ID {1} and remote system time {2} exists in database table {3}.", (Object[])new Object[]{l, l2, l3, this.eventHistoryTable}));
                    }
                    break block4;
                }
                throw new NoDataException(MessageUtil.formatMsg((String)"There is no remote event history row with remote server ID {0} and remote notification history ID {1} and remote system time {2} in database table {3}.", (Object[])new Object[]{l, l2, l3, this.eventHistoryTable}));
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"SQL error while retrieving the remote event history row with remote server ID {0} and remote notification history ID {1} and remote system time {2} from database table {3}.", (Object[])new Object[]{l, l2, l3, this.eventHistoryTable}), (Throwable)sQLException);
            }
        }
        return l4;
    }

    @Override
    public boolean isInDatabase(long l, long l2, Connection connection) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.eventHistoryTable + " WHERE remote_notification_history_id=? AND remote_server_id=?";
        Object[] objectArray = new Object[]{new Long(l2), new Long(l)};
        try {
            return this.getCount(string, objectArray, connection) > 0;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"Error while checking if an event with remote server ID {0} and remote notification history ID {1} exists in database table {2}.", (Object[])new Object[]{l, l2, this.eventHistoryTable}), (Throwable)exception);
        }
    }

    @Override
    public boolean isInDatabase(long l, long l2, long l3, Connection connection) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.eventHistoryTable + " WHERE remote_notification_history_id=? AND remote_server_id=? AND remote_system_time=?";
        Object[] objectArray = new Object[]{new Long(l2), new Long(l), new Long(l3)};
        try {
            return this.getCount(string, objectArray, connection) > 0;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"Error while checking if an event with remote server ID {0} and remote notification history ID {1} exists in database table {2}.", (Object[])new Object[]{l, l2, this.eventHistoryTable}), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteEventHistory save(RemoteEventHistory remoteEventHistory) throws ResourceUnavailableException, DataException {
        RemoteEventHistory remoteEventHistory2 = null;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            remoteEventHistory2 = (RemoteEventHistory)((Object)super.save((Connection)wrappedConnection, (Object)remoteEventHistory));
        }
        catch (SQLException sQLException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error saving remote event history.", (Throwable)sQLException);
            }
        }
        finally {
            RemoteEventHistoryDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
        return remoteEventHistory2;
    }

    @Override
    public RemoteEventHistory save(RemoteEventHistory remoteEventHistory, Connection connection) throws ResourceUnavailableException, DataException {
        ValidationHelper.checkForNull((String)OBJ_DESC, (Object)((Object)remoteEventHistory));
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        return (RemoteEventHistory)((Object)super.save(connection, (Object)remoteEventHistory));
    }

    @Override
    public void purgeHistory(int n) throws ResourceUnavailableException, SQLException {
        ScheduleLogEntry scheduleLogEntry;
        String[] stringArray;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        String string = null;
        int n2 = 0;
        String string2 = RosettaMsg.PURGE_REMOTE_EVENT_HISTORY_NAME.newLogEntry().getMessageText();
        try {
            wrappedConnection = this.getConnection();
            stringArray = new String[]{string2, String.valueOf(n)};
            scheduleLogEntry = RosettaMsg.PURGE_OLDER_THAN.newLogEntry(stringArray);
            LOGGER.debug((Object)scheduleLogEntry.getMessageText());
            ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry);
            long l = DateTranslator.getDaysOldAsMilliseconds((long)n);
            Date date = new Date(l);
            PreparedStatement preparedStatement = null;
            String string3 = "DELETE FROM remote_event_histories WHERE server_time_utc < ?";
            preparedStatement = this.getDefaultPreparedStmt(string3, (Connection)wrappedConnection);
            preparedStatement.setLong(1, date.getTime());
            n2 = preparedStatement.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Purged " + n2 + " " + string2 + " entries."));
            }
        }
        catch (SQLException sQLException) {
            String string4 = "Error while purging the " + string2 + " data.";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)string4, (Throwable)sQLException);
                LOGGER.debug((Object)("SQL query: " + string));
            }
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            wrappedConnection.close();
        }
        if (n2 > 0) {
            stringArray = new String[]{String.valueOf(n2), string2};
            scheduleLogEntry = RosettaMsg.HISTORY_PURGE_COMPLETE.newLogEntry(stringArray);
            ScheduleLogger.write(scheduleLogEntry);
            LOGGER.debug((Object)scheduleLogEntry.getMessageText());
        }
    }

    private int getCount(String string, Object[] objectArray, Connection connection) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"SQL", (Object)string);
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getInt(1);
            }
            return 0;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Unable to execute a row-count.", (Throwable)sQLException);
        }
    }
}

