/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.rbtschedule;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEvent;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteEventDMJdbc
extends AbstractHelpingDatabaseManager
implements RemoteEventDM {
    private static Logger LOGGER = Logger.getLogger(RemoteEventDMJdbc.class);
    private static final String OBJ_DESC = "Remote Event";
    private static final String REMOTE_EVENT_TABLE = "remote_events";
    private String remoteEventTable;
    String remoteEventFields = "id, remote_event_type, remote_server_id, remote_object_id, remote_object_name, job_suite_id, job_suite_name";

    public RemoteEventDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.RemoteEventDM");
        this.remoteEventTable = string2 + "." + REMOTE_EVENT_TABLE;
    }

    @Override
    public RemoteEvent get(long l) throws DataException, ResourceUnavailableException {
        RemoteEvent remoteEvent = new RemoteEvent();
        remoteEvent.setId(l);
        remoteEvent = (RemoteEvent)((Object)super.get(null, (Object)remoteEvent));
        if (remoteEvent == null) {
            throw new NoDataException("The Remote Event for id " + l + " was not found.");
        }
        return remoteEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteEvent save(RemoteEvent remoteEvent) throws ResourceUnavailableException, DataException {
        RemoteEvent remoteEvent2 = null;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            remoteEvent2 = (RemoteEvent)((Object)super.save((Connection)wrappedConnection, (Object)remoteEvent));
        }
        catch (SQLException sQLException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Error saving remote event with ID: " + remoteEvent.getId()), (Throwable)sQLException);
            }
        }
        finally {
            RemoteEventDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
        return remoteEvent2;
    }

    @Override
    public int delete(long l) throws ResourceUnavailableException, DataException {
        RemoteEvent remoteEvent = new RemoteEvent();
        remoteEvent.setId(l);
        return super.delete((Object)remoteEvent);
    }

    @Override
    public RemoteEvent get(long l, long l2, RemoteEventType remoteEventType) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            RemoteEvent remoteEvent;
            String string = "SELECT " + this.remoteEventFields + " FROM " + this.remoteEventTable + " WHERE remote_server_id=?" + " AND remote_object_id=? AND remote_event_type=?";
            RemoteEventGenerator remoteEventGenerator = new RemoteEventGenerator(7);
            preparedStatement = null;
            resultSet = null;
            wrappedConnection = null;
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setInt(3, remoteEventType.persistanceCode());
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            RemoteEvent remoteEvent2 = remoteEvent = (RemoteEvent)((Object)remoteEventGenerator.generateObject(resultSet));
            RemoteEventDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return remoteEvent2;
        }
        try {
            try {
                throw new NoDataException("Remote Event was not found for Remote Server ID " + l + " Remote Object ID " + l2 + " Remote Object Type " + remoteEventType + ".");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}", (Object[])new Object[]{OBJ_DESC});
                LOGGER.error((Object)string, (Throwable)sQLException);
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            RemoteEventDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<RemoteEvent> getAll(long var1_1) throws DataException, ResourceUnavailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void updateObjectName(long l, String string) throws ResourceUnavailableException {
        String string2 = "UPDATE " + this.remoteEventTable + " SET remote_object_name=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Trying to update the remote object name for the remote event with ID {0} in the database, but no records were updated.", (Object[])new Object[]{l}));
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while trying to update the remote object name for the remote event with ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateSuiteName(long l, String string) throws ResourceUnavailableException {
        String string2 = "UPDATE " + this.remoteEventTable + " SET job_suite_name=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Trying to update the job suite name for the remote event with ID {0} in the database, but no records were updated.", (Object[])new Object[]{l}));
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while trying to update the job suite name for the remote event with ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private class RemoteEventGenerator
    extends AbstractBusObjGenerator {
        public RemoteEventGenerator(int n) {
            super(n, RemoteEventDMJdbc.OBJ_DESC);
        }

        protected Object constructObject() {
            return new RemoteEvent();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            RemoteEvent remoteEvent = (RemoteEvent)((Object)object);
            switch (n) {
                case 1: {
                    remoteEvent.setId(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    remoteEvent.setEventType(RemoteEventType.persistanceCodeToEnum(resultSet.getInt("remote_event_type")));
                    break;
                }
                case 3: {
                    remoteEvent.setRemoteServerID(resultSet.getLong("remote_server_id"));
                    break;
                }
                case 4: {
                    remoteEvent.setRemoteObjectID(resultSet.getLong("remote_object_id"));
                    break;
                }
                case 5: {
                    remoteEvent.setRemoteObjectName(resultSet.getString("remote_object_name"));
                    break;
                }
                case 6: {
                    remoteEvent.setJobSuiteID(resultSet.getLong("job_suite_id"));
                    break;
                }
                case 7: {
                    remoteEvent.setJobSuiteName(Convert.trimR((String)resultSet.getString("job_suite_name")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

