/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.access.jdbc.AgentDMJdbc;
import com.helpsystems.enterprise.access.jdbc.AgentEventMonitorDMJdbc;
import com.helpsystems.enterprise.access.jdbc.AgentGroupDMJdbc;
import com.helpsystems.enterprise.access.jdbc.AgentReturnCodeDMJdbc;
import com.helpsystems.enterprise.access.jdbc.CalendarObjectDMJdbc;
import com.helpsystems.enterprise.access.jdbc.CommandSetDMJdbc;
import com.helpsystems.enterprise.access.jdbc.EnterpriseSNMPTrapManagerDMJdbc;
import com.helpsystems.enterprise.access.jdbc.EventHistoryXRefDMJdbc;
import com.helpsystems.enterprise.access.jdbc.JobMonitorDMJdbc;
import com.helpsystems.enterprise.access.jdbc.JobMonitorEventsDMJdbc;
import com.helpsystems.enterprise.access.jdbc.ReactivityDateObjectDMJdbc;
import com.helpsystems.enterprise.access.jdbc.ReactivityDayOfPeriodDMJdbc;
import com.helpsystems.enterprise.access.jdbc.ReactivityDaysDMJdbc;
import com.helpsystems.enterprise.access.jdbc.ScheduleJobDMJdbc;
import com.helpsystems.enterprise.access.jdbc.SystemSetupDMJdbc;
import com.helpsystems.enterprise.access.jdbc.UnitTestJdbcPool;
import com.helpsystems.enterprise.access.logger.ScheduleLogDMImpl;
import com.helpsystems.enterprise.access.scheduler.CronExpressionsDMJdbc;
import com.helpsystems.enterprise.access.scheduler.DateObjectDMJdbc;
import com.helpsystems.enterprise.access.scheduler.JobDateObjectsDMJdbc;
import com.helpsystems.enterprise.access.scheduler.JobSuiteDMJdbc;
import com.helpsystems.enterprise.access.scheduler.PrereqDMJdbc;
import com.helpsystems.enterprise.access.scheduler.PrerequisitesDMJdbc;
import com.helpsystems.enterprise.access.scheduler.RuntimeRangesDMJdbc;
import com.helpsystems.enterprise.access.scheduler.RuntimesDMJdbc;
import com.helpsystems.enterprise.access.scheduler.ScheduleInfoDMJdbc;
import com.helpsystems.enterprise.access.scheduler.ScheduledTimeDMJdbc;
import java.io.IOException;

public class UnitTestManagerLoader {
    private String library;
    private String poolUrl;

    public UnitTestManagerLoader(String string) {
        this.library = string;
    }

    public void loadManagers() throws ResourceUnavailableException {
        SQLManagerHelper sQLManagerHelper;
        this.poolUrl = UnitTestJdbcPool.getJdbcPool();
        try {
            sQLManagerHelper = new SQLManagerHelper("com/helpsystems/enterprise/access/dbmap.xml", true, this.getClass().getClassLoader());
        }
        catch (IOException iOException) {
            throw new ResourceUnavailableException("Error loading SQL Helper.", (Throwable)iOException);
        }
        AgentDMJdbc agentDMJdbc = new AgentDMJdbc(this.poolUrl, this.library, sQLManagerHelper);
        this.registerManager((AbstractManager)agentDMJdbc);
        CalendarObjectDMJdbc calendarObjectDMJdbc = new CalendarObjectDMJdbc(this.poolUrl, this.library, "ENTERPRISE.CalendarObjectDM");
        this.registerManager((AbstractManager)calendarObjectDMJdbc);
        DateObjectDMJdbc dateObjectDMJdbc = new DateObjectDMJdbc(this.poolUrl, this.library, "ENTERPRISE.DateObjectDM");
        JobDateObjectsDMJdbc jobDateObjectsDMJdbc = new JobDateObjectsDMJdbc(this.poolUrl, this.library, "ENTERPRISE.JobDateObjectsDM", dateObjectDMJdbc);
        EventHistoryXRefDMJdbc eventHistoryXRefDMJdbc = new EventHistoryXRefDMJdbc(this.poolUrl, this.library, sQLManagerHelper, "ENTERPRISE.EventHistoryXRefDM");
        AgentReturnCodeDMJdbc agentReturnCodeDMJdbc = new AgentReturnCodeDMJdbc(this.poolUrl, this.library);
        this.registerManager((AbstractManager)agentReturnCodeDMJdbc);
        CommandSetDMJdbc commandSetDMJdbc = new CommandSetDMJdbc(this.poolUrl, this.library, agentReturnCodeDMJdbc);
        this.registerManager((AbstractManager)commandSetDMJdbc);
        ScheduleJobDMJdbc scheduleJobDMJdbc = new ScheduleJobDMJdbc(this.poolUrl, this.library, commandSetDMJdbc);
        this.registerManager((AbstractManager)scheduleJobDMJdbc);
        AgentGroupDMJdbc agentGroupDMJdbc = new AgentGroupDMJdbc(this.poolUrl, this.library, sQLManagerHelper);
        this.registerManager((AbstractManager)agentGroupDMJdbc);
        AgentEventMonitorDMJdbc agentEventMonitorDMJdbc = new AgentEventMonitorDMJdbc(this.poolUrl, this.library, sQLManagerHelper);
        this.registerManager((AbstractManager)agentEventMonitorDMJdbc);
        JobSuiteDMJdbc jobSuiteDMJdbc = new JobSuiteDMJdbc(this.poolUrl, this.library, "ENTERPRISE.JobSuiteDM", scheduleJobDMJdbc, sQLManagerHelper);
        this.registerManager((AbstractManager)jobSuiteDMJdbc);
        PrereqDMJdbc prereqDMJdbc = new PrereqDMJdbc(this.poolUrl, this.library, "ENTERPRISE.PrereqDM", eventHistoryXRefDMJdbc, scheduleJobDMJdbc, agentGroupDMJdbc, agentEventMonitorDMJdbc, jobSuiteDMJdbc);
        this.registerManager((AbstractManager)prereqDMJdbc);
        this.registerManager((AbstractManager)new PrerequisitesDMJdbc(this.poolUrl, this.library, "ENTERPRISE.PrerequisitesDM", prereqDMJdbc, scheduleJobDMJdbc, agentGroupDMJdbc));
        this.registerManager((AbstractManager)new ReactivityDaysDMJdbc(this.poolUrl, this.library));
        this.registerManager((AbstractManager)new ReactivityDateObjectDMJdbc(this.poolUrl, this.library, dateObjectDMJdbc));
        this.registerManager((AbstractManager)new ReactivityDayOfPeriodDMJdbc(this.poolUrl, this.library));
        RuntimesDMJdbc runtimesDMJdbc = new RuntimesDMJdbc(this.poolUrl, this.library, "ENTERPRISE.RuntimesDM");
        RuntimeRangesDMJdbc runtimeRangesDMJdbc = new RuntimeRangesDMJdbc(this.poolUrl, this.library, "ENTERPRISE.RuntimeRangesDM");
        CronExpressionsDMJdbc cronExpressionsDMJdbc = new CronExpressionsDMJdbc(this.poolUrl, this.library, "ENTERPRISE.CronExpressionsDM");
        ScheduleInfoDMJdbc scheduleInfoDMJdbc = new ScheduleInfoDMJdbc(this.poolUrl, this.library, "ENTERPRISE.ScheduleInfoDM", runtimesDMJdbc, runtimeRangesDMJdbc, calendarObjectDMJdbc, jobDateObjectsDMJdbc, cronExpressionsDMJdbc, agentGroupDMJdbc);
        this.registerManager((AbstractManager)scheduleInfoDMJdbc);
        this.registerManager((AbstractManager)new ScheduleJobDMJdbc(this.poolUrl, this.library, null));
        this.registerManager((AbstractManager)new ScheduleLogDMImpl(this.poolUrl, "ENTERPRISE.ScheduleLogDM", sQLManagerHelper, this.library));
        this.registerManager((AbstractManager)new ScheduledTimeDMJdbc(this.poolUrl, this.library, "ENTERPRISE.ScheduledTimeDM", scheduleJobDMJdbc, agentDMJdbc));
        this.registerManager((AbstractManager)new JobMonitorDMJdbc(this.poolUrl, this.library, sQLManagerHelper));
        this.registerManager((AbstractManager)new JobMonitorEventsDMJdbc(this.poolUrl, this.library, sQLManagerHelper));
        this.registerManager((AbstractManager)new EnterpriseSNMPTrapManagerDMJdbc(this.poolUrl, this.library, sQLManagerHelper));
        this.registerManager((AbstractManager)new SystemSetupDMJdbc(this.poolUrl, this.library, sQLManagerHelper));
    }

    private void registerManager(AbstractManager abstractManager) {
        ManagerRegistry.registerManager((IAbstractManager)abstractManager);
    }
}

