/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import java.util.HashMap;

public class SystemSetupDMJdbc
extends AbstractHelpingDatabaseManager
implements SystemSetupDM {
    public SystemSetupDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SystemSetupDM");
    }

    @Override
    public SystemSetup get() throws DataException, ResourceUnavailableException {
        SystemSetup systemSetup = new SystemSetup();
        HashMap hashMap = new HashMap();
        Object[] objectArray = this.search(systemSetup, hashMap);
        if (objectArray.length > 0) {
            systemSetup = (SystemSetup)objectArray[0];
            if (systemSetup.getEncryptedEmailServerLoginPassword() != null && systemSetup.getEncryptedEmailServerLoginPassword().length() > 0) {
                systemSetup.setEmailServerLoginPassword(this.decryptPassword(systemSetup.getEncryptedEmailServerLoginPassword()));
            }
            return systemSetup;
        }
        throw new NoDataException("No System Setup present");
    }

    private String decryptPassword(String string) throws BadDataException, ResourceUnavailableException {
        String string2 = null;
        if (string != null && string.length() > 0) {
            try {
                string2 = UnacodeMash.unMash(string);
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Unable to decode password.", (Throwable)exception);
            }
        }
        return string2;
    }

    @Override
    public void save(SystemSetup systemSetup) throws ResourceUnavailableException, DataException {
        super.save((Object)systemSetup);
    }
}

