/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.DayOfWeekTimestampFilter;
import com.helpsystems.enterprise.core.busobj.ParentType;
import com.helpsystems.enterprise.core.busobj.SpecialInstance;
import com.helpsystems.enterprise.core.busobj.SpecialInstanceDays;
import com.helpsystems.enterprise.core.busobj.SpecialInstanceType;
import com.helpsystems.enterprise.core.busobj.TimeHelper;
import com.helpsystems.enterprise.core.dm.SpecialInstanceDM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class SpecialInstanceDMJdbc
extends AbstractDatabaseManager
implements SpecialInstanceDM {
    private static final String si_Desc = "Special Instance";
    private static final String sid_Desc = "Special Instance Days";
    private String si_table;
    private String sid_table;
    BusinessObjectGenerator si_Generator = new SpecialInstanceGenerator();
    BusinessObjectGenerator sid_Generator = new SpecialInstanceDaysGenerator();

    public SpecialInstanceDMJdbc(String string, String string2) throws ResourceUnavailableException {
        super(string);
        this.si_table = string2 + "." + "SPECIAL_INSTANCES";
        this.sid_table = string2 + "." + "SPECIAL_INSTANCE_DAYS";
        this.setName("ENTERPRISE.SpecialInstanceDM");
    }

    private String get_si_Sql() {
        return "SELECT id, parent_id, parent_type, name, description, instance_type, date_object_id, scheduled_after, scheduled_before, day_type FROM " + this.si_table;
    }

    private String get_sid_Sql() {
        return "SELECT id, special_instance_id, runcode_mon, runcode_tue, runcode_wed, runcode_thu, runcode_fri, runcode_sat, runcode_sun, scheduled_after, scheduled_before,day_number,period_type  FROM " + this.sid_table;
    }

    @Override
    public SpecialInstance get(long l) throws ResourceUnavailableException, DataException {
        String string = this.get_si_Sql() + " where id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                SpecialInstance specialInstance = (SpecialInstance)this.si_Generator.generateObject(resultSet);
                SpecialInstanceType specialInstanceType = specialInstance.getType();
                if (specialInstanceType == SpecialInstanceType.DAY_OF_WEEK || specialInstanceType == SpecialInstanceType.DAY_OF_PERIOD) {
                    this.loadSpecialInstanceDays(specialInstance, preparedStatement.getConnection());
                }
                SpecialInstance specialInstance2 = specialInstance;
                return specialInstance2;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"{0} not found for id {1}.", (Object[])new Object[]{si_Desc, Long.toString(l)});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{si_Desc, Long.toString(l)});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private void loadSpecialInstanceDays(SpecialInstance specialInstance, Connection connection) throws ResourceUnavailableException, DataException {
        String string = this.get_sid_Sql() + " where special_instance_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        ResultSet resultSet = null;
        ArrayList<SpecialInstanceDays[]> arrayList = new ArrayList<SpecialInstanceDays[]>();
        try {
            SpecialInstanceDays[] specialInstanceDaysArray;
            preparedStatement.setLong(1, specialInstance.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                specialInstanceDaysArray = (SpecialInstanceDays)this.sid_Generator.generateObject(resultSet);
                arrayList.add(specialInstanceDaysArray);
            }
            specialInstanceDaysArray = new SpecialInstanceDays[]{};
            specialInstanceDaysArray = arrayList.toArray(specialInstanceDaysArray);
            specialInstance.setSpecialInstanceDays(specialInstanceDaysArray);
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{sid_Desc, Long.toString(specialInstance.getId())});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SpecialInstanceDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SpecialInstanceDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    @Override
    public SpecialInstance[] getByJobID(long l) throws ResourceUnavailableException, DataException {
        String string = this.get_si_Sql() + " where parent_id=? AND (parent_type = 'Job' OR parent_type = 'JobSuite') ORDER BY name";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        ArrayList<SpecialInstance> arrayList = new ArrayList<SpecialInstance>();
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SpecialInstance specialInstance = (SpecialInstance)this.si_Generator.generateObject(resultSet);
                SpecialInstanceType specialInstanceType = specialInstance.getType();
                if (specialInstanceType == SpecialInstanceType.DAY_OF_WEEK || specialInstanceType == SpecialInstanceType.DAY_OF_PERIOD) {
                    this.loadSpecialInstanceDays(specialInstance, preparedStatement.getConnection());
                }
                arrayList.add(specialInstance);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for parent id {1}.", (Object[])new Object[]{si_Desc, Long.toString(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new SpecialInstance[arrayList.size()]);
    }

    private class SpecialInstanceDaysGenerator
    extends AbstractBusObjGenerator {
        public SpecialInstanceDaysGenerator() {
            super(13, SpecialInstanceDMJdbc.sid_Desc);
        }

        protected Object constructObject() {
            return new SpecialInstanceDays();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SpecialInstanceDays specialInstanceDays = (SpecialInstanceDays)object;
            switch (n) {
                case 1: {
                    specialInstanceDays.setId(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    specialInstanceDays.setSpecialInstanceID(resultSet.getLong("special_instance_id"));
                    break;
                }
                case 3: {
                    specialInstanceDays.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_mon")));
                    break;
                }
                case 4: {
                    specialInstanceDays.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_tue")));
                    break;
                }
                case 5: {
                    specialInstanceDays.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_wed")));
                    break;
                }
                case 6: {
                    specialInstanceDays.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_thu")));
                    break;
                }
                case 7: {
                    specialInstanceDays.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_fri")));
                    break;
                }
                case 8: {
                    specialInstanceDays.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_sat")));
                    break;
                }
                case 9: {
                    specialInstanceDays.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_sun")));
                    break;
                }
                case 10: {
                    specialInstanceDays.setStartTime(resultSet.getInt("scheduled_after"));
                    break;
                }
                case 11: {
                    specialInstanceDays.setEndTime(resultSet.getInt("scheduled_before"));
                    if (!resultSet.wasNull()) break;
                    specialInstanceDays.setEndTime(TimeHelper.END_OF_DAY_TIME);
                    break;
                }
                case 12: {
                    specialInstanceDays.setDayNumber(resultSet.getInt("day_number"));
                    break;
                }
                case 13: {
                    String string = resultSet.getString("period_type");
                    if (string == null || string.length() <= 0) break;
                    specialInstanceDays.setPeriodType(CalendarObject.PeriodType.persistanceCodeToEnum(resultSet.getString("period_type")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class SpecialInstanceGenerator
    extends AbstractBusObjGenerator {
        public SpecialInstanceGenerator() {
            super(10, SpecialInstanceDMJdbc.si_Desc);
        }

        protected Object constructObject() {
            return new SpecialInstance();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SpecialInstance specialInstance = (SpecialInstance)object;
            switch (n) {
                case 1: {
                    specialInstance.setId(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    specialInstance.setParentID(resultSet.getLong("parent_id"));
                    break;
                }
                case 3: {
                    specialInstance.setParentType(ParentType.persistanceCodeToEnum(resultSet.getString("parent_type")));
                    break;
                }
                case 4: {
                    specialInstance.setName(resultSet.getString("name").trim());
                    break;
                }
                case 5: {
                    int n2 = resultSet.getInt("instance_type");
                    specialInstance.setType(SpecialInstanceType.persistanceCodeToEnum(n2));
                    break;
                }
                case 6: {
                    specialInstance.setDescription(resultSet.getString("description").trim());
                    break;
                }
                case 7: {
                    specialInstance.setDateObjectID(resultSet.getLong("date_object_id"));
                    break;
                }
                case 8: {
                    specialInstance.setStartTime(resultSet.getInt("scheduled_after"));
                    break;
                }
                case 9: {
                    specialInstance.setEndTime(resultSet.getInt("scheduled_before"));
                    if (!resultSet.wasNull()) break;
                    specialInstance.setEndTime(TimeHelper.END_OF_DAY_TIME);
                    break;
                }
                case 10: {
                    specialInstance.setDayType(CalendarObject.DayType.persistanceCodeToEnum(resultSet.getString("day_type").trim()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

