/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.SNMPTrapEvent;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.dm.SNMPTrapEventDM;
import com.helpsystems.enterprise.core.dm.SNMPTrapMonitorDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class SNMPTrapEventDMJdbc
extends AbstractHelpingDatabaseManager
implements SNMPTrapEventDM {
    private static final Logger logger = Logger.getLogger(SNMPTrapEventDMJdbc.class);
    private ReactivityAM reactivityAM;
    private SNMPTrapMonitorDM snmpTrapMonitorDM;

    public SNMPTrapEventDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, SNMPTrapMonitorDM sNMPTrapMonitorDM) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SNMPTrapEventDM");
        this.snmpTrapMonitorDM = sNMPTrapMonitorDM;
    }

    public void setReactivityAM(ReactivityAM reactivityAM) {
        ValidationHelper.checkForNull((String)"ReactivityAM", (Object)reactivityAM);
        this.reactivityAM = reactivityAM;
    }

    @Override
    public SNMPTrapEvent get(long l) throws ResourceUnavailableException, DataException {
        return this.get(l, null);
    }

    @Override
    public SNMPTrapEvent get(long l, Connection connection) throws DataException, ResourceUnavailableException {
        SNMPTrapEvent sNMPTrapEvent = new SNMPTrapEvent();
        sNMPTrapEvent.setID(l);
        sNMPTrapEvent = (SNMPTrapEvent)((Object)super.get(connection, (Object)sNMPTrapEvent));
        if (sNMPTrapEvent == null) {
            throw new NoDataException("The SNMP Trap Event for id " + l + " was not found.");
        }
        return sNMPTrapEvent;
    }

    @Override
    public SNMPTrapEvent save(SNMPTrapEvent sNMPTrapEvent, Connection connection) throws ResourceUnavailableException, DataException {
        SNMPTrapEvent sNMPTrapEvent2 = (SNMPTrapEvent)((Object)super.save(connection, (Object)sNMPTrapEvent));
        if (sNMPTrapEvent2.getEventErrorcode() == 0) {
            this.reactivityAM.notifySNMPTrapEvent(sNMPTrapEvent2);
        }
        return sNMPTrapEvent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int purgeHistory(int n) throws DataException, ResourceUnavailableException, SQLException {
        Object object;
        Object[] objectArray;
        String string;
        int n2;
        block22: {
            n2 = 0;
            long l = DateTranslator.getDaysOldAsMilliseconds((long)n);
            AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnection();
            String string2 = "DELETE FROM " + super.qualifyLibrary() + "SNMP_TRAP_EVENTS" + " WHERE SERVER_EVENT_TIMESTAMP_UTC < ? AND TRAP_MONITOR_ID=?";
            PreparedStatement preparedStatement = wrappedConnection.prepareStatement(string2);
            string = RosettaMsg.PURGE_SNMP_EVENTS_NAME.newLogEntry().getMessageText();
            String[] stringArray = new String[]{string};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.HISTORY_PURGE.newLogEntry(stringArray);
            logger.debug((Object)scheduleLogEntry.getMessageText());
            ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry);
            try {
                objectArray = null;
                try {
                    objectArray = this.snmpTrapMonitorDM.getProxyList();
                }
                catch (DataException dataException) {
                    logger.debug((Object)"Error retrieving list of SNMP Trap Monitors", (Throwable)dataException);
                }
                if (objectArray != null && objectArray.length > 0) {
                    try {
                        for (int i = 0; i < objectArray.length; ++i) {
                            int n3 = 0;
                            long l2 = 0L;
                            try {
                                if (objectArray[i].isUseDefaultsForHistoryPurge()) {
                                    l2 = l;
                                    if (logger.isTraceEnabled()) {
                                        logger.trace((Object)("Purging SNMP Trap History older than " + n + " days for SNMP Trap Monitor " + objectArray[i].getName()));
                                    }
                                } else {
                                    l2 = DateTranslator.getDaysOldAsMilliseconds((long)objectArray[i].getDaysToRetainHistory());
                                    if (logger.isTraceEnabled()) {
                                        logger.trace((Object)("Purging SNMP Trap History older than " + objectArray[i].getDaysToRetainHistory() + " days for SNMP Trap Monitor " + objectArray[i].getName()));
                                    }
                                }
                                Date date = new Date(l2);
                                Timestamp timestamp = new Timestamp(date.getTime());
                                preparedStatement.setLong(1, timestamp.getTime());
                                preparedStatement.setLong(2, objectArray[i].getID());
                                n3 = preparedStatement.executeUpdate();
                            }
                            catch (Exception exception) {
                                logger.debug((Object)("Error purging SNMP Trap Event History for SNMP Trap Monitor " + objectArray[i].getName()), (Throwable)exception);
                            }
                            n2 += n3;
                        }
                    }
                    catch (Exception exception) {
                        logger.debug((Object)"Error purging SNMP Trap Event Histories", (Throwable)exception);
                    }
                }
                try {
                    object = this.getOrphanedHistoryMonitorIDs();
                    if (object == null || ((Long[])object).length <= 0) break block22;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Purging orphaned SNMP Trap Event History older than " + n + " days."));
                    }
                    Date date = new Date(l);
                    Timestamp timestamp = new Timestamp(date.getTime());
                    for (int i = 0; i < ((Long[])object).length; ++i) {
                        int n4 = 0;
                        try {
                            preparedStatement.setLong(1, timestamp.getTime());
                            preparedStatement.setLong(2, (Long)object[i]);
                            n4 = preparedStatement.executeUpdate();
                        }
                        catch (Exception exception) {
                            logger.debug((Object)("Error purging SNMP Trap Event History for SNMP Trap Monitor " + object[i]), (Throwable)exception);
                        }
                        n2 += n4;
                    }
                }
                catch (Exception exception) {
                    logger.debug((Object)"Error purging orphaned Agent Event Histories", (Throwable)exception);
                }
            }
            finally {
                SNMPTrapEventDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
            }
        }
        if (n2 > 0) {
            objectArray = new String[]{String.valueOf(n2), string};
            object = RosettaMsg.HISTORY_PURGE_COMPLETE.newLogEntry((String[])objectArray);
            ScheduleLogger.write((ScheduleLogEntry)object);
            logger.debug((Object)((ScheduleLogEntry)object).getMessageText());
        }
        return n2;
    }

    private Long[] getOrphanedHistoryMonitorIDs() throws ResourceUnavailableException {
        Long[] longArray = new Long[]{};
        String string = "SELECT DISTINCT trap_monitor_id FROM snmp_trap_events LEFT JOIN snmp_trap_monitors ON trap_monitor_id = snmp_trap_monitors.id WHERE snmp_trap_monitors.id IS NULL";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("trap_monitor_id"));
            }
            longArray = arrayList.toArray(new Long[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("SQL error while retrieving orphaned SNMP Trap Event Monitor IDs.", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return longArray;
    }
}

