/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.SimpleList;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ResultSetSimpleList<T>
implements SimpleList<T> {
    private ResultSet rs;
    private BusinessObjectGenerator generator;
    boolean isSharedConnection;

    public ResultSetSimpleList(ResultSet resultSet, BusinessObjectGenerator businessObjectGenerator) {
        this(resultSet, businessObjectGenerator, false);
    }

    public ResultSetSimpleList(ResultSet resultSet, BusinessObjectGenerator businessObjectGenerator, boolean bl) {
        ValidationHelper.checkForNull((String)"Result Set", (Object)resultSet);
        ValidationHelper.checkForNull((String)"Business Object Generator", (Object)businessObjectGenerator);
        this.rs = resultSet;
        this.generator = businessObjectGenerator;
        this.isSharedConnection = bl;
    }

    @Override
    public boolean next() throws ResourceUnavailableException {
        if (this.isClosed()) {
            throw new IllegalStateException("The list is closed.");
        }
        try {
            return this.rs.next();
        }
        catch (SQLException sQLException) {
            String string = "SQL error while positioning to the next item in the list.";
            this.close();
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    @Override
    public T get() throws ResourceUnavailableException, BadDataException {
        if (this.isClosed()) {
            throw new IllegalStateException("The list is closed.");
        }
        try {
            return (T)this.generator.generateObject(this.rs);
        }
        catch (BadDataException badDataException) {
            throw badDataException;
        }
        catch (SQLException sQLException) {
            this.close();
            throw new ResourceUnavailableException("Error getting object.", (Throwable)sQLException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            this.close();
            throw resourceUnavailableException;
        }
    }

    @Override
    public void close() {
        if (this.rs != null) {
            try {
                Statement statement = this.rs.getStatement();
                if (this.isSharedConnection) {
                    AbstractDatabaseManager.closeEm(null, (Statement)statement, (ResultSet)this.rs);
                } else {
                    Connection connection = statement.getConnection();
                    AbstractDatabaseManager.closeEm((Connection)connection, (Statement)statement, (ResultSet)this.rs);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.rs = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.rs == null;
    }
}

