/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.OutputDistributionHistory;
import com.helpsystems.enterprise.core.dm.OutputDistributionHistoryDM;
import com.helpsystems.enterprise.core.util.SQLUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class OutputDistributionHistoryDMJdbc
extends AbstractHelpingDatabaseManager
implements OutputDistributionHistoryDM {
    private static final Logger logger = Logger.getLogger(OutputDistributionHistoryDMJdbc.class);
    private static final String TABLE_NAME = "output_distribution_histories";
    private static final String objDesc = "OutputDistributionHistory";
    private static final int PURGE_IN_ONE_CYCLE = 1000;

    public OutputDistributionHistoryDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.OutputDistributionHistoryDM");
    }

    @Override
    public OutputDistributionHistory get(long l) throws DataException, ResourceUnavailableException {
        return this.get(l, null);
    }

    @Override
    public OutputDistributionHistory get(long l, Connection connection) throws ResourceUnavailableException, DataException {
        OutputDistributionHistory outputDistributionHistory = new OutputDistributionHistory();
        outputDistributionHistory.setOid(l);
        outputDistributionHistory = connection == null ? (OutputDistributionHistory)((Object)super.get((Object)outputDistributionHistory)) : (OutputDistributionHistory)((Object)super.get(connection, (Object)outputDistributionHistory));
        if (outputDistributionHistory == null) {
            throw new NoDataException("The requested OutputDistributionHistory was not found.");
        }
        return outputDistributionHistory;
    }

    @Override
    public OutputDistributionHistory[] getByStatus(int n) throws DataException, ResourceUnavailableException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("getStatus", n);
        return (OutputDistributionHistory[])super.search((Object)new OutputDistributionHistory(), hashMap);
    }

    @Override
    public OutputDistributionHistory[] getByDistributionType(int n) throws DataException, ResourceUnavailableException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("getDistributionType", n);
        return (OutputDistributionHistory[])super.search((Object)new OutputDistributionHistory(), hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputDistributionHistory[] getByKeepUntil(long l) throws DataException, ResourceUnavailableException {
        OutputDistributionHistory[] outputDistributionHistoryArray = new OutputDistributionHistory[]{};
        OutputDistributionHistoryGenerator outputDistributionHistoryGenerator = new OutputDistributionHistoryGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT * FROM ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" WHERE keep_until <= ?");
        stringBuilder.append(" and keep_until <> 0");
        stringBuilder.append(" and keep_until <> -1");
        String string = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<OutputDistributionHistory> arrayList = new ArrayList<OutputDistributionHistory>();
            while (resultSet.next()) {
                OutputDistributionHistory outputDistributionHistory = (OutputDistributionHistory)((Object)outputDistributionHistoryGenerator.generateObject(resultSet));
                arrayList.add(outputDistributionHistory);
            }
            outputDistributionHistoryArray = arrayList.toArray(new OutputDistributionHistory[arrayList.size()]);
        }
        catch (Exception exception) {
            block5: {
                try {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"Error getting output distribution history.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return outputDistributionHistoryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputDistributionHistory[] getByJobHistoryId(long l) throws DataException, ResourceUnavailableException {
        OutputDistributionHistory[] outputDistributionHistoryArray = new OutputDistributionHistory[]{};
        OutputDistributionHistoryGenerator outputDistributionHistoryGenerator = new OutputDistributionHistoryGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT * FROM ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" WHERE job_history_id = ?");
        String string = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<OutputDistributionHistory> arrayList = new ArrayList<OutputDistributionHistory>();
            while (resultSet.next()) {
                OutputDistributionHistory outputDistributionHistory = (OutputDistributionHistory)((Object)outputDistributionHistoryGenerator.generateObject(resultSet));
                arrayList.add(outputDistributionHistory);
            }
            outputDistributionHistoryArray = arrayList.toArray(new OutputDistributionHistory[arrayList.size()]);
        }
        catch (Exception exception) {
            block5: {
                try {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"Error getting output distribution history.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
            OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
        }
        OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return outputDistributionHistoryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputDistributionHistory save(OutputDistributionHistory outputDistributionHistory) throws ResourceUnavailableException, DataException {
        OutputDistributionHistory outputDistributionHistory2 = null;
        outputDistributionHistory.setCopiedToServerTimeUTC(System.currentTimeMillis());
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            outputDistributionHistory2 = (OutputDistributionHistory)((Object)super.save((Connection)wrappedConnection, (Object)outputDistributionHistory));
        }
        catch (SQLException sQLException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error saving output distribution history", (Throwable)sQLException);
            }
        }
        finally {
            OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
        return outputDistributionHistory2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" SET status=? WHERE id=?");
        String string = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            block4: {
                try {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Error updating the output distribution history's  status.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateKeepUntil(long l, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" SET keep_until=? WHERE id=?");
        String string = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            block4: {
                try {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Error updating the output distribution history's  status.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFileName(long l, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" SET file_name=? WHERE id=?");
        String string2 = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            block4: {
                try {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Error updating the output distribution history's  file name.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus(int n, long l, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" SET status=? WHERE job_history_id = ? AND stored_location = ? AND file_name = ?");
        String string3 = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string3);
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string2);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            block4: {
                try {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Error updating the output distribution history's  status.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public int massDelete(Connection connection, List<Long> list, long l) throws ResourceUnavailableException, DataException {
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            if (list != null && !list.isEmpty()) {
                connection2 = connection != null ? connection : super.getConnection();
                StringBuilder stringBuilder = new StringBuilder("DELETE FROM output_distribution_histories WHERE ");
                String string = SQLUtil.createWhereClauseWithINStatment(list, "id");
                stringBuilder.append(string);
                preparedStatement = connection2.prepareStatement(stringBuilder.toString());
                int n2 = 1;
                for (Long l2 : list) {
                    preparedStatement.setLong(n2, l2);
                    ++n2;
                }
                n = preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            String string = "Error Deleting Output Distribution Histories For Job History ID " + l;
            logger.debug((Object)string, (Throwable)sQLException);
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        catch (Throwable throwable) {
            String string = "Error Deleting Output Distribution Histories For Job History ID " + l;
            logger.debug((Object)string, throwable);
            throw new ResourceUnavailableException(string, throwable);
        }
        finally {
            OutputDistributionHistoryDMJdbc.closeEm(null, preparedStatement, null);
            if (connection == null) {
                OutputDistributionHistoryDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
        return n;
    }

    @Override
    public OutputDistributionHistory[] getByHistoryIdAndFileName(long l, String string, String string2) throws DataException, ResourceUnavailableException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("getJobHistoryId", l);
        hashMap.put("getLocation", string);
        hashMap.put("getFileName", string2);
        hashMap.put("getDistributionType", 1);
        return (OutputDistributionHistory[])super.search((Object)new OutputDistributionHistory(), hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int markPendingFailed(long l, int n) {
        int n2 = 0;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Marking Pending output distributions for run number " + l + " to failed."));
        }
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" SET status = ? WHERE status = ? AND job_history_id = ? AND distribution_type = ? ");
        String string = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setInt(1, 6);
            preparedStatement.setInt(2, 0);
            preparedStatement.setLong(3, l);
            preparedStatement.setInt(4, n);
            n2 = preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            block5: {
                try {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"Error updating the output distribution history's status.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        OutputDistributionHistoryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return n2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int delete(Connection connection, long l) throws ResourceUnavailableException, DataException {
        int n;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection2 = connection != null ? connection : super.getConnection();
            preparedStatement = this.getDefaultPreparedStmt("DELETE FROM output_distribution_histories WHERE id=?", connection2);
            preparedStatement.setLong(1, l);
            n = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                String string = "Error Deleting Output Distribution History  " + l;
                logger.debug((Object)string, (Throwable)sQLException);
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
                catch (Throwable throwable) {
                    String string2 = "Error Deleting Output Distribution History  " + l;
                    logger.debug((Object)string2, throwable);
                    throw new ResourceUnavailableException(string2, throwable);
                }
            }
            catch (Throwable throwable) {
                OutputDistributionHistoryDMJdbc.closeEm(null, preparedStatement, resultSet);
                if (connection != null) throw throwable;
                OutputDistributionHistoryDMJdbc.closeEm((Connection)connection2, null, null);
                throw throwable;
            }
        }
        OutputDistributionHistoryDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
        if (connection != null) return n;
        OutputDistributionHistoryDMJdbc.closeEm((Connection)connection2, null, null);
        return n;
    }

    @Override
    public int limitedDelete(Connection connection, List<Long> list, long l) throws ResourceUnavailableException, DataException {
        int n = list.size();
        int n2 = 0;
        int n3 = 0;
        if (n > 1000) {
            n2 = (int)Math.ceil((double)n / 1000.0);
            for (int i = 0; i < n2; ++i) {
                int n4 = (i + 1) * 1000;
                if (n4 > n) {
                    n4 = n;
                }
                int n5 = i * 1000;
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (int j = n5; j < n4; ++j) {
                    arrayList.add(list.get(j));
                }
                n3 = this.massDelete(connection, arrayList, l);
            }
        } else {
            n3 = this.massDelete(connection, list, l);
        }
        return n3;
    }

    private class OutputDistributionHistoryGenerator
    extends AbstractBusObjGenerator {
        public OutputDistributionHistoryGenerator() {
            super(9, OutputDistributionHistoryDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new OutputDistributionHistory();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            OutputDistributionHistory outputDistributionHistory = (OutputDistributionHistory)((Object)object);
            switch (n) {
                case 1: {
                    outputDistributionHistory.setOid(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    outputDistributionHistory.setJobHistoryId(resultSet.getLong("job_history_id"));
                    break;
                }
                case 3: {
                    outputDistributionHistory.setFileName(resultSet.getString("file_name"));
                    break;
                }
                case 4: {
                    outputDistributionHistory.setStatus(resultSet.getInt("status"));
                    break;
                }
                case 5: {
                    outputDistributionHistory.setLocation(resultSet.getString("stored_location"));
                    break;
                }
                case 6: {
                    outputDistributionHistory.setDistributionType(resultSet.getInt("distribution_type"));
                    break;
                }
                case 7: {
                    outputDistributionHistory.setKeepUntil(resultSet.getLong("keep_until"));
                    break;
                }
                case 8: {
                    outputDistributionHistory.setDeliverToUserName(resultSet.getBoolean("deliver_to_user_name"));
                    break;
                }
                case 9: {
                    outputDistributionHistory.setCopiedToServerTimeUTC(resultSet.getLong("copied_server_time_utc"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

