/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.LanguageCode;
import com.helpsystems.enterprise.core.dm.LanguageCodesDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class LanguageCodesDMJdbc
extends AbstractHelpingDatabaseManager
implements LanguageCodesDM {
    private static final String objDesc = "Language Code";
    private static final String LANGUAGE_CODES_TABLE = "language_codes";
    private static final String COMMON_SELECT = "SELECT id, code, name";
    private String languageCodesTable;

    public LanguageCodesDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.LanguageCodesDM");
        this.languageCodesTable = string2 + "." + LANGUAGE_CODES_TABLE;
    }

    @Override
    public LanguageCode get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        return this.get(l, null);
    }

    /*
     * Loose catch block
     */
    @Override
    public LanguageCode get(long l, Connection connection) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        block9: {
            LanguageCode languageCode;
            block11: {
                block10: {
                    LanguageCode languageCode2;
                    connection2 = connection;
                    preparedStatement = null;
                    resultSet = null;
                    if (connection2 == null) {
                        connection2 = super.getConnectionOrFail();
                    }
                    String string = "SELECT id, code, name FROM " + this.languageCodesTable + " WHERE id=?";
                    LanguageCodeGenerator languageCodeGenerator = new LanguageCodeGenerator(3);
                    preparedStatement = this.getDefaultPreparedStmt(string, connection2);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block9;
                    languageCode = languageCode2 = (LanguageCode)((Object)languageCodeGenerator.generateObject(resultSet));
                    if (connection != null) break block10;
                    LanguageCodesDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
                    break block11;
                }
                LanguageCodesDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            return languageCode;
        }
        try {
            throw new NoDataException("Language Code not found.");
            {
                catch (SQLException sQLException) {
                    String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                    throw new ResourceUnavailableException(string, (Throwable)sQLException);
                }
            }
        }
        catch (Throwable throwable) {
            if (connection == null) {
                LanguageCodesDMJdbc.closeEm((Connection)connection2, preparedStatement, resultSet);
            } else {
                LanguageCodesDMJdbc.closeEm(null, preparedStatement, resultSet);
            }
            throw throwable;
        }
    }

    @Override
    public LanguageCode getForCode(String string) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            LanguageCode languageCode;
            wrappedConnection = super.getConnectionOrFail();
            String string2 = "SELECT id, code, name FROM " + this.languageCodesTable + " WHERE code=?";
            preparedStatement = null;
            resultSet = null;
            LanguageCodeGenerator languageCodeGenerator = new LanguageCodeGenerator(3);
            preparedStatement = this.getDefaultPreparedStmt(string2, (Connection)wrappedConnection);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            LanguageCode languageCode2 = languageCode = (LanguageCode)((Object)languageCodeGenerator.generateObject(resultSet));
            LanguageCodesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return languageCode2;
        }
        try {
            try {
                throw new NoDataException("Language Code not found.");
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for code {1}.", (Object[])new Object[]{objDesc, string});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            LanguageCodesDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
            throw throwable;
        }
    }

    private class LanguageCodeGenerator
    extends AbstractBusObjGenerator {
        public LanguageCodeGenerator(int n) {
            super(n, LanguageCodesDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new LanguageCode();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            LanguageCode languageCode = (LanguageCode)((Object)object);
            switch (n) {
                case 1: {
                    long l = resultSet.getLong("id");
                    languageCode.setOID(l);
                    break;
                }
                case 2: {
                    String string = resultSet.getString("code");
                    if (string == null) {
                        string = "";
                    }
                    languageCode.setCode(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    languageCode.setLocalName(string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

