/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.RecordActionType;
import com.helpsystems.enterprise.core.dm.JobStatusCountRollupDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.util.DateConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class JobStatusCountRollupDMJdbc
extends AbstractHelpingDatabaseManager
implements JobStatusCountRollupDM {
    private static final String TABLE = "job_status_count_rollups";
    private static final Logger logger = Logger.getLogger(JobStatusCountRollupDMJdbc.class);
    private Object lockObject = new Object();

    public JobStatusCountRollupDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.JobStatusCountRollupDM");
    }

    @Override
    public void saveStatusCount(JobStatusCode jobStatusCode, long l, long l2, long l3) throws ResourceUnavailableException, DataException {
        String string = null;
        switch (jobStatusCode) {
            case COMPLETED: {
                string = "completed_count";
                break;
            }
            case FAILED: {
                string = "failed_count";
                break;
            }
            case ERROR: {
                string = "error_count";
                break;
            }
            case CANCELED: {
                string = "canceled_count";
            }
        }
        if (string != null) {
            this.updateInsertRow(string, l, l2, l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInsertRow(String string, long l, long l2, long l3) {
        long l4 = DateConverter.calculateDay(l);
        Object object = this.lockObject;
        synchronized (object) {
            RecordActionType recordActionType = this.getCurrentRowAction(l4, l2);
            if (recordActionType == RecordActionType.UPDATE) {
                this.updateRow(string, l4, l2, l3);
            } else if (recordActionType == RecordActionType.INSERT) {
                this.insertRow(string, l4, l2, l3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RecordActionType getCurrentRowAction(long l, long l2) {
        RecordActionType recordActionType = RecordActionType.IGNORE;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT 1 FROM job_status_count_rollups WHERE day = ? AND agent_id = ?";
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            resultSet = preparedStatement.executeQuery();
            recordActionType = resultSet.next() ? RecordActionType.UPDATE : RecordActionType.INSERT;
            if (wrappedConnection == null) return recordActionType;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            if (wrappedConnection == null) return recordActionType;
            JobStatusCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            return recordActionType;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Selecting job_status_count_rollups for specified Day and Agent", (Throwable)sQLException);
            if (wrappedConnection == null) return recordActionType;
            {
                catch (Throwable throwable) {
                    if (wrappedConnection == null) throw throwable;
                    JobStatusCountRollupDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
            JobStatusCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            return recordActionType;
        }
        JobStatusCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return recordActionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateRow(String string, long l, long l2, long l3) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            String string2 = "UPDATE job_status_count_rollups SET " + string + " = " + string + " + 1, " + "total_job_runtime = total_job_runtime + ? " + "WHERE day = ? AND agent_id = ?";
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setLong(1, l3);
            preparedStatement.setLong(2, l);
            preparedStatement.setLong(3, l2);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Updating to job_status_count_rollups table", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                JobStatusCountRollupDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
            }
        }
        JobStatusCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertRow(String string, long l, long l2, long l3) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        String string2 = null;
        PreparedStatement preparedStatement = null;
        try {
            string2 = "INSERT INTO job_status_count_rollups (day, agent_id, total_job_runtime, " + string + ") values (?, ?, ?, 1)";
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l3);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Inserting to job_status_count_rollups table ", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                JobStatusCountRollupDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
            }
        }
        JobStatusCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void manualJobStatusPurge(long l) throws ResourceUnavailableException, DataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            long l2 = DateConverter.getCompDay(l);
            logger.debug((Object)("Purging Job Status Count Rollup older than: " + ScheduleLogger.formatTimeStamp(l2)));
            wrappedConnection = this.getConnectionOrFail();
            String string = "DELETE FROM job_status_count_rollups WHERE day < ?";
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Deleting from Job Status Count Rollup table", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                JobStatusCountRollupDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
            }
        }
        JobStatusCountRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }
}

