/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.EventHistoryXRef;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.dm.EventHistoryXRefDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class EventHistoryXRefDMJdbc
extends AbstractHelpingDatabaseManager
implements EventHistoryXRefDM {
    private static final Logger logger = Logger.getLogger(EventHistoryXRefDMJdbc.class);
    public static final String TABLE_NAME = "EVENT_HISTORY_XREFS";
    private String table;

    public EventHistoryXRefDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, String string3) {
        super(string, string2, sQLManagerHelper);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.setName(string3);
        this.table = string2 + "." + TABLE_NAME;
    }

    @Override
    public int copyRestartedXRefs(long l, long l2) throws ResourceUnavailableException, SQLException {
        int n = 0;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnection();
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        String string = "select * from " + this.table + " where JOB_HISTORY_ID=?";
        String string2 = "insert into " + this.table + " (JOB_HISTORY_ID, EVENT_HISTORY_ID, PREREQ_TYPE) values (?, ?, ?)";
        try {
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            preparedStatement2 = wrappedConnection.prepareStatement(string2);
            while (resultSet.next()) {
                long l3 = resultSet.getLong("EVENT_HISTORY_ID");
                long l4 = resultSet.getLong("PREREQ_TYPE");
                preparedStatement2.setLong(1, l2);
                preparedStatement2.setLong(2, l3);
                preparedStatement2.setLong(3, l4);
                preparedStatement2.executeUpdate();
                ++n;
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Error copying Agent Event History XREFs.", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                EventHistoryXRefDMJdbc.closeEm(null, preparedStatement2, null);
                EventHistoryXRefDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        EventHistoryXRefDMJdbc.closeEm(null, (Statement)preparedStatement2, null);
        EventHistoryXRefDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return n;
    }

    @Override
    public void deleteForJobHistory(Connection connection, long l) throws ResourceUnavailableException, SQLException {
        Connection connection2 = connection;
        if (connection2 == null) {
            connection2 = super.getConnection();
        }
        String string = "delete from " + this.table + " where JOB_HISTORY_ID=?";
        PreparedStatement preparedStatement = connection2.prepareStatement(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while deleting the event history xref.", (Object[])new Object[0]);
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            if (connection == null) {
                EventHistoryXRefDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
    }

    @Override
    public void deleteForAgentEventHistoryInfo(Connection connection, long l) throws ResourceUnavailableException, SQLException {
        Connection connection2 = connection;
        if (connection2 == null) {
            connection2 = super.getConnection();
        }
        String string = "delete from " + this.table + " where EVENT_HISTORY_ID=?";
        PreparedStatement preparedStatement = connection2.prepareStatement(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while deleting the event history xref.", (Object[])new Object[0]);
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            if (connection == null) {
                EventHistoryXRefDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
    }

    @Override
    public EventHistoryXRef[] getListForJobHistory(long l, PrereqEventType prereqEventType) throws ResourceUnavailableException, DataException {
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        hashMap.put("getJobHistoryID", l);
        hashMap.put("getPrereqTypeAsInt", prereqEventType.persistanceCode());
        EventHistoryXRef[] eventHistoryXRefArray = (EventHistoryXRef[])super.search((Object)new EventHistoryXRef(), hashMap);
        return eventHistoryXRefArray;
    }

    @Override
    public EventHistoryXRef save(Connection connection, EventHistoryXRef eventHistoryXRef) throws ResourceUnavailableException, DataException {
        EventHistoryXRef eventHistoryXRef2 = (EventHistoryXRef)((Object)super.save(connection, (Object)eventHistoryXRef));
        return eventHistoryXRef2;
    }
}

