/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.automate;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPACommand;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPACommandType;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTargetType;
import com.helpsystems.enterprise.core.dm.automate.AutoMateBPACommandsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class AutoMateBPACommandsDMJdbc
extends AbstractHelpingDatabaseManager
implements AutoMateBPACommandsDM {
    private static final String objDesc = "AutoMate BPA Command";
    private static final String AUTOMATE_BPA_COMMANDS_TABLE = "automate_bpa_commands";
    private static final String COMMON_SQL_SELECT;
    private String autoMateBPACommandsTable;

    public AutoMateBPACommandsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.AutoMateBPACommandsDM");
        this.autoMateBPACommandsTable = string2 + "." + AUTOMATE_BPA_COMMANDS_TABLE;
    }

    @Override
    public AutoMateBPACommand getAutoMateBPACommandViaCommandID(long l) throws NoDataException, ResourceUnavailableException, BadDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            AutoMateBPACommand autoMateBPACommand;
            wrappedConnection = super.getConnectionOrFail();
            String string = COMMON_SQL_SELECT + " FROM " + this.autoMateBPACommandsTable + " WHERE command_id=?";
            AutoMateBPATaskCommandGenerator autoMateBPATaskCommandGenerator = new AutoMateBPATaskCommandGenerator(NUMBER_OF_FIELDS);
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            AutoMateBPACommand autoMateBPACommand2 = autoMateBPACommand = (AutoMateBPACommand)autoMateBPATaskCommandGenerator.generateObject(resultSet);
            AutoMateBPACommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return autoMateBPACommand2;
        }
        try {
            try {
                throw new NoDataException("AutoMate BPA Command not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            AutoMateBPACommandsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    static {
        String string = "SELECT ";
        boolean bl = false;
        for (int i = 0; i < TABLE_COLUMNS.length; ++i) {
            if (bl) {
                string = string + ", ";
            }
            string = string + TABLE_COLUMNS[i];
            bl = true;
        }
        COMMON_SQL_SELECT = string;
    }

    private class AutoMateBPATaskCommandGenerator
    extends AbstractBusObjGenerator {
        public AutoMateBPATaskCommandGenerator(int n) {
            super(n, AutoMateBPACommandsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new AutoMateBPACommand();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AutoMateBPACommand autoMateBPACommand = (AutoMateBPACommand)object;
            switch (n) {
                case 1: {
                    autoMateBPACommand.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    autoMateBPACommand.setCommandID(resultSet.getLong("command_id"));
                    break;
                }
                case 3: {
                    autoMateBPACommand.setAutoMateSystemDefinitionID(resultSet.getLong("automate_system_definition_id"));
                    break;
                }
                case 4: {
                    autoMateBPACommand.setCommandType(AutoMateBPACommandType.persistanceCodeToEnum(resultSet.getInt("automate_command_type")));
                    break;
                }
                case 5: {
                    autoMateBPACommand.setBpaCommandID(resultSet.getString("automate_command_id"));
                    break;
                }
                case 6: {
                    autoMateBPACommand.setBpaCommandName(resultSet.getString("automate_command_name"));
                    break;
                }
                case 7: {
                    autoMateBPACommand.setBpaCommandPath(resultSet.getString("automate_command_path"));
                    break;
                }
                case 8: {
                    if (autoMateBPACommand.getCommandType().equals(AutoMateBPACommandType.WORKFLOW)) break;
                    autoMateBPACommand.setTargetType(AutoMateTargetType.persistanceCodeToEnum(resultSet.getInt("automate_target_type")));
                    break;
                }
                case 9: {
                    if (autoMateBPACommand.getCommandType().equals(AutoMateBPACommandType.WORKFLOW)) break;
                    autoMateBPACommand.setTargetID(resultSet.getString("automate_target_id"));
                    break;
                }
                case 10: {
                    if (autoMateBPACommand.getCommandType().equals(AutoMateBPACommandType.WORKFLOW)) break;
                    autoMateBPACommand.setTargetPath(resultSet.getString("automate_target_path"));
                    break;
                }
                case 11: {
                    autoMateBPACommand.setWaitForCompletion(resultSet.getBoolean("wait_for_completion"));
                    break;
                }
                case 12: {
                    autoMateBPACommand.setRunByID(resultSet.getBoolean("run_by_id"));
                    break;
                }
                case 13: {
                    autoMateBPACommand.setRunAgentByID(resultSet.getBoolean("run_agent_by_id"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

