/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access;

import com.helpsystems.common.access.service.JdbcServiceDescriptor;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.access.EnterpriseDatabase;
import com.helpsystems.enterprise.core.db.JDBC_Descriptor_ID;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class TestSetup {
    private static boolean initialized = false;
    private static Logger logger = null;

    private TestSetup() {
    }

    public static final void init() {
        if (initialized) {
            logger.trace((Object)"The test environment is already initialized.");
            return;
        }
        PropertyConfigurator.configureAndWatch((String)"log4j.properties", (long)5000L);
        logger = Logger.getLogger(TestSetup.class);
        TestSetup.startConnectionPool();
        initialized = true;
    }

    private static final void startConnectionPool() {
        JdbcServiceDescriptor jdbcServiceDescriptor = EnterpriseDatabase.createDefaultJDBCServiceDescriptor(JDBC_Descriptor_ID.DEVELOPMENT);
        try {
            EnterpriseDatabase.start(jdbcServiceDescriptor);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RuntimeException("Error starting JDBC connection pool.", resourceUnavailableException);
        }
    }
}

