/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.schedule;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.ValidationHelper;

public class SendRobotData
extends CommonVersionedObject {
    public static final int MAXLEN_JOB_NAME = 10;
    public static final int MAXLEN_JOB_NUMBER = 12;
    public static final String COMP_CODE_BLANK = "B";
    public static final String COMP_CODE_NORMAL = "C";
    public static final String COMP_CODE_DELAY = "D";
    public static final String COMP_CODE_SKIP = "K";
    public static final String COMP_CODE_PENDING = "P";
    public static final String COMP_CODE_RUNNING = "R";
    public static final String COMP_CODE_SUBMITTED = "S";
    public static final String COMP_CODE_ = "B";
    public static final String COMP_CODE_ABEND = "T";
    private String jobName = null;
    private String jobNumber = null;
    private String statusCode = "B";

    public SendRobotData() {
    }

    public SendRobotData(String string, String string2) {
        this(string, "", string2);
    }

    public SendRobotData(String string, String string2, String string3) {
        this.setJobName(string);
        this.setJobNumber(string2);
        this.setStatusCode(string3);
    }

    public String buildSndMsgCommand() {
        if (this.jobName == null && this.jobNumber == null || this.jobName.trim().length() < 1 && this.jobNumber.trim().length() < 12) {
            throw new IllegalStateException("Either Job Number or Name is required.");
        }
        StringBuffer stringBuffer = new StringBuffer("SNDRBTDTA");
        if (this.jobNumber != null && this.jobNumber.trim().length() == 12) {
            stringBuffer.append(" PRQJOB#(" + this.jobNumber.replaceAll("'", "''") + ")");
        } else if (this.jobName != null && this.jobName.trim().length() > 0) {
            stringBuffer.append(" PRQJOB(" + this.jobName.replaceAll("'", "''") + ")");
        } else {
            throw new IllegalStateException("Either Job Number or Name is required.");
        }
        stringBuffer.append(" STATUS(" + this.statusCode + ")");
        return stringBuffer.toString();
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String string) {
        String string2 = "Job Name";
        if (string == null) {
            this.jobName = "";
            return;
        }
        String string3 = Convert.trimR(string);
        ValidationHelper.validateLength(string2, 10, string3);
        this.jobName = string3;
    }

    public String getJobNumber() {
        return this.jobNumber;
    }

    public void setJobNumber(String string) {
        String string2 = "Job Number";
        if (string == null) {
            this.jobNumber = "";
            return;
        }
        String string3 = Convert.trimR(string);
        ValidationHelper.validateLength(string2, 12, string3);
        this.jobNumber = string3;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String string) {
        String string2 = "Status Code";
        if (string == null || string.trim().length() < 1) {
            this.statusCode = "B";
            return;
        }
        String string3 = string.trim();
        ValidationHelper.validateLength(string2, 1, string3);
        this.statusCode = string3;
    }
}

