/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.reporting;

import com.helpsystems.common.core.reporting.ReportField;
import junit.framework.TestCase;

public class ReportFieldTest
extends TestCase {
    static final int FONTCOLOR_BOGUS = -1234;
    ReportField rf;

    protected void setUp() throws Exception {
        super.setUp();
        this.rf = new ReportField();
    }

    protected void tearDown() throws Exception {
        this.rf = null;
        super.tearDown();
    }

    public void testConstructorWithValueDefaultsToLeftAlignment() {
        this.rf = new ReportField("some_value");
        ReportFieldTest.assertEquals((String)"some_value", (String)this.rf.getValue());
        ReportFieldTest.assertEquals((int)0, (int)this.rf.getAlignment());
        ReportFieldTest.assertEquals((int)0, (int)this.rf.getFontColor());
    }

    public void testConstructorWithValueAndAlignment() {
        this.rf = new ReportField("some_value", 2);
        ReportFieldTest.assertEquals((String)"some_value", (String)this.rf.getValue());
        ReportFieldTest.assertEquals((int)2, (int)this.rf.getAlignment());
        ReportFieldTest.assertEquals((int)0, (int)this.rf.getFontColor());
    }

    public void testSetAlignment() {
        ReportFieldTest.assertEquals((int)0, (int)this.rf.getAlignment());
        this.rf.setAlignment(2);
        ReportFieldTest.assertEquals((int)2, (int)this.rf.getAlignment());
        this.rf.setAlignment(1);
        ReportFieldTest.assertEquals((int)1, (int)this.rf.getAlignment());
        this.rf.setAlignment(0);
        ReportFieldTest.assertEquals((int)0, (int)this.rf.getAlignment());
    }

    public void testSetValue() {
        this.rf.setValue("some_value");
        ReportFieldTest.assertEquals((String)"some_value", (String)this.rf.getValue());
        this.rf.setValue("other_value");
        ReportFieldTest.assertEquals((String)"other_value", (String)this.rf.getValue());
    }

    public void testGetValueNullReturnsEmptyString() {
        this.rf.setValue(null);
        ReportFieldTest.assertEquals((String)"", (String)this.rf.getValue());
    }

    public void testSetNonBreakingHTMLText() {
        this.rf.setNonBreakingHTMLText(true);
        ReportFieldTest.assertTrue((boolean)this.rf.isNonBreakingHTMLText());
        this.rf.setNonBreakingHTMLText(false);
        ReportFieldTest.assertFalse((boolean)this.rf.isNonBreakingHTMLText());
    }

    public void testGetValueAsMonoFontHTML() {
        this.rf.setValue("value");
        String string = this.rf.getValueAsMonoFontHTML(5, "XYZ");
        String string2 = "valueXYZ";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setValue("super long value");
        string = this.rf.getValueAsMonoFontHTML(5, "XYZ");
        string2 = "super<br> long<br> valu<br>eXYZ";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setFonfColor(2);
        string = this.rf.getValueAsMonoFontHTML(5, "XYZ");
        string2 = "<font color=red>super<br> long<br> valu<br>eXYZ</font>";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setFonfColor(1);
        string = this.rf.getValueAsMonoFontHTML(5, "XYZ");
        string2 = "<font color=green>super<br> long<br> valu<br>eXYZ</font>";
        ReportFieldTest.assertEquals((String)string2, (String)string);
    }

    public void testGetValueAsMonoFontHTMLWithVerySpecialValues() {
        this.rf.setValue(null);
        String string = this.rf.getValueAsMonoFontHTML(20, "");
        String string2 = "&nbsp;";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setValue("< 0.01");
        string = this.rf.getValueAsMonoFontHTML(20, "");
        string2 = "&lt;&nbsp;0.01";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setValue("< -0.01");
        string = this.rf.getValueAsMonoFontHTML(20, "");
        string2 = "&lt;&nbsp;-0.01";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setValue(" X Y ");
        string = this.rf.getValueAsMonoFontHTML(20, "");
        string2 = "X Y";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setNonBreakingHTMLText(true);
        string = this.rf.getValueAsMonoFontHTML(20, "");
        string2 = "X&nbsp;Y";
        ReportFieldTest.assertEquals((String)string2, (String)string);
    }

    public void testGetValueAsHTML() {
        this.rf.setValue("value");
        String string = this.rf.getValueAsHTML();
        String string2 = "value";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setValue("");
        string = this.rf.getValueAsHTML();
        string2 = "&nbsp;";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setValue("embedded blank");
        string = this.rf.getValueAsHTML();
        string2 = "embedded blank";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setNonBreakingHTMLText(true);
        string = this.rf.getValueAsHTML();
        string2 = "embedded&nbsp;blank";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setFonfColor(2);
        string = this.rf.getValueAsHTML();
        string2 = "<font color=red>embedded&nbsp;blank</font>";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setFonfColor(1);
        string = this.rf.getValueAsHTML();
        string2 = "<font color=green>embedded&nbsp;blank</font>";
        ReportFieldTest.assertEquals((String)string2, (String)string);
    }

    public void testGetValueAsHTMLWithVerySpecialValues() {
        this.rf.setValue(null);
        String string = this.rf.getValueAsHTML();
        String string2 = "&nbsp;";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setValue("< 0.01");
        string = this.rf.getValueAsHTML();
        string2 = "&lt;&nbsp;0.01";
        ReportFieldTest.assertEquals((String)string2, (String)string);
        this.rf.setValue("< -0.01");
        string = this.rf.getValueAsHTML();
        string2 = "&lt;&nbsp;-0.01";
        ReportFieldTest.assertEquals((String)string2, (String)string);
    }

    public void testSetFontColor() {
        ReportFieldTest.assertEquals((int)0, (int)this.rf.getFontColor());
        this.rf.setFonfColor(1);
        ReportFieldTest.assertEquals((int)1, (int)this.rf.getFontColor());
        this.rf.setFonfColor(2);
        ReportFieldTest.assertEquals((int)2, (int)this.rf.getFontColor());
        this.rf.setFonfColor(0);
        ReportFieldTest.assertEquals((int)0, (int)this.rf.getFontColor());
    }

    public void testSetFontColorRejectsInvalidValue() {
        try {
            this.rf.setFonfColor(-1234);
            ReportFieldTest.fail((String)"setFonfColor() accepted an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

