/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.reporting;

import com.helpsystems.common.core.reporting.AbstractReportWriter;
import com.helpsystems.common.core.reporting.ReportField;
import com.helpsystems.common.core.reporting.ReportSelectionCriteria;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;

public class HTMLReportWriter
extends AbstractReportWriter {
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(HTMLReportWriter.class);
    private static final Logger logger = Logger.getLogger(HTMLReportWriter.class);
    public static final String EOL = System.getProperty("line.separator");
    public static final String TAB = "\t";
    public static final String NBSP = "&nbsp;";
    private static final int insetPerUnit = 25;
    public static final int MAX_COL_SIZE = 50;
    private String filePath = null;
    private FileWriter fw = null;
    private int tableColumns = 0;
    private int innerTableColumns = 0;
    private int insetCount = 0;
    private boolean activePairedValueTable = false;
    private boolean activeTable = false;
    private int tblLineNumber = 0;
    private boolean activeInnerTable = false;
    private boolean activeRowText = false;
    private boolean monFontTables = false;

    public HTMLReportWriter(String string) {
        this(string, false);
    }

    public HTMLReportWriter(String string, boolean bl) {
        this.filePath = string;
        this.monFontTables = bl;
        try {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
                file.createNewFile();
            } else {
                file.createNewFile();
            }
            this.fw = new FileWriter(file);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error opening: " + string, exception);
        }
    }

    @Override
    public String getFileName() {
        return this.filePath;
    }

    @Override
    public void closeReport() {
        if (this.fw != null) {
            try {
                this.fw.close();
            }
            catch (Exception exception) {
                throw new RuntimeException("Error closing file.");
            }
        }
        super.closeReport();
    }

    @Override
    public int getCurrentPage() {
        return 1;
    }

    @Override
    public int getNextLine() {
        return 0;
    }

    @Override
    public void writeHeader(String string, ReportSelectionCriteria[] reportSelectionCriteriaArray, String string2, String string3) throws IOException {
        this.writeComment("Writing The Header");
        this.writeHTMLHeading(string);
        if (this.getPreViewText() != null) {
            this.writePreviewHeading(this.getPreViewText());
        }
        this.writeReportHeading(string, string2, string3);
        if (reportSelectionCriteriaArray != null && reportSelectionCriteriaArray.length > 0) {
            int[] nArray = new int[]{30, 70};
            this.writeSectionHeading(rbh.getText("selection_criteria"), 0, 3);
            this.writePairedValueTable_Start();
            for (int i = 0; i < reportSelectionCriteriaArray.length; ++i) {
                this.writePairedValueTable_Entry(reportSelectionCriteriaArray[i].getLabel(), reportSelectionCriteriaArray[i].getValue(), nArray);
            }
            this.writePairedValueTable_End();
        }
    }

    @Override
    public void writeFooter() throws IOException {
        this.writeComment("Writing The Footer");
        if (this.activeRowText) {
            throw new RuntimeException("Row Text must be ended before writing the footer.");
        }
        if (this.activeInnerTable) {
            throw new RuntimeException("An active inner table must be closed before writing the footer.");
        }
        if (this.activeTable) {
            throw new RuntimeException("An active table must be closed before writing the footer.");
        }
        if (this.activePairedValueTable) {
            throw new RuntimeException("An active paired value table must be closed before writing the footer.");
        }
        if (this.insetCount > 0) {
            throw new RuntimeException("Unable to write footer while " + this.insetCount + " inset levels remain.");
        }
        this.write(EOL);
        this.write("<TABLE CLASS=\"footerTable\">" + EOL);
        this.write("\t<TR>" + EOL);
        this.write("\t<TD ALIGN=CENTER>" + rbh.getText("end_of_report") + "</TD>" + EOL);
        this.write("\t</TR>" + EOL);
        this.write("</TABLE>");
        this.write(EOL);
        this.write(EOL + "</BODY>" + EOL + "</HTML>");
    }

    @Override
    public void writePageBreak() throws IOException {
    }

    @Override
    public void writeBlankLines(int n) throws IOException {
        this.writeComment("Writing " + n + " Blank Lines");
        for (int i = 0; i < n; ++i) {
            this.write("<br>" + EOL);
        }
    }

    @Override
    public void writeSectionHeading(String string, int n, int n2) throws IOException {
        this.writeComment("Writing a Section Heading");
        switch (n2) {
            case 1: {
                this.write(this.getHeading(2, string, n));
                break;
            }
            case 2: {
                this.write(this.getHeading(3, string, n));
                break;
            }
            default: {
                this.write(this.getHeading(4, string, n));
            }
        }
    }

    private String getHeading(int n, String string, int n2) {
        String string2 = "";
        switch (n2) {
            case 1: {
                string2 = " ALIGN=CENTER";
                break;
            }
            case 2: {
                string2 = " ALIGN=RIGHT";
                break;
            }
            default: {
                string2 = " ALIGN=LEFT";
            }
        }
        return "<H" + n + string2 + ">" + string.trim() + "</H" + n + ">" + EOL;
    }

    @Override
    public void writeFormattedLine(String string) throws IOException {
        this.writeComment("Writing a Formatted Line");
        this.write("<PRE>" + string + "</PRE>" + EOL);
    }

    @Override
    public void writePairedValueTable_Start() throws IOException {
        if (this.activePairedValueTable) {
            throw new RuntimeException("A paired value table is already active.");
        }
        this.writeComment("Starting a Paired Value Table");
        this.startPVTable();
    }

    @Override
    public void writePairedValueTable_Start(String string, int n) throws IOException {
        if (this.activePairedValueTable) {
            throw new RuntimeException("A paired value table is already active.");
        }
        this.writeComment("Starting a Paired Value Table with a Header");
        this.writeSectionHeading(string, 0, n);
        this.startPVTable();
    }

    private void startPVTable() throws IOException {
        this.write("<TABLE width=\"100%\" border=\"1\" cellpadding=\"2\" cellspacing=\"0\">" + EOL + "<TBODY ALIGN=LEFT>" + EOL);
        this.activePairedValueTable = true;
    }

    @Override
    public void writePairedValueTable_Entry(String string, String string2, int[] nArray) throws IOException {
        String string3;
        int n;
        if (!this.activePairedValueTable) {
            throw new RuntimeException("A paired value table must be active to write entries.");
        }
        int n2 = 0;
        int n3 = 0;
        if (nArray.length == 2 && (n = nArray[0] + nArray[1]) > 0) {
            n2 = nArray[0] * 100 / n;
            n3 = nArray[1] * 100 / n;
        }
        String string4 = "";
        String string5 = "";
        if (n2 > 0 && n3 > 0) {
            string4 = " WIDTH=\"" + n2 + "%\"";
            string5 = " WIDTH=\"" + n3 + "%\"";
        }
        if ((string3 = string.trim()).length() == 0) {
            string3 = NBSP;
        }
        String string6 = null;
        if (string2 != null) {
            string6 = string2.trim();
        } else {
            logger.debug((Object)"Paired value entry was null.  Using blank.");
            string6 = "";
        }
        if (string6.length() == 0) {
            string6 = NBSP;
        }
        this.write(EOL);
        this.write("\t<TR>" + EOL);
        this.write("\t\t<TD CLASS=\"pvLabel\"" + string4 + ">" + string3 + "</TD>" + EOL);
        this.write("\t\t<TD CLASS=\"pvValue\"" + string5 + ">" + string6 + "</TD>" + EOL);
        this.write("\t</TR>" + EOL);
    }

    @Override
    public void writePairedValueTable_End() throws IOException {
        if (this.activePairedValueTable) {
            this.write(EOL);
            this.write("</TBODY>" + EOL + "</TABLE>" + EOL + "<BR>" + EOL);
            this.writeComment("Ended a Paired Value Table");
            this.activePairedValueTable = false;
        } else {
            logger.debug((Object)"WARNING: A paired value table is not active for ending.");
        }
    }

    @Override
    public void addInset() throws IOException {
        this.addInset(1);
    }

    @Override
    public void addInset(int n) throws IOException {
        this.writeComment("Inset was Added");
        int n2 = n * 25;
        this.write("<TABLE width=\"100%\" cellpadding=\"2\"><TBODY ALIGN=LEFT><TR><TD WIDTH=" + n2 + "></TD><TD>" + EOL);
        ++this.insetCount;
    }

    @Override
    public void removeInset() throws IOException {
        if (this.insetCount < 1) {
            logger.debug((Object)"WARNING: There are no active insets to remove");
            return;
        }
        this.write(EOL);
        this.write("</TD></TR></TBODY></TABLE><BR>" + EOL);
        this.writeComment("Inset was Removed");
        --this.insetCount;
    }

    @Override
    public void removeInset(int n) throws IOException {
        this.removeInset();
    }

    @Override
    public void writeTable_Start(String[] stringArray, int[] nArray, String string, int n, boolean bl) throws IOException {
        this.validateTableStatus(bl);
        if (bl) {
            this.writeComment("Starting an Inner Table with a Heading.");
        } else {
            this.writeComment("Starting a Table with a Heading.");
        }
        this.writeSectionHeading(string, 0, n);
        this.startTable(stringArray, nArray, bl);
    }

    @Override
    public void writeTable_Start(String[] stringArray, int[] nArray, boolean bl) throws IOException {
        this.validateTableStatus(bl);
        if (bl) {
            this.writeComment("Starting an Inner Table.");
        } else {
            this.writeComment("Starting a Table.");
        }
        this.startTable(stringArray, nArray, bl);
    }

    private void validateTableStatus(boolean bl) {
        if (!bl) {
            if (this.activeTable) {
                throw new RuntimeException("A table is already active.");
            }
        } else {
            if (!this.activeTable) {
                throw new RuntimeException("A table must be active before starting an inner table.");
            }
            if (this.activeInnerTable) {
                throw new RuntimeException("An inner table is already active.");
            }
        }
    }

    private void startTable(String[] stringArray, int[] nArray, boolean bl) throws IOException {
        int n;
        int n2 = 0;
        if (stringArray.length < 1) {
            throw new RuntimeException("No columns for the table heading...");
        }
        if (nArray.length != stringArray.length) {
            throw new RuntimeException("Number of column sizes does not match the number of columns");
        }
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray2.length; ++n) {
            if (this.monFontTables && nArray[n] > 50) {
                nArray2[n] = 50;
                n2 += 50;
                continue;
            }
            nArray2[n] = nArray[n];
            n2 += nArray[n];
        }
        if (bl) {
            this.innerTableColumns = stringArray.length;
        } else {
            this.tableColumns = stringArray.length;
        }
        if (bl) {
            this.write(TAB + this.getTRTag(this.tblLineNumber) + EOL);
            this.write("\t\t<TD COLSPAN=\"" + this.tableColumns + "\" ALIGN=right>" + EOL);
            this.write("<TABLE width=\"95%\" cellpadding=\"2\" cellspacing=\"0\" class=\"innerTable\">" + EOL);
            this.write("<TBODY ALIGN=LEFT>" + EOL);
            this.write(TAB + this.getTRTag(this.tblLineNumber) + EOL);
        } else {
            this.write("<TABLE width=\"100%\" cellpadding=\"2\" cellspacing=\"0\" CLASS=\"normalTable\">" + EOL);
            this.write("<TBODY ALIGN=LEFT>" + EOL);
            this.write("\t<TR>" + EOL);
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n3 = 0;
            if (nArray2[n] != 0) {
                n3 = nArray2[n] * 100 / n2;
            }
            if (n3 < 1) {
                n3 = 1;
            }
            this.write("\t\t" + this.formatColumnHeader(stringArray[n], n3, bl) + EOL);
        }
        this.write("\t</TR>" + EOL);
        if (bl) {
            this.activeInnerTable = true;
        } else {
            this.activeTable = true;
            this.tblLineNumber = 0;
        }
    }

    private String formatColumnHeader(String string, int n, boolean bl) {
        String string2 = "";
        string2 = !bl ? "CLASS=\"normalHeading\" " : "CLASS=\"innerHeading\" ";
        if (string != null) {
            String string3 = string.trim();
            if (string3.length() == 0) {
                string3 = NBSP;
            }
            if (n > 0) {
                return "<TD ALIGN=LEFT " + string2 + "WIDTH=\"" + n + "%\">" + string3 + "</TD>";
            }
            return "<TD ALIGN=LEFT " + string2 + ">" + string3 + "</TD>";
        }
        return "<TD ALIGN=LEFT " + string2 + ">" + NBSP + "</TD>";
    }

    @Override
    public void writeTable_Entry(ReportField[] reportFieldArray, boolean bl) throws IOException {
        if (reportFieldArray == null || reportFieldArray.length < 1) {
            throw new RuntimeException("There are no fields for the table entry.");
        }
        if (!bl) {
            if (!this.activeTable) {
                throw new RuntimeException("A table must be active to write a table entry.");
            }
            if (this.activeInnerTable) {
                throw new RuntimeException("A normal table entry cannot be written while an inner table is active.");
            }
            if (reportFieldArray.length != this.tableColumns) {
                throw new RuntimeException("There number of fields (" + reportFieldArray.length + ") does not match the number of defined columns (" + this.tableColumns + ").");
            }
        } else {
            if (!this.activeInnerTable) {
                throw new RuntimeException("An inner table must be active to write a inner table entry.");
            }
            if (reportFieldArray.length != this.innerTableColumns) {
                throw new RuntimeException("There number of fields (" + reportFieldArray.length + ") does not match the number of defined inner table columns (" + this.innerTableColumns + ").");
            }
        }
        if (!bl) {
            ++this.tblLineNumber;
        }
        this.write(EOL);
        this.write(TAB + this.getTRTag(this.tblLineNumber) + EOL);
        for (int i = 0; i < reportFieldArray.length; ++i) {
            this.write("\t\t" + this.formatColumnCell(reportFieldArray[i]) + EOL);
        }
        this.write("\t</TR>" + EOL);
    }

    private String formatColumnCell(ReportField reportField) {
        String string = " ALIGN=LEFT";
        String string2 = "";
        if (reportField == null) {
            return "<TD" + string + ">" + NBSP + "</TD>";
        }
        switch (reportField.getAlignment()) {
            case 1: {
                string = " ALIGN=CENTER";
                break;
            }
            case 2: {
                string = " ALIGN=RIGHT";
                string2 = NBSP;
            }
        }
        if (this.monFontTables) {
            return "<TD" + string + " class=mono>" + reportField.getValueAsMonoFontHTML(50, string2) + "</TD>";
        }
        return "<TD" + string + ">" + reportField.getValueAsHTML() + string2 + "</TD>";
    }

    @Override
    public void writeTable_End(boolean bl) throws IOException {
        if (bl) {
            if (!this.activeInnerTable) {
                throw new RuntimeException("An inner table is not active to be ended.");
            }
            this.write(EOL);
            this.write("</TBODY>" + EOL);
            this.write("</TABLE>" + EOL);
            this.write("\t\t</TD>" + EOL);
            this.write("\t</TR>" + EOL);
            this.writeComment("Ended an Inner Table.");
            this.innerTableColumns = 0;
            this.activeInnerTable = false;
        } else {
            if (this.activeInnerTable) {
                throw new RuntimeException("An inner table is active. It must be ended before the normal table is ended.");
            }
            if (!this.activeTable) {
                logger.debug((Object)"WARNING: A table is not active to be ended.");
                return;
            }
            this.write(EOL);
            this.write("</TBODY>" + EOL);
            this.write("</TABLE>" + EOL);
            this.write("<BR>" + EOL);
            this.writeComment("Ended a Table.");
            this.tableColumns = 0;
            this.activeTable = false;
            this.tblLineNumber = 0;
        }
    }

    @Override
    public void writeRowText_Start() throws IOException {
        if (!this.activeTable) {
            throw new RuntimeException("A table must be active to start Row Text.");
        }
        if (this.activeRowText) {
            throw new RuntimeException("Row Text is already active.");
        }
        String string = "";
        if (this.tableColumns > 0) {
            string = " COLSPAN=\"" + this.tableColumns + "\"";
        }
        this.writeComment("Starting Row Text in a Table.");
        this.write(TAB + this.getTRTag(this.tblLineNumber) + EOL);
        this.write("\t\t<TD" + string + ">" + EOL);
        this.activeRowText = true;
    }

    @Override
    public void writeRowText_Entry(String string) throws IOException {
        if (!this.activeRowText) {
            throw new RuntimeException("Row Text must be active to write lines.");
        }
        this.write("\t\t<PRE>" + string + "</PRE>" + EOL);
    }

    @Override
    public void writeRowText_End() throws IOException {
        if (!this.activeRowText) {
            logger.debug((Object)"WARNING: Row Text is not active to be ended.");
        }
        this.write("\t\t</TD>" + EOL);
        this.write("\t</TR>" + EOL);
        this.writeComment("Ended Row Text in a Table.");
        this.activeRowText = false;
    }

    private void writeHTMLHeading(String string) throws IOException {
        this.write("<HTML>" + EOL);
        this.write("<HEAD>" + EOL);
        this.write("<TITLE> " + string + " </TITLE>" + EOL);
        this.write("<STYLE> " + EOL);
        this.write("\ttable.titleTable {width: 100%; font : bold; color : white; background-color : navy;}" + EOL);
        this.write("\ttable.titlePreview {width: 100%; font : bold; color : white; background-color : green;}" + EOL);
        this.write("\ttable.footerTable {width: 100%; font : bold; color : white; background-color : navy;}" + EOL);
        this.write("\ttable.innerTable {font : bold Arial, Helvetica, Verdana;}" + EOL);
        this.write("\ttable.normalTable {}" + EOL);
        this.write(EOL);
        this.write("\ttr.odd {}" + EOL);
        this.write("\ttr.even {background-color : #e0f0ff;}" + EOL);
        this.write(EOL);
        this.write("\ttd  {font : 9pt Arial, Helvetica, Verdana;}" + EOL);
        this.write("\ttd.mono {font : 9pt courier, mono;  vertical-align : top;}" + EOL);
        this.write("\ttd.reportTitle, td.reportPreviewText, td.pvLabel, td.normalHeading, td.innerHeading {font-weight: bold;}" + EOL);
        this.write("\ttd.reportTitle, td.reportPreviewText {font-size: 18pt;}" + EOL);
        this.write("\ttd.reportPreviewText {color : white; background-color : green;}" + EOL);
        this.write("\ttd.pvLabel {text-align: left; color : white; background-color : navy;}" + EOL);
        this.write("\ttd.pvValue {text-align: left;}" + EOL);
        this.write("\ttd.normalHeading {font-size: 12pt; color : white; background-color : navy; border: inset 1pt;}" + EOL);
        this.write("\ttd.innerHeading {font-size: 10pt;}" + EOL);
        this.write("</STYLE> " + EOL);
        this.write("</HEAD>" + EOL);
        this.write("<BODY>" + EOL);
    }

    private void writePreviewHeading(String string) throws IOException {
        if (string == null || string.trim().length() < 1) {
            return;
        }
        this.write(EOL);
        this.write("<TABLE width=100%>" + EOL);
        this.write("\t<TR>" + EOL);
        this.write("\t<TD ALIGN=LEFT WIDTH=\"100%\">" + EOL);
        this.write("\t\t<TABLE class=\"titlePreview\">" + EOL);
        this.write("\t\t<TR>" + EOL);
        this.write("\t\t<TD ALIGN=CENTER WIDTH=\"100%\" class=\"reportPreviewText\">" + string.trim() + "</TD>" + EOL);
        this.write("\t\t</TR>" + EOL);
        this.write("\t\t</TABLE>" + EOL);
        this.write("\t</TD>" + EOL);
        this.write("\t</TR>" + EOL);
        this.write("</TABLE>" + EOL);
        this.write("<BR>" + EOL);
        this.write(EOL);
    }

    private void writeReportHeading(String string, String string2, String string3) throws IOException {
        Date date = new Date(System.currentTimeMillis());
        String string4 = DateTranslator.formatShortDate(date);
        String string5 = DateTranslator.formatTime(date);
        this.write(EOL);
        this.write("<TABLE width=100%>" + EOL);
        this.write("\t<TR>" + EOL);
        this.write("\t<TD ALIGN=LEFT WIDTH=\"100%\">" + EOL);
        this.write("\t\t<TABLE class=\"titleTable\">" + EOL);
        this.write("\t\t<TR>" + EOL);
        this.write("\t\t<TD ALIGN=LEFT WIDTH=\"15%\">" + string4 + "<br>" + string5 + "</TD>" + EOL);
        this.write("\t\t<TD ALIGN=CENTER WIDTH=\"70%\" class=\"reportTitle\">" + string.trim() + "</TD>" + EOL);
        this.write("\t\t<TD ALIGN=RIGHT WIDTH=\"15%\">" + string2 + "<br>" + string3 + "</TD>" + EOL);
        this.write("\t\t</TR>" + EOL);
        this.write("\t\t</TABLE>" + EOL);
        this.write("\t</TD>" + EOL);
        this.write("\t</TR>" + EOL);
        this.write("</TABLE>" + EOL);
        this.write("<BR>" + EOL);
        this.write(EOL);
    }

    private String getTRTag(int n) {
        if (n % 2 == 0) {
            return "<TR CLASS=EVEN>";
        }
        return "<TR CLASS=ODD>";
    }

    private void writeComment(String string) throws IOException {
        this.write(EOL);
        this.write(EOL);
        this.write("<!-- ** " + string + " ** -->" + EOL);
        this.write(EOL);
    }

    private void write(String string) throws IOException {
        this.checkReportStatus();
        this.fw.write(string);
    }
}

