/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.network.AbstractBusinessObject;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.NowTimestamp;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.sql.Timestamp;

public class PacketDistribution
extends AbstractBusinessObject {
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(PacketDistribution.class);
    private static final long serialVersionUID = -1834423413840123356L;
    public static final int TARGET_HOST_LOCAL = -11;
    public static final int PRODUCT_MASTER = -13;
    public static final int STATUS_NOT_PROCESSED = 2;
    public static final int STATUS_IN_PROCESS = 3;
    public static final int STATUS_PROCESSED = 5;
    public static final int STATUS_FAILED = 7;
    public static final int STATUS_REVERSED = 11;
    public static final String STATUS_NOT_PROCESSED_STRING = rbh.getText("not_processed");
    public static final String STATUS_IN_PROCESS_STRING = rbh.getText("in_process");
    public static final String STATUS_PROCESSED_STRING = rbh.getText("completed");
    public static final String STATUS_FAILED_STRING = rbh.getText("failed");
    public static final String STATUS_REVERSED_STRING = rbh.getText("reversed");
    public static final String STATUS_UNKNOWN_STRING = "!" + rbh.getText("unknown");
    public static final int SORT_DATE_TIME = 401;
    public static final int SORT_STATUS = 402;
    public static final int SORT_PACKET_NAME = 403;
    public static final int SORT_PRODUCT = 404;
    public static final int SORT_DESTINATION = 405;
    public static final int PRODUCT_NAME_MAX_LENGTH = 50;
    public static final int PACKET_NAME_MAX_LENGTH = 50;
    public static final int PACKET_DESCRIPTION_MAX_LENGTH = 50;
    public static String[] STATUS_STRINGS = new String[]{STATUS_NOT_PROCESSED_STRING, STATUS_IN_PROCESS_STRING, STATUS_PROCESSED_STRING, STATUS_FAILED_STRING, STATUS_REVERSED_STRING};
    public static int[] VALID_STATUS_VALUES = new int[]{2, 3, 5, 7, 11};
    public static Integer[] VALID_STATUS_INTEGERS = new Integer[]{new Integer(2), new Integer(3), new Integer(5), new Integer(7), new Integer(11)};
    private int packetOID;
    private int targetHostSIID;
    private int destinationPIID;
    private Timestamp installDateTime;
    private boolean installNow;
    private int status;
    private boolean legacy;
    private String packetName;
    private String packetDescription;
    private String productName;
    private String destinationName;

    public static int[] getAllStatusValues() {
        return VALID_STATUS_VALUES;
    }

    public int getPacketOID() {
        return this.packetOID;
    }

    public void setPacketOID(int n) {
        this.packetOID = n;
    }

    public int getTargetHostSIID() {
        return this.targetHostSIID;
    }

    public void setTargetHostSIID(int n) {
        this.targetHostSIID = n;
    }

    public int getDestinationPIID() {
        return this.destinationPIID;
    }

    public void setDestinationPIID(int n) {
        this.destinationPIID = n;
    }

    public Timestamp getInstallDateTime() {
        return this.installDateTime;
    }

    public void setInstallDateTime(Timestamp timestamp) {
        this.installDateTime = timestamp;
    }

    public int getStatus() {
        return this.status;
    }

    public void setLegacy(boolean bl) {
        this.legacy = bl;
    }

    public boolean getLegacy() {
        return this.legacy;
    }

    public boolean isLegacy() {
        return this.getLegacy();
    }

    public String getPacketName() {
        return this.packetName;
    }

    public String getPacketDescription() {
        return this.packetDescription;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getProductName() {
        return this.productName;
    }

    public boolean getInstallNow() {
        return this.installNow;
    }

    public boolean isInstallNow() {
        return this.installNow;
    }

    public String getStatusString() {
        switch (this.status) {
            case 2: {
                return STATUS_NOT_PROCESSED_STRING;
            }
            case 3: {
                return STATUS_IN_PROCESS_STRING;
            }
            case 5: {
                return STATUS_PROCESSED_STRING;
            }
            case 7: {
                return STATUS_FAILED_STRING;
            }
            case 11: {
                return STATUS_REVERSED_STRING;
            }
        }
        return STATUS_UNKNOWN_STRING;
    }

    public void setStatus(int n) {
        if (!PacketDistribution.isValidStatus(n)) {
            throw new IllegalArgumentException("Invalid packet distribution status value.");
        }
        this.status = n;
    }

    public void setPacketName(String string) {
        this.packetName = string;
    }

    public void setPacketDescription(String string) {
        this.packetDescription = string;
    }

    public void setDestinationName(String string) {
        this.destinationName = string;
    }

    public void setProductName(String string) {
        this.productName = string;
    }

    public void setInstallNow(boolean bl) {
        Timestamp timestamp;
        this.installNow = bl;
        this.installDateTime = bl ? new NowTimestamp() : (timestamp = new Timestamp(this.installDateTime.getTime()));
    }

    public int hashCode() {
        int n = 7;
        n = 13 * n + this.packetOID;
        n = 13 * n + this.targetHostSIID;
        n = 13 * n + this.destinationPIID;
        n = 13 * n + (int)(this.installDateTime.getTime() ^ this.installDateTime.getTime() >>> 32);
        n = 13 * n + (this.installNow ? 1 : 0);
        n = 13 * n + this.status;
        n = 13 * n + (this.legacy ? 1 : 0);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PacketDistribution packetDistribution = (PacketDistribution)object;
        return super.equals(object) && Equal.isEqual(this.packetOID, packetDistribution.packetOID) && Equal.isEqual(this.targetHostSIID, packetDistribution.targetHostSIID) && Equal.isEqual(this.destinationPIID, packetDistribution.destinationPIID) && Equal.isEqual(this.installDateTime, packetDistribution.installDateTime) && Equal.isEqual(this.installNow, packetDistribution.installNow) && Equal.isEqual(this.status, packetDistribution.status) && Equal.isEqual(this.legacy, packetDistribution.legacy);
    }

    public static boolean isValidStatus(int n) {
        if (n == 3) {
            return true;
        }
        if (n == 2) {
            return true;
        }
        if (n == 5) {
            return true;
        }
        if (n == 7) {
            return true;
        }
        return n == 11;
    }

    public static String getStatusAsString(int n) {
        switch (n) {
            case 2: {
                return STATUS_NOT_PROCESSED_STRING;
            }
            case 3: {
                return STATUS_IN_PROCESS_STRING;
            }
            case 5: {
                return STATUS_PROCESSED_STRING;
            }
            case 7: {
                return STATUS_FAILED_STRING;
            }
            case 11: {
                return STATUS_REVERSED_STRING;
            }
        }
        return STATUS_UNKNOWN_STRING;
    }
}

