/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.Identifiable;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.core.network.SystemIID;
import com.helpsystems.common.core.util.Equal;

public class NodeProxy
extends Proxy
implements Identifiable {
    public static final int PRIMARY = 0;
    public static final int HOST = 1;
    public static final int ALTERNATE = 2;
    public static final int REMOTE = 3;
    public static final int REMOTE_HOST = 4;
    private static final long serialVersionUID = 3039358070995615073L;
    private int siid;
    private int type;

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.type = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("The type is not valid.");
            }
        }
    }

    public int getSystemIIDInt() {
        return this.siid;
    }

    public void setSystemIIDInt(int n) {
        this.siid = n;
    }

    public SystemIID getSystemIID() {
        return new SystemIID(this.siid);
    }

    public void setSystemIID(SystemIID systemIID) {
        this.siid = systemIID.getID();
    }

    public int hashCode() {
        return this.getProductIIDInt() * 80;
    }

    @Override
    public void setIdentifier(BasicIdentifier basicIdentifier) {
        if (basicIdentifier == null || !(basicIdentifier instanceof ProductIID)) {
            throw new IllegalArgumentException("The identifier " + basicIdentifier + " is not valid - it must be a ProductIID");
        }
        super.setIdentifier(basicIdentifier);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof NodeProxy)) {
            return false;
        }
        NodeProxy nodeProxy = (NodeProxy)object;
        return super.equals(object) && Equal.isEqual(nodeProxy.siid, this.siid) && Equal.isEqual(nodeProxy.type, this.type);
    }
}

