/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.network.LegacyDQEntry;
import junit.framework.TestCase;

public class LegacyDQEntryTest
extends TestCase {
    LegacyDQEntry entry;

    protected void setUp() throws Exception {
        super.setUp();
        this.entry = new LegacyDQEntry(new byte[0], "", 0);
    }

    protected void tearDown() throws Exception {
        this.entry = null;
        super.tearDown();
    }

    public void testGetProductName() {
        this.entry.setProductName("product_name");
        LegacyDQEntryTest.assertEquals((String)"product_name", (String)this.entry.getProductName());
    }

    public void testGetProductCode() {
        this.entry.setProductCode("product_code");
        LegacyDQEntryTest.assertEquals((String)"product_code", (String)this.entry.getProductCode());
    }

    public void testGetRecordType() {
        this.entry.setRecordType("record_type");
        LegacyDQEntryTest.assertEquals((String)"record_type", (String)this.entry.getRecordType());
    }

    public void testGetRelMod() {
        this.entry.setRelMod("R25M36");
        LegacyDQEntryTest.assertEquals((String)"R25M36", (String)this.entry.getRelMod());
    }

    public void testGetFileName() {
        this.entry.setFileName("file_name");
        LegacyDQEntryTest.assertEquals((String)"file_name", (String)this.entry.getFileName());
    }

    public void testGetStatusDate() {
        this.entry.setStatusDate("status_date");
        LegacyDQEntryTest.assertEquals((String)"status_date", (String)this.entry.getStatusDate());
    }

    public void testGetStatusTime() {
        this.entry.setStatusTime("status_time");
        LegacyDQEntryTest.assertEquals((String)"status_time", (String)this.entry.getStatusTime());
    }

    public void testGetStatusKey() {
        this.entry.setStatusKey("status_key");
        LegacyDQEntryTest.assertEquals((String)"status_key", (String)this.entry.getStatusKey());
    }

    public void testGetFromSystem() {
        this.entry.setFromSystem("from_system");
        LegacyDQEntryTest.assertEquals((String)"from_system", (String)this.entry.getFromSystem());
    }

    public void testGetToSystem() {
        this.entry.setToSystem("to_system");
        LegacyDQEntryTest.assertEquals((String)"to_system", (String)this.entry.getToSystem());
    }

    public void testGetStatusSeverity() {
        this.entry.setStatusSeverity("severity");
        LegacyDQEntryTest.assertEquals((String)"severity", (String)this.entry.getStatusSeverity());
    }

    public void testIsStatusReplyRequired() {
        this.entry.setStatusReplyRequired(false);
        LegacyDQEntryTest.assertFalse((boolean)this.entry.isStatusReplyRequired());
        this.entry.setStatusReplyRequired(true);
        LegacyDQEntryTest.assertTrue((boolean)this.entry.isStatusReplyRequired());
    }

    public void testGetLongDescription() {
        this.entry.setLongDescription("long_description");
        LegacyDQEntryTest.assertEquals((String)"long_description", (String)this.entry.getLongDescription());
    }

    public void testGetStatusData() {
        byte[] byArray = new byte[]{115, 116, 115, 95, 100, 116, 97};
        this.entry.setStatusData(byArray);
        LegacyDQEntryTest.assertEquals((Object)byArray, (Object)this.entry.getStatusData());
    }

    public void testGetStatusDataAsString() {
        this.entry.setStatusDataAsString("sts_dta");
        LegacyDQEntryTest.assertEquals((String)"sts_dta", (String)this.entry.getStatusDataAsString());
    }

    public void testGetRecordData() {
        this.entry.setRecordData("record_data");
        LegacyDQEntryTest.assertEquals((String)"record_data", (String)this.entry.getRecordData());
    }

    public void testGetBinaryData() {
        byte[] byArray = new byte[]{98, 105, 110, 95, 100, 116, 97};
        this.entry.setBinaryData(byArray);
        LegacyDQEntryTest.assertEquals((Object)byArray, (Object)this.entry.getBinaryData());
    }

    public void testGetType() {
        this.entry.setType(1234);
        LegacyDQEntryTest.assertEquals((int)1234, (int)this.entry.getType());
    }

    public void testGetTypeString() {
        this.entry.setType(0);
        LegacyDQEntryTest.assertNotNull((Object)this.entry.getTypeString());
        this.entry.setType(1);
        LegacyDQEntryTest.assertNotNull((Object)this.entry.getTypeString());
        this.entry.setType(2);
        LegacyDQEntryTest.assertNotNull((Object)this.entry.getTypeString());
        this.entry.setType(3);
        LegacyDQEntryTest.assertNotNull((Object)this.entry.getTypeString());
        this.entry.setType(4);
        LegacyDQEntryTest.assertNotNull((Object)this.entry.getTypeString());
        this.entry.setType(5);
        LegacyDQEntryTest.assertNotNull((Object)this.entry.getTypeString());
        this.entry.setType(6);
        LegacyDQEntryTest.assertNotNull((Object)this.entry.getTypeString());
        this.entry.setType(-1);
        LegacyDQEntryTest.assertNotNull((Object)this.entry.getTypeString());
    }

    public void testGetCcsid() {
        this.entry.setCcsid(12345);
        LegacyDQEntryTest.assertEquals((int)12345, (int)this.entry.getCcsid());
    }

    public void testGetFormat() {
        this.entry.setFormat("format");
        LegacyDQEntryTest.assertEquals((String)"format", (String)this.entry.getFormat());
    }

    public void testGetByteData() {
        byte[] byArray = new byte[]{98, 121, 116, 101, 95, 100, 116, 97};
        this.entry.setByteData(byArray);
        LegacyDQEntryTest.assertEquals((Object)byArray, (Object)this.entry.getByteData());
    }

    public void testGetJobNumber() {
        this.entry.setJobNumber("job_number");
        LegacyDQEntryTest.assertEquals((String)"job_number", (String)this.entry.getJobNumber());
    }

    public void testGetJobName() {
        this.entry.setJobName("job_name");
        LegacyDQEntryTest.assertEquals((String)"job_name", (String)this.entry.getJobName());
    }

    public void testGetJobUser() {
        this.entry.setJobUser("job_user");
        LegacyDQEntryTest.assertEquals((String)"job_user", (String)this.entry.getJobUser());
    }

    public void testIsStatusRequired() {
        this.entry.setStatusRequired(true);
        LegacyDQEntryTest.assertTrue((boolean)this.entry.isStatusRequired());
        this.entry.setStatusRequired(false);
        LegacyDQEntryTest.assertFalse((boolean)this.entry.isStatusRequired());
    }

    public void testIsDataReplicationRequired() {
        this.entry.setDataReplicationRequired(true);
        LegacyDQEntryTest.assertTrue((boolean)this.entry.isDataReplicationRequired());
        this.entry.setDataReplicationRequired(false);
        LegacyDQEntryTest.assertFalse((boolean)this.entry.isDataReplicationRequired());
    }

    public void testToString() {
        this.entry.setProductName("product_name");
        this.entry.setFileName("file_name");
        this.entry.setRecordData("record_data");
        String string = "Product: product_name  File: file_nameData: record_data";
        String string2 = this.entry.toString();
        LegacyDQEntryTest.assertEquals((String)string, (String)string2);
    }
}

