/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.license;

import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.license.AgentLicenseTier;
import com.helpsystems.common.core.license.LicenseKey;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TierKey
extends LicenseKey {
    private static final long serialVersionUID = -213207821777468155L;
    public static final int UNLIMITED_TIER_VALUE = 99999;
    private int version;
    private Map<AgentLicenseTier, Integer> pointMap;

    public TierKey() {
        this.pointMap = new HashMap<AgentLicenseTier, Integer>();
    }

    public TierKey(String string, String string2, long l) {
        this.setProductCode(string);
        this.setHardwareCode(string2);
        this.setExpirationDate(l);
    }

    public static TierKey createLicenseKey(String string, EncryptUtil encryptUtil) throws IOException {
        TierKey tierKey = new TierKey();
        tierKey.setEncryptedKey(string, encryptUtil);
        return tierKey;
    }

    @Override
    public void setEncryptedKey(String string, EncryptUtil encryptUtil) throws IOException {
        Object object;
        String string2;
        int n;
        if (encryptUtil == null) {
            throw new NullPointerException("The encryption utilities passed in were null.");
        }
        ValidationHelper.checkForNull("License", string);
        String string3 = EncryptUtil.cleanBeforeDecode(string);
        if (!TierKey.verifyChecksum(string3)) {
            throw new IOException("Checksum failed.");
        }
        string3 = string3.substring(0, string3.length() - 3);
        byte[] byArray = null;
        try {
            byArray = encryptUtil.decodeBase32ToBinary(string3);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Unable to decode the license key");
            iOException.initCause(exception);
            throw iOException;
        }
        String string4 = new String(byArray, "ISO8859_1");
        StringBuffer stringBuffer = new StringBuffer(string4);
        if (stringBuffer.length() < 15) {
            throw new IOException("Decoded key length too small.");
        }
        string4 = stringBuffer.toString();
        this.setHardwareCode(string4.substring(0, 10));
        string4 = string4.substring(10);
        stringBuffer.delete(0, 10);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 8; i > -1; --i) {
            n = stringBuffer.charAt(i);
            if (n < 65 || n > 90) continue;
            stringBuffer2.append((char)n);
            stringBuffer.deleteCharAt(i);
        }
        this.setProductCode(stringBuffer2.reverse().toString());
        try {
            long l = Long.parseLong(stringBuffer.substring(0, 6)) * 10811194L;
            if (l < 0L) {
                l = 0L;
            }
            this.setExpirationDate(l);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad data within encoded key.");
        }
        stringBuffer.delete(0, 6);
        char c = stringBuffer.charAt(0);
        this.setKeyType(c % 3);
        stringBuffer.delete(0, 1);
        n = stringBuffer.charAt(0);
        if (n > 128) {
            this.flags = (byte)(n &= 0x7F);
            stringBuffer.deleteCharAt(0);
        }
        if ((string2 = stringBuffer.toString()).length() >= 2) {
            Object object2;
            object = Character.valueOf(string2.charAt(0));
            if (Character.isISOControl(((Character)object).charValue())) {
                string2 = string2.substring(1);
            }
            if (!Character.isDigit(((Character)(object2 = Character.valueOf(string2.charAt(1)))).charValue())) {
                this.setLicenseKeyVersion(0);
                return;
            }
        }
        for (Object object3 : object = string2.split("(?=[a-zA-Z])")) {
            char c2;
            if (((String)object3).length() < 2 || (c2 = ((String)object3).charAt(0)) > 'Z') continue;
            object3 = ((String)object3).substring(1);
            int n2 = Integer.parseInt((String)object3);
            if (c2 == 'S') {
                this.setLicenseKeyVersion(n2);
                continue;
            }
            AgentLicenseTier agentLicenseTier = AgentLicenseTier.getTier(c2);
            if (agentLicenseTier == null) continue;
            this.setPoints(agentLicenseTier, n2);
        }
    }

    public int getLicenseKeyVersion() {
        return this.version;
    }

    private void setLicenseKeyVersion(int n) {
        this.version = n;
    }

    public int getPoints(int n) {
        Integer n2 = this.pointMap.get((Object)AgentLicenseTier.getTier(n));
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public int getPoints(AgentLicenseTier agentLicenseTier) {
        Integer n = this.pointMap.get((Object)agentLicenseTier);
        if (n == null) {
            return 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPoints(AgentLicenseTier agentLicenseTier, int n) {
        if (n < 0 || n > 99999) {
            throw new IllegalArgumentException("Invalid point value");
        }
        Map<AgentLicenseTier, Integer> map = this.pointMap;
        synchronized (map) {
            this.pointMap.put(agentLicenseTier, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(' ');
        stringBuffer.append("Version=");
        stringBuffer.append(this.version);
        stringBuffer.append(' ');
        Map<AgentLicenseTier, Integer> map = this.pointMap;
        synchronized (map) {
            boolean bl = true;
            for (AgentLicenseTier agentLicenseTier : this.pointMap.keySet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                int n = this.pointMap.get((Object)agentLicenseTier);
                stringBuffer.append(agentLicenseTier.characterCode());
                stringBuffer.append("=");
                stringBuffer.append(n);
            }
        }
        switch (this.keyType) {
            case 0: {
                stringBuffer.append(", Trial license");
                break;
            }
            case 1: {
                stringBuffer.append(", Perm code");
                break;
            }
            case 2: {
                stringBuffer.append(", ELA key");
                break;
            }
            default: {
                stringBuffer.append(", unknown type");
            }
        }
        stringBuffer.append(", flags=0x");
        stringBuffer.append(Integer.toHexString(this.flags));
        return stringBuffer.toString();
    }
}

