/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.filter.AbstractFilterField;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.io.Serializable;

public class FilterFieldLong
extends AbstractFilterField {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(FilterFieldLong.class.getName());
    private static final long serialVersionUID = -109609222107060787L;
    public static final String ZERO = "0";
    private String[] intOperators = new String[]{"0", "1", "2", "3", "4", "5"};
    private long maxValue;
    private boolean requiredValue;

    public FilterFieldLong() {
    }

    public FilterFieldLong(String string, String string2, long l, boolean bl) {
        super(string, string2, 1);
        this.setOperatorArray(this.intOperators);
        this.maxValue = l;
        this.requiredValue = bl;
    }

    @Override
    public boolean valid(int n, Object object) {
        Long l = this.convertValue(object);
        if (l > this.maxValue) {
            throw new IllegalArgumentException(rbh.getMsg("exceed_max", this.displayName, String.valueOf(this.maxValue)));
        }
        return super.valid(n, object);
    }

    private Long convertValue(Object object) {
        Long l = null;
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                if (this.requiredValue) {
                    throw new IllegalArgumentException(rbh.getMsg("require_value", this.displayName));
                }
                string = ZERO;
            }
        } else {
            throw new IllegalArgumentException(object + " was not passed as a String data type");
        }
        try {
            l = Long.valueOf((String)object);
        }
        catch (Exception exception) {
            String string = rbh.getMsg("must_be_whole", this.displayName, String.valueOf(this.maxValue));
            throw new IllegalArgumentException(string);
        }
        return l;
    }

    @Override
    public FilterCriteria getFilterCriteria(int n, Serializable serializable) {
        this.valid(n, serializable);
        return new FilterCriteria(this.fieldName, this.convertValue(serializable), n);
    }

    @Override
    public Serializable getValueFromCriteria(FilterCriteria filterCriteria) {
        return filterCriteria.getValue().toString();
    }
}

