/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.busobj.UserIdentityProxy;
import java.io.Serializable;
import junit.framework.TestCase;

public class UserIdentityTest
extends TestCase {
    UserIdentity uid;

    protected void setUp() throws Exception {
        super.setUp();
        this.uid = new UserIdentity();
    }

    protected void tearDown() throws Exception {
        this.uid = null;
        super.tearDown();
    }

    public void testSetName() {
        this.uid.setName("MyName");
        UserIdentityTest.assertEquals((String)"MyName", (String)this.uid.getName());
        this.uid.setName("NewName");
        UserIdentityTest.assertEquals((String)"NewName", (String)this.uid.getName());
    }

    public void testNameIsImmutableForNoUserSpecified() {
        try {
            UserIdentity.NO_USER_SPECIFIED.setName("NewName");
            UserIdentityTest.fail((String)"NO_USER_SPECIFIED allowed name change");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetSystem() {
        this.uid.setSystem("System");
        UserIdentityTest.assertEquals((String)"System", (String)this.uid.getSystem());
        this.uid.setSystem("NewSystem");
        UserIdentityTest.assertEquals((String)"NewSystem", (String)this.uid.getSystem());
    }

    public void testSystemIsImmutableForNoUserSpecified() {
        try {
            UserIdentity.NO_USER_SPECIFIED.setSystem("NewSystem");
            UserIdentityTest.fail((String)"NO_USER_SPECIFIED allowed system change");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testUserIdentityConstructorNameSystem() {
        UserIdentity userIdentity = new UserIdentity("MyName", "MySystem");
        UserIdentityTest.assertEquals((String)"MyName", (String)userIdentity.getName());
        UserIdentityTest.assertEquals((String)"MySystem", (String)userIdentity.getSystem());
    }

    public void testAddGroup() {
        this.uid.addGroup("MyGroup");
        String[] stringArray = this.uid.getGroups();
        UserIdentityTest.assertTrue((boolean)this.contains(stringArray, "MyGroup"));
        this.uid.addGroup("MyOtherGroup");
        stringArray = this.uid.getGroups();
        UserIdentityTest.assertTrue((boolean)this.contains(stringArray, "MyGroup"));
        UserIdentityTest.assertTrue((boolean)this.contains(stringArray, "MyOtherGroup"));
    }

    public void testAddIdentity() {
        this.uid.setSystem("MySystem");
        UserIdentity userIdentity = new UserIdentity("InnerID1", "InnerSystem1");
        this.uid.addIdentity(userIdentity);
        UserIdentity userIdentity2 = new UserIdentity("InnerID2", "InnerSystem2");
        this.uid.addIdentity(userIdentity2);
        UserIdentity[] userIdentityArray = this.uid.getIdentities();
        UserIdentityTest.assertTrue((boolean)this.contains(userIdentityArray, userIdentity));
        UserIdentityTest.assertTrue((boolean)this.contains(userIdentityArray, userIdentity2));
        UserIdentity userIdentity3 = new UserIdentity("InnerID3", "InnerSystem2");
        this.uid.addIdentity(userIdentity3);
        userIdentityArray = this.uid.getIdentities();
        UserIdentityTest.assertTrue((boolean)this.contains(userIdentityArray, userIdentity));
        UserIdentityTest.assertFalse((boolean)this.contains(userIdentityArray, userIdentity2));
        UserIdentityTest.assertTrue((boolean)this.contains(userIdentityArray, userIdentity3));
        try {
            this.uid.addIdentity(new UserIdentity("OtherName", "MySystem"));
            UserIdentityTest.fail((String)"addIdentity(UserIdentity) allowed child with same system name as parent");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetIdentity() {
        try {
            this.uid.getIdentity(null);
            UserIdentityTest.fail((String)"getIdentity(String) accepted null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.uid.setSystem("MySystem");
        UserIdentity userIdentity = this.uid.getIdentity("MySystem");
        UserIdentityTest.assertTrue((userIdentity == this.uid ? 1 : 0) != 0);
        UserIdentity userIdentity2 = new UserIdentity("OtherID", "OtherSystem");
        this.uid.addIdentity(userIdentity2);
        userIdentity = this.uid.getIdentity("OtherSystem");
        UserIdentityTest.assertEquals((Object)userIdentity2, (Object)userIdentity);
        userIdentity = this.uid.getIdentity("BogusSystem");
        UserIdentityTest.assertNull((Object)userIdentity);
    }

    public void testRemoveGroup() {
        this.uid.addGroup("MyGroup");
        this.uid.addGroup("MyOtherGroup");
        String[] stringArray = this.uid.getGroups();
        UserIdentityTest.assertTrue((boolean)this.contains(stringArray, "MyGroup"));
        UserIdentityTest.assertTrue((boolean)this.contains(stringArray, "MyOtherGroup"));
        this.uid.removeGroup("MyGroup");
        stringArray = this.uid.getGroups();
        UserIdentityTest.assertFalse((boolean)this.contains(stringArray, "MyGroup"));
        UserIdentityTest.assertTrue((boolean)this.contains(stringArray, "MyOtherGroup"));
    }

    public void testRemoveIdentity() {
        UserIdentity userIdentity = new UserIdentity("InnerID1", "InnerSystem1");
        this.uid.addIdentity(userIdentity);
        UserIdentity userIdentity2 = new UserIdentity("InnerID2", "InnerSystem2");
        this.uid.addIdentity(userIdentity2);
        UserIdentity[] userIdentityArray = this.uid.getIdentities();
        UserIdentityTest.assertTrue((boolean)this.contains(userIdentityArray, userIdentity));
        UserIdentityTest.assertTrue((boolean)this.contains(userIdentityArray, userIdentity2));
        this.uid.removeIdentity("InnerSystem1");
        userIdentityArray = this.uid.getIdentities();
        UserIdentityTest.assertFalse((boolean)this.contains(userIdentityArray, userIdentity));
        UserIdentityTest.assertTrue((boolean)this.contains(userIdentityArray, userIdentity2));
    }

    public void testRemoveAttribute() {
        this.uid.setAttribute((Serializable)((Object)"MyAttrib1"), new Integer(1024));
        String[] stringArray = (String[])this.uid.getAttributeNames();
        UserIdentityTest.assertTrue((boolean)this.contains(stringArray, "MyAttrib1"));
        UserIdentityTest.assertEquals((Object)1024, (Object)this.uid.getAttribute((Serializable)((Object)"MyAttrib1")));
        this.uid.removeAttribute((Serializable)((Object)"MyAttrib1"));
        stringArray = (String[])this.uid.getAttributeNames();
        UserIdentityTest.assertFalse((boolean)this.contains(stringArray, "MyAttrib1"));
    }

    public void testSetAttribute() {
        this.uid.setAttribute((Serializable)((Object)"MyAttrib1"), new Integer(1024));
        Serializable serializable = this.uid.getAttribute((Serializable)((Object)"MyAttrib1"));
        Integer n = new Integer(1024);
        UserIdentityTest.assertTrue((boolean)serializable.getClass().equals(n.getClass()));
        Integer n2 = (Integer)serializable;
        UserIdentityTest.assertEquals((Object)n, (Object)n2);
        this.uid.setAttribute((Serializable)((Object)"MyAttrib1"), null);
        String[] stringArray = (String[])this.uid.getAttributeNames();
        UserIdentityTest.assertFalse((boolean)this.contains(stringArray, "MyAttrib1"));
    }

    public void testSetLastLogin() {
        UserIdentityTest.assertEquals((long)0L, (long)this.uid.getLastLogin());
        this.uid.setLastLogin(12345L);
        UserIdentityTest.assertEquals((long)12345L, (long)this.uid.getLastLogin());
    }

    public void testSetWhenSaved() {
        this.uid.setWhenSaved(23456L);
        UserIdentityTest.assertEquals((long)23456L, (long)this.uid.getWhenSaved());
    }

    public void testSetCurrentLogin() {
        this.uid.setCurrentLogin(1234567L);
        UserIdentityTest.assertEquals((long)1234567L, (long)this.uid.getCurrentLogin());
    }

    public void testSetFlags() {
        this.uid.setFlags(234);
        UserIdentityTest.assertEquals((int)234, (int)this.uid.getFlags());
    }

    public void testSetEncryptedPassword() {
        this.uid.setEncryptedPassword("encPassword");
        UserIdentityTest.assertEquals((String)"encPassword", (String)this.uid.getEncryptedPassword());
        this.uid.setEncryptedPassword(null);
        UserIdentityTest.assertEquals((String)"", (String)this.uid.getEncryptedPassword());
    }

    public void testSetParentIdentity() {
        UserIdentity userIdentity = new UserIdentity("MyParent", "ParentSystem");
        this.uid.setParentIdentity(userIdentity);
        UserIdentity userIdentity2 = this.uid.getParentIdentity();
        UserIdentityTest.assertEquals((Object)userIdentity, (Object)userIdentity2);
    }

    public void testSetParentOID() {
        UserIdentityTest.assertEquals((int)-1, (int)this.uid.getParentOID());
        UserIdentity userIdentity = new UserIdentity("MyParent", "ParentSystem");
        userIdentity.setOID(1234);
        this.uid.setParentIdentity(userIdentity);
        UserIdentityTest.assertEquals((int)1234, (int)this.uid.getParentOID());
        this.uid.setParentOID(12345);
        UserIdentityTest.assertEquals((int)1234, (int)this.uid.getParentOID());
    }

    public void testSetPasswordState() {
        this.uid.setPasswordState(0);
        UserIdentityTest.assertEquals((int)0, (int)this.uid.getPasswordState());
        this.uid.setPasswordState(1);
        UserIdentityTest.assertEquals((int)1, (int)this.uid.getPasswordState());
        this.uid.setPasswordState(-1);
        UserIdentityTest.assertEquals((int)-1, (int)this.uid.getPasswordState());
    }

    public void testSetPasswordStateRejectsInvalidValue() {
        try {
            this.uid.setPasswordState(-2983892);
            UserIdentityTest.fail((String)"setPasswordState(int) accepted an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEqualsObject() {
        UserIdentityTest.assertFalse((boolean)this.uid.equals(null));
        UserIdentityTest.assertFalse((boolean)this.uid.equals(new Object()));
        this.uid.setName("MyUser");
        this.uid.setSystem("MySystem");
        this.uid.setEncryptedPassword("12345");
        UserIdentity userIdentity = new UserIdentity("MyUser", "MySystem");
        userIdentity.setEncryptedPassword("12346");
        UserIdentityTest.assertFalse((boolean)this.uid.equals(userIdentity));
        userIdentity.setEncryptedPassword("12345");
        UserIdentityTest.assertTrue((boolean)this.uid.equals(userIdentity));
    }

    public void testProxyNotEqualsNonProxyObject() {
        UserIdentityProxy userIdentityProxy = new UserIdentityProxy();
        UserIdentityTest.assertFalse((boolean)userIdentityProxy.equals(new Object()));
    }

    private boolean contains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(UserIdentity[] userIdentityArray, UserIdentity userIdentity) {
        for (UserIdentity userIdentity2 : userIdentityArray) {
            if (!userIdentity2.equals(userIdentity)) continue;
            return true;
        }
        return false;
    }
}

