/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.dataset.CachingDataSet;

public class DataSetList<T>
extends CachingDataSet<T> {
    private int position = -1;

    public DataSetList(DataSet<T> dataSet) throws DataSetException {
        super(dataSet);
    }

    public DataSetList(DataSet<T> dataSet, int n, int n2) throws DataSetException {
        super(dataSet, n, n2);
    }

    public boolean absolute(int n) throws DataSetException {
        this.position = n;
        return this.isPointerPositionValid();
    }

    public T get() throws DataSetException, BadDataException {
        if (this.position < 0) {
            throw new DataSetException("The position is in an invalid position (-1)");
        }
        return this.get(this.position);
    }

    private boolean isPointerPositionValid() throws DataSetException {
        return this.position >= -1 && this.position < this.size();
    }

    public boolean next() throws DataSetException {
        ++this.position;
        return this.isPointerPositionValid();
    }

    public boolean previous() throws DataSetException {
        --this.position;
        if (this.position < 0) {
            return false;
        }
        return this.isPointerPositionValid();
    }

    public boolean relative(int n) throws DataSetException {
        return this.absolute(n + this.position);
    }
}

