/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.ExceptionErrorList;
import java.io.Serializable;

public class BadDataArrayException
extends DataException
implements Serializable {
    private ErrorTable errorTable;
    private Object[] array;

    public BadDataArrayException(String string, Object[] objectArray, ErrorTable errorTable) {
        super(string);
        if (objectArray == null) {
            throw new NullPointerException("The array passed in is null.");
        }
        if (errorTable == null) {
            throw new NullPointerException("The error table passed in is null.");
        }
        this.array = objectArray;
        this.errorTable = errorTable;
    }

    public Object[] getArray() {
        return this.array;
    }

    public ErrorTable getErrors() {
        return this.errorTable;
    }

    public BadDataException createBadDataException(int n) {
        if (n < 0 || n >= this.array.length) {
            throw new ArrayIndexOutOfBoundsException("The index " + n + " is not valid.");
        }
        ErrorList errorList = this.errorTable.getErrorsForIndex(n);
        if (errorList == null) {
            return null;
        }
        BadDataException badDataException = new BadDataException(this.array[n], errorList);
        if (errorList instanceof ExceptionErrorList) {
            ExceptionErrorList exceptionErrorList = (ExceptionErrorList)errorList;
            Exception[] exceptionArray = exceptionErrorList.getExceptions();
            if (exceptionArray.length == 1 && exceptionArray[0] instanceof BadDataException) {
                return (BadDataException)exceptionArray[0];
            }
            Exception exception = badDataException;
            for (int i = 0; i < exceptionArray.length; ++i) {
                exception.initCause(exceptionArray[i]);
                exception = exceptionArray[i];
            }
        }
        return badDataException;
    }
}

