/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.preconditions;

import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.peer.preconditions.AbstractJobConditionValidator;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class CheckUDPService
extends AbstractJobConditionValidator {
    private static final Logger logger = Logger.getLogger(CheckUDPService.class);

    public boolean checkCondition(JobCondition jobCondition) {
        return jobCondition.isConditionChoice() ? this.isAvailableService(jobCondition) : !this.isAvailableService(jobCondition);
    }

    private boolean isAvailableService(JobCondition jobCondition) {
        return this.checkForUDPService(jobCondition.getConditionData().trim(), jobCondition.getConditionVar1(), jobCondition.getConditionVar2());
    }

    private boolean checkForUDPService(String string, int n, int n2) {
        if (n2 > 0) {
            return this.checkUDPServiceWithTimeout(string, n, n2);
        }
        return this.checkUDPService(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUDPServiceWithTimeout(final String string, final int n, int n2) {
        boolean bl = false;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        DatagramSocket datagramSocket = null;
        try {
            final DatagramSocket datagramSocket2 = datagramSocket = new DatagramSocket();
            Future<Boolean> future = executorService.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws UnknownHostException {
                    datagramSocket2.connect(InetAddress.getByName(string), n);
                    return true;
                }
            });
            bl = future.get(n2, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            bl = false;
            logger.debug((Object)"InterruptedException. ", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            bl = false;
            logger.debug((Object)"ExecutionException. ", (Throwable)executionException);
        }
        catch (TimeoutException timeoutException) {
            bl = false;
            logger.debug((Object)"TimeoutException", (Throwable)timeoutException);
        }
        catch (SocketException socketException) {
            bl = false;
            logger.debug((Object)"SocketException", (Throwable)socketException);
        }
        finally {
            executorService.shutdown();
            this.closeSocketQuietly(datagramSocket);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUDPService(String string, int n) {
        boolean bl = false;
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket();
            datagramSocket.connect(InetAddress.getByName(string), n);
            bl = true;
        }
        catch (UnknownHostException unknownHostException) {
            bl = false;
            logger.debug((Object)"UnknownHostException. ", (Throwable)unknownHostException);
        }
        catch (SocketException socketException) {
            bl = false;
            logger.debug((Object)"SocketException. ", (Throwable)socketException);
        }
        finally {
            this.closeSocketQuietly(datagramSocket);
        }
        return bl;
    }

    public String toString(JobCondition jobCondition) {
        return "Checking UDP Service.";
    }

    private void closeSocketQuietly(DatagramSocket datagramSocket) {
        if (datagramSocket != null) {
            datagramSocket.close();
        }
    }
}

