/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.preconditions;

import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.peer.preconditions.AbstractJobConditionValidator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.log4j.Logger;
import org.hyperic.sigar.SigarException;

public class CheckCpuUsage
extends AbstractJobConditionValidator {
    private static final Logger logger = Logger.getLogger(CheckCpuUsage.class);

    public boolean checkCondition(JobCondition jobCondition) {
        try {
            return jobCondition.isConditionChoice() ? this.isReachedCpuUsage(jobCondition) : !this.isReachedCpuUsage(jobCondition);
        }
        catch (SigarException sigarException) {
            logger.debug((Object)"SigarException from hasMinCpuUsage() method", (Throwable)sigarException);
            sigarException.printStackTrace();
            return false;
        }
    }

    public boolean isReachedCpuUsage(JobCondition jobCondition) throws SigarException {
        BigDecimal bigDecimal = new BigDecimal(this.getSigarObject().getCpuPerc().getCombined() * 100.0);
        Long l = new Long(bigDecimal.setScale(0, RoundingMode.HALF_UP).toString());
        return l >= (long)jobCondition.getConditionVar2();
    }

    public String toString(JobCondition jobCondition) {
        StringBuffer stringBuffer = new StringBuffer("Checking CPU usage has ");
        if (!jobCondition.isConditionChoice()) {
            stringBuffer.append(" not ");
        }
        stringBuffer.append(" reached the threshold of ");
        stringBuffer.append(jobCondition.getConditionVar1());
        stringBuffer.append(".");
        return stringBuffer.toString();
    }
}

