/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DurableQueue;
import com.helpsystems.common.core.util.InterruptibleProcess;
import com.helpsystems.enterprise.core.busobj.OutputDistributionHistory;
import com.helpsystems.enterprise.core.dm.OutputDistributionHistoryDM;
import com.helpsystems.enterprise.core.util.OutputDistributionSetup;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.ReadInputThread;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ReportRunnerWatcher
implements Runnable,
InterruptibleProcess {
    private static Logger logger = Logger.getLogger(ReportRunnerWatcher.class);
    public static final String SERVICE_NAME = "Report Runner Service Peer";
    public static final String THREAD_NAME = "Report Runner Watcher Thread";
    private static final int NORMAL_CHECK_TIME = 10000;
    private static final int STARTUP_TIME = 30000;
    private OutputDistributionHistoryDM histDM = null;
    AgentPeer serverPeer = null;
    boolean isShutdown = false;
    boolean isWindows = false;
    int serverport = 0;
    int port = -1235;
    private String dqName;
    private Process process;

    public ReportRunnerWatcher(AgentPeer agentPeer, boolean bl, int n) {
        this.serverPeer = agentPeer;
        this.isWindows = bl;
        this.serverport = n;
    }

    public void shutdown() {
        this.isShutdown = true;
        this.endProcess();
    }

    private OutputDistributionHistoryDM getHistDM() {
        if (this.histDM == null) {
            this.histDM = (OutputDistributionHistoryDM)ManagerRegistry.getManager((String)"ENTERPRISE.OutputDistributionHistoryDM");
        }
        return this.histDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFile(File file) {
        BufferedWriter bufferedWriter = null;
        OutputStreamWriter outputStreamWriter = null;
        if (file == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"The file was missing.  Unable to update the log.");
            }
            return;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Updating the Report log: " + file.getName()));
            }
            outputStreamWriter = new FileWriter(file, true);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.newLine();
            bufferedWriter.write("The report was marked failed by the Report Runner at start-up.");
            bufferedWriter.newLine();
            bufferedWriter.write("Recovery: Use the above parameters to re-run the report to obtain the report.");
            bufferedWriter.newLine();
            bufferedWriter.write("*** REPORT END ***");
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            logger.debug((Object)("Unable to append to the Report log. File: " + file.getName()), (Throwable)iOException);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void markRunningReportsFailed() {
        OutputDistributionHistory[] outputDistributionHistoryArray = new OutputDistributionHistory[]{};
        try {
            outputDistributionHistoryArray = this.getHistDM().getByStatus(4);
            if (outputDistributionHistoryArray.length > 0) {
                for (int i = 0; i < outputDistributionHistoryArray.length; ++i) {
                    OutputDistributionHistory outputDistributionHistory = outputDistributionHistoryArray[i];
                    logger.debug((Object)("Marking running report " + outputDistributionHistory.getFileName() + " failed."));
                    outputDistributionHistory.setStatus(6);
                    try {
                        this.getHistDM().save(outputDistributionHistory);
                        File file = new File(outputDistributionHistory.getLocation(), outputDistributionHistory.getFileName());
                        try {
                            this.updateFile(file);
                        }
                        catch (Exception exception) {
                            logger.debug((Object)("Unable to find the Report Log file to update for the report.  File: " + outputDistributionHistory.getFileName()), (Throwable)exception);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        logger.debug((Object)"Unable to update Report status.", (Throwable)exception);
                    }
                }
            } else {
                logger.debug((Object)"No Reports were running when the Report Runner thread ended.");
            }
        }
        catch (DataException dataException) {
            logger.debug((Object)"No Reports were running when the Report Runner thread ended.");
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.debug((Object)"Unable to cleanup the list of Running reports.", (Throwable)resourceUnavailableException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Finished resolving running reports.");
        }
    }

    @Override
    public void run() {
        int n = 30000;
        this.isShutdown = false;
        try {
            this.markRunningReportsFailed();
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Unable to mark Running Reports failed.", throwable);
        }
        while (!this.isShutdown) {
            try {
                try {
                    Thread.sleep(n);
                    n = 10000;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.serverPeer == null || this.serverPeer.isShutdownRequested() || !this.serverPeer.isStartupComplete() || !this.serverPeer.isReadyForConnections() || !this.dataQueueHasData()) continue;
                try {
                    if (this.serverPeer.getConnectedServicePeers().length != 0) continue;
                    this.startReportRunnerServicePeer();
                }
                catch (Throwable throwable) {
                    logger.error((Object)"Unable to start theReport Runner Service Peer.", throwable);
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Report runner logged the following error.", throwable);
            }
        }
    }

    private void startReportRunnerServicePeer() {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = "";
        if (this.isWindows) {
            stringBuffer.append("cmd.exe /c \"");
            arrayList.add("cmd.exe");
            arrayList.add("/c");
            string = string + "\"";
        }
        String string3 = System.getProperty("user.dir") + File.separatorChar + "reportrunner";
        stringBuffer.append(string3);
        string = string + string3;
        string2 = string2 + string3;
        if (this.isWindows) {
            stringBuffer.append(".bat\"");
            string = string + ".bat\"";
            arrayList.add(string);
        } else {
            stringBuffer.append(".sh");
            string2 = string2 + ".sh";
            arrayList.add(string2);
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.serverport);
        stringBuffer.append(" ");
        stringBuffer.append(this.port);
        arrayList.add(String.valueOf(this.serverport));
        arrayList.add(String.valueOf(this.port));
        try {
            Object object;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"About to start Report Runner Service Peer...");
                logger.trace((Object)stringBuffer);
            }
            try {
                object = new String[]{};
                object = arrayList.toArray((T[])object);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    logger.debug((Object)("ReportRunner Command Part #" + (i + 1) + ": " + (String)object[i]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = Runtime.getRuntime().exec(arrayList.toArray(stringArray));
            ReadInputThread readInputThread = new ReadInputThread(((Process)object).getInputStream(), Level.DEBUG, "Console message from report: ", (Process)object);
            readInputThread.setName("ReadInputThread_ConsoleLog");
            readInputThread.start();
            ReadInputThread readInputThread2 = new ReadInputThread(((Process)object).getErrorStream(), Level.ERROR, "Console error from report: ", (Process)object);
            readInputThread2.setName("ReadInputThread_ErrorLog");
            readInputThread2.start();
        }
        catch (Throwable throwable) {
            logger.error((Object)"The Enterprise Server Driver could not start the Report Runner Service Peer.", throwable);
        }
    }

    public void interrupt() {
        this.isShutdown = true;
        this.endProcess();
    }

    private void endProcess() {
        if (this.process != null) {
            try {
                logger.debug((Object)"Ending report processor...");
                this.process.destroy();
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Error occured ending report processor.", throwable);
            }
        }
    }

    public boolean isInterruptible() {
        return true;
    }

    public boolean wasInterrupted() {
        return this.isShutdown;
    }

    private String getDataQueueFileName() {
        if (this.dqName == null) {
            File file = new File(OutputDistributionSetup.getReportQueueName());
            try {
                this.dqName = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.debug((Object)"Unable to get the actual path to the report data queue.", (Throwable)iOException);
            }
        }
        return this.dqName;
    }

    private DurableQueue getDQ() {
        try {
            return new DurableQueue(this.getDataQueueFileName());
        }
        catch (IOException iOException) {
            logger.error((Object)"Unable connect to the Report Queue.", (Throwable)iOException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dataQueueHasData() {
        DurableQueue durableQueue = this.getDQ();
        if (durableQueue == null) {
            logger.debug((Object)"Unable to check if ReportQueue has reports.");
            return false;
        }
        DurableQueue durableQueue2 = durableQueue;
        synchronized (durableQueue2) {
            boolean bl = false;
            try {
                bl = durableQueue.isEmpty();
                durableQueue.close();
            }
            catch (IOException iOException) {
                logger.debug((Object)"Unable to close DataQueue.", (Throwable)iOException);
            }
            return !bl;
        }
    }
}

